/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.gui.ClosableTabComponent;
import eva2.gui.JExtToolBar;
import eva2.gui.JParaPanel;
import eva2.gui.ModuleButtonPanelMaker;
import eva2.gui.PanelMaker;
import eva2.optimization.InterfaceNotifyOnInformers;
import eva2.problems.InterfaceAdditionalPopulationInformer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;

public class TabbedFrameMaker
implements Serializable,
PanelMaker,
InterfaceNotifyOnInformers {
    private static final Logger LOGGER = Logger.getLogger(TabbedFrameMaker.class.getName());
    private static final long serialVersionUID = 2637376545826821423L;
    private ArrayList<PanelMaker> pmContainer = null;
    private JExtToolBar extToolBar;
    ModuleButtonPanelMaker butPanelMkr = null;
    private JTabbedPane tabbedPane;

    public void addPanelMaker(PanelMaker pm) {
        if (this.pmContainer == null) {
            this.pmContainer = new ArrayList(2);
        }
        this.pmContainer.add(pm);
    }

    @Override
    public JPanel makePanel() {
        JPanel tabControlPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 3;
        gbConstraints.gridy = 0;
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
        this.tabbedPane.setTabLayoutPolicy(1);
        JToolBar tabToolBar = new JToolBar(1);
        tabToolBar.setFloatable(false);
        this.extToolBar = new JExtToolBar();
        this.extToolBar.setFloatable(false);
        for (PanelMaker element : this.pmContainer) {
            JComponent panel = element.makePanel();
            panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            if (element instanceof ModuleButtonPanelMaker) {
                this.extToolBar.add(panel);
                this.butPanelMkr = (ModuleButtonPanelMaker)element;
                continue;
            }
            if (!(element instanceof JParaPanel)) continue;
            this.tabbedPane.addTab(((JParaPanel)element).getName(), panel);
        }
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            this.tabbedPane.setTabComponentAt(i, new ClosableTabComponent(this.tabbedPane, tabToolBar));
        }
        gbConstraints.weighty = 1.0;
        gbConstraints.gridx = 0;
        tabControlPanel.add((Component)tabToolBar, gbConstraints);
        gbConstraints.gridx = 1;
        tabControlPanel.add((Component)this.tabbedPane, gbConstraints);
        this.tabbedPane.validate();
        return tabControlPanel;
    }

    public JExtToolBar getToolBar() {
        return this.extToolBar;
    }

    public void onUserStart() {
        if (this.butPanelMkr != null) {
            this.butPanelMkr.onUserStart();
        } else {
            System.err.println("Error: button panel was null (TabbedFrameMaker)");
        }
    }

    public void refreshPanels() {
        for (PanelMaker jpp : this.pmContainer) {
            if (!(jpp instanceof JParaPanel)) continue;
            ((JParaPanel)jpp).propertyEditor.setValue(((JParaPanel)jpp).propertyEditor.getValue());
        }
    }

    @Override
    public void setInformers(List<InterfaceAdditionalPopulationInformer> informers) {
        try {
            JParaPanel statsPan = this.getStatsPanel();
            if (statsPan.propertyEditor != null) {
                statsPan.propertyEditor.setValue(statsPan.propertyEditor.getValue());
            }
        }
        catch (Exception e) {
            System.err.println("Failed to update statistics panel from " + this.getClass());
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    public JParaPanel getOptimizationParametersPanel() {
        try {
            JParaPanel sP = (JParaPanel)this.pmContainer.get(1);
            return sP;
        }
        catch (Exception e) {
            System.err.println("Failed to get OptimizationParameters panel from " + this.getClass());
            return null;
        }
    }

    public JParaPanel getStatsPanel() {
        try {
            JParaPanel sP = (JParaPanel)this.pmContainer.get(2);
            return sP;
        }
        catch (Exception e) {
            System.err.println("Failed to get statistics panel from " + this.getClass());
            return null;
        }
    }
}

