/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.gui.ToolTipComboBoxRenderer;
import eva2.gui.TypeSelectorItem;
import eva2.gui.editor.GenericObjectEditor;
import eva2.tools.StringTools;
import eva2.util.annotation.Description;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class TypeSelector
extends JComboBox<TypeSelectorItem> {
    private static final Logger LOGGER = Logger.getLogger(TypeSelector.class.getName());
    private DefaultComboBoxModel<TypeSelectorItem> comboBoxModel = new DefaultComboBoxModel(new Vector());

    public void updateClassType(String classTypeName) {
        ArrayList instances = new ArrayList(5);
        ArrayList<String> classesLongNames = GenericObjectEditor.getClassesFromProperties(classTypeName, instances);
        LOGGER.finest("Selected type for OptimizationEditorPanel: " + classTypeName);
        if (classesLongNames.size() > 1) {
            Vector<TypeSelectorItem> classesList = new Vector<TypeSelectorItem>();
            String[] toolTips = this.collectComboToolTips(instances, 100);
            int i = 0;
            for (String className : classesLongNames) {
                String displayName = StringTools.cutClassName(className);
                classesList.add(new TypeSelectorItem(className, displayName, toolTips[i++]));
            }
            this.comboBoxModel = new DefaultComboBoxModel(classesList);
            this.setModel(this.comboBoxModel);
            this.setRenderer(new ToolTipComboBoxRenderer());
        }
    }

    private String[] collectComboToolTips(List<Class<?>> instances, int maxLen) {
        String[] tips = new String[instances.size()];
        for (int i = 0; i < tips.length; ++i) {
            tips[i] = null;
            String tip = null;
            Description description = instances.get(i).getAnnotation(Description.class);
            if (description != null) {
                tip = description.value();
            }
            if (tip == null) continue;
            tips[i] = tip.length() <= maxLen ? tip : tip.substring(0, maxLen - 2) + "..";
        }
        return tips;
    }
}

