/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class AbstractListSelectionEditor
implements PropertyEditor,
PropertyChangeListener {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected JLabel label = new JLabel("Can't edit", 0);
    private JPanel customEditor;
    private JPanel nodePanel;
    protected JCheckBox[] blackCheck;

    private void initCustomEditor() {
        this.customEditor = new JPanel();
        this.customEditor.setLayout(new BorderLayout());
        this.customEditor.add((Component)new JLabel("Choose:"), "North");
        this.nodePanel = new JPanel();
        this.customEditor.add((Component)new JScrollPane(this.nodePanel), "Center");
        this.updateEditor();
    }

    protected abstract int getElementCount();

    protected abstract String getElementName(int var1);

    protected String getElementToolTip(int i) {
        return null;
    }

    protected abstract boolean isElementSelected(int var1);

    private void updateEditor() {
        if (this.nodePanel != null) {
            this.nodePanel.removeAll();
            this.nodePanel.setLayout(new GridLayout(this.getElementCount(), 1));
            this.blackCheck = new JCheckBox[this.getElementCount()];
            for (int i = 0; i < this.getElementCount(); ++i) {
                this.blackCheck[i] = new JCheckBox(this.getElementName(i), this.isElementSelected(i));
                this.blackCheck[i].setToolTipText(this.getElementToolTip(i));
                this.blackCheck[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ev) {
                        if (AbstractListSelectionEditor.this.actionOnSelect()) {
                            AbstractListSelectionEditor.this.propertyChangeSupport.firePropertyChange("AbstractListSelectionEditor", null, this);
                        }
                    }
                });
                this.nodePanel.add(this.blackCheck[i]);
            }
        }
    }

    protected abstract boolean actionOnSelect();

    protected abstract boolean setObject(Object var1);

    @Override
    public void setValue(Object o) {
        if (this.setObject(o)) {
            this.updateEditor();
        }
    }

    @Override
    public abstract Object getValue();

    @Override
    public String getJavaInitializationString() {
        return "";
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException(text);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getAscent()) / 2;
        String rep = this.getAsText();
        if (rep == null) {
            rep = "Select from list";
        }
        gfx.drawString(rep, 2, fm.getHeight() + vpad - 3);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.initCustomEditor();
        }
        return this.customEditor;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange("AbstractListSelectionEditor", null, this);
    }
}

