/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui.editor;

import eva2.gui.BeanInspector;
import eva2.gui.PropertyEditorProvider;
import eva2.gui.PropertyPanel;
import eva2.gui.PropertySelectableList;
import eva2.gui.PropertyText;
import eva2.gui.PropertyValueSelector;
import eva2.gui.editor.EnumEditor;
import eva2.gui.editor.GenericObjectEditor;
import eva2.tools.SerializedObject;
import eva2.tools.StringTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ArrayEditor
extends JPanel
implements PropertyEditor {
    private static final Logger LOGGER = Logger.getLogger(ArrayEditor.class.getName());
    private PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);
    private JLabel cantEditLabel = new JLabel("Can't edit", 0);
    private JList elementList = new JList();
    private Class elementClass = String.class;
    private DefaultListModel listModel;
    private PropertyEditor elementEditor;
    private PropertySelectableList selectableList = null;
    private JButton deleteButton = new JButton("Delete");
    private List<JButton> upperButtonList = new LinkedList<JButton>();
    private List<JButton> lowerButtonList = new LinkedList<JButton>();
    private JComponent additionalCenterComp = null;
    private List<JMenuItem> popupItemList = new LinkedList<JMenuItem>();
    private JButton addButton = new JButton("Add");
    private JButton setButton = new JButton("Set");
    private JButton setAllButton = new JButton("Set all");
    private boolean withAddButton = true;
    private boolean withSetButton = true;
    private boolean withDeleteButton = true;
    private Component view = null;
    private ActionListener innerActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean consistentView;
            if (ArrayEditor.this.view instanceof PropertyText && !(consistentView = ((PropertyText)ArrayEditor.this.view).checkConsistency())) {
                ((PropertyText)ArrayEditor.this.view).updateFromEditor();
            }
            if (e.getSource() == ArrayEditor.this.deleteButton) {
                int[] selected = ArrayEditor.this.elementList.getSelectedIndices();
                if (selected != null) {
                    for (int i = selected.length - 1; i >= 0; --i) {
                        int current = selected[i];
                        ArrayEditor.this.listModel.removeElementAt(current);
                        if (ArrayEditor.this.listModel.size() > current) {
                            ArrayEditor.this.elementList.setSelectedIndex(current);
                        }
                        ArrayEditor.this.elementList.setModel(ArrayEditor.this.listModel);
                    }
                    if (ArrayEditor.this.selectableList != null) {
                        ArrayEditor.this.selectableList.setObjects(ArrayEditor.this.modelToArray(ArrayEditor.this.selectableList.getObjects(), ArrayEditor.this.listModel));
                    }
                    ArrayEditor.this.propChangeSupport.firePropertyChange("", null, null);
                }
                if (ArrayEditor.this.elementList.getSelectedIndex() == -1) {
                    ArrayEditor.this.deleteButton.setEnabled(false);
                }
            } else if (e.getSource() == ArrayEditor.this.addButton) {
                int selected = ArrayEditor.this.elementList.getSelectedIndex();
                Object addObj = ArrayEditor.this.elementEditor.getValue();
                try {
                    SerializedObject so = new SerializedObject(addObj);
                    addObj = so.getObject();
                    so = null;
                    if (selected != -1) {
                        ArrayEditor.this.listModel.insertElementAt(addObj, selected);
                    } else {
                        ArrayEditor.this.listModel.addElement(addObj);
                    }
                    ArrayEditor.this.elementList.setModel(ArrayEditor.this.listModel);
                    if (ArrayEditor.this.selectableList != null) {
                        ArrayEditor.this.selectableList.setObjects(ArrayEditor.this.modelToArray(ArrayEditor.this.selectableList.getObjects(), ArrayEditor.this.listModel));
                    }
                    ArrayEditor.this.propChangeSupport.firePropertyChange("", null, null);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(ArrayEditor.this, "Could not create an object copy", null, 0);
                }
            } else if (e.getSource() == ArrayEditor.this.setAllButton) {
                Object addObj = ArrayEditor.this.elementEditor.getValue();
                for (int i = 0; i < ArrayEditor.this.listModel.size(); ++i) {
                    try {
                        ArrayEditor.this.listModel.setElementAt(new SerializedObject(addObj).getObject(), i);
                        continue;
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(ArrayEditor.this, "Could not create an object copy", null, 0);
                    }
                }
                ArrayEditor.this.propChangeSupport.firePropertyChange("", null, null);
            } else if (e.getSource() == ArrayEditor.this.setButton) {
                int selected = ArrayEditor.this.elementList.getSelectedIndex();
                Object addObj = ArrayEditor.this.elementEditor.getValue();
                if (selected >= 0 && selected < ArrayEditor.this.listModel.size()) {
                    try {
                        ArrayEditor.this.listModel.setElementAt(new SerializedObject(addObj).getObject(), selected);
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(ArrayEditor.this, "Could not create an object copy", null, 0);
                    }
                    ArrayEditor.this.propChangeSupport.firePropertyChange("", null, null);
                }
            }
        }
    };
    private ListSelectionListener innerSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == ArrayEditor.this.elementList && ArrayEditor.this.elementList.getSelectedIndex() != -1) {
                ArrayEditor.this.deleteButton.setEnabled(true);
                ArrayEditor.this.elementEditor.setValue(ArrayEditor.this.elementList.getSelectedValue());
                if (ArrayEditor.this.view instanceof PropertyText) {
                    ((PropertyText)ArrayEditor.this.view).updateFromEditor();
                }
            }
        }
    };

    public void setAdditionalCenterPane(JComponent component) {
        this.additionalCenterComp = component;
    }

    private Object[] modelToArray(Object[] origArray, DefaultListModel listModel) {
        Class<?> objClass = origArray.getClass().getComponentType();
        Object[] os = (Object[])Array.newInstance(objClass, listModel.size());
        for (int i = 0; i < listModel.size(); ++i) {
            os[i] = listModel.get(i);
        }
        return os;
    }

    public ArrayEditor() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.cantEditLabel, "Center");
        this.deleteButton.addActionListener(this.innerActionListener);
        this.addButton.addActionListener(this.innerActionListener);
        this.setAllButton.addActionListener(this.innerActionListener);
        this.setButton.addActionListener(this.innerActionListener);
        this.elementList.addListSelectionListener(this.innerSelectionListener);
        this.addButton.setToolTipText("Add the current item to the list");
        this.deleteButton.setToolTipText("Delete the selected list item");
        this.elementList.addMouseListener(new ActionJList(this.elementList, this));
    }

    public int[] getSelectedIndices() {
        return this.elementList.getSelectedIndices();
    }

    private void updateEditorType(Object obj) {
        this.elementEditor = null;
        this.listModel = null;
        this.view = null;
        this.removeAll();
        if (obj != null && (obj.getClass().isArray() || obj instanceof PropertySelectableList)) {
            T[] arrayInstance = obj;
            if (!obj.getClass().isArray()) {
                arrayInstance = ((PropertySelectableList)obj).getObjects();
                this.selectableList = (PropertySelectableList)obj;
            } else {
                this.selectableList = null;
            }
            Class<?> elementClass = arrayInstance.getClass().getComponentType();
            PropertyEditor editor = PropertyEditorProvider.findEditor(elementClass);
            if (editor instanceof EnumEditor) {
                editor.setValue(obj);
            }
            this.view = null;
            ListCellRenderer<Object> lcr = new DefaultListCellRenderer();
            if (editor != null) {
                if (editor instanceof GenericObjectEditor) {
                    ((GenericObjectEditor)editor).setClassType(elementClass);
                }
                if (editor.isPaintable() && editor.supportsCustomEditor()) {
                    this.view = new PropertyPanel(editor);
                    lcr = new EditorListCellRenderer(editor.getClass(), elementClass);
                } else if (editor.getTags() != null) {
                    this.view = new PropertyValueSelector(editor);
                } else if (editor.getAsText() != null) {
                    this.view = new PropertyText(editor);
                } else if (this.view == null) {
                    this.view = new PropertyText(editor);
                }
            }
            if (this.view == null) {
                LOGGER.log(Level.WARNING, "No property editor for class: {0}", elementClass.getName());
            } else {
                this.elementEditor = editor;
                this.listModel = new DefaultListModel();
                this.elementClass = elementClass;
                for (int i = 0; i < Array.getLength(arrayInstance); ++i) {
                    this.listModel.addElement(Array.get(arrayInstance, i));
                }
                this.elementList.setCellRenderer(lcr);
                this.elementList.setModel(this.listModel);
                if (this.listModel.getSize() > 0) {
                    this.elementList.setSelectedIndex(0);
                    this.deleteButton.setEnabled(true);
                } else {
                    this.deleteButton.setEnabled(false);
                }
                try {
                    if (this.listModel.getSize() > 0) {
                        this.elementEditor.setValue(this.listModel.getElementAt(0));
                    } else if (this.elementEditor instanceof GenericObjectEditor) {
                        ((GenericObjectEditor)this.elementEditor).setDefaultValue();
                    } else if (this.elementEditor.getValue() != null) {
                        this.elementEditor.setValue(elementClass.newInstance());
                    }
                    if (this.withAddButton && !this.upperButtonList.contains(this.addButton)) {
                        this.upperButtonList.add(this.addButton);
                    }
                    if (this.withSetButton && !this.upperButtonList.contains(this.setButton)) {
                        this.upperButtonList.add(this.setButton);
                    }
                    if (this.withSetButton && !this.upperButtonList.contains(this.setAllButton)) {
                        this.upperButtonList.add(this.setAllButton);
                    }
                    JPanel combiUpperPanel = new JPanel(this.getButtonLayout(0, this.upperButtonList));
                    for (JButton but : this.upperButtonList) {
                        combiUpperPanel.add(but);
                    }
                    this.setLayout(new GridBagLayout());
                    GridBagConstraints gbConstraints = new GridBagConstraints();
                    gbConstraints.fill = 2;
                    gbConstraints.gridx = 0;
                    gbConstraints.gridy = 0;
                    this.add((Component)combiUpperPanel, gbConstraints);
                    ++gbConstraints.gridy;
                    gbConstraints.fill = 2;
                    gbConstraints.weightx = 1.0;
                    this.add(this.view, gbConstraints);
                    this.view.setVisible(this.withAddButton);
                    ++gbConstraints.gridy;
                    gbConstraints.fill = 1;
                    gbConstraints.weightx = 1.0;
                    gbConstraints.weighty = 1.0;
                    this.add((Component)new JScrollPane(this.elementList), gbConstraints);
                    if (this.withDeleteButton && !this.lowerButtonList.contains(this.deleteButton)) {
                        this.lowerButtonList.add(this.deleteButton);
                    }
                    JPanel combiLowerPanel = new JPanel(this.getButtonLayout(0, this.lowerButtonList));
                    for (JButton but : this.lowerButtonList) {
                        combiLowerPanel.add(but);
                    }
                    ++gbConstraints.gridy;
                    gbConstraints.fill = 2;
                    gbConstraints.weightx = 1.0;
                    gbConstraints.weighty = 0.0;
                    this.add((Component)combiLowerPanel, gbConstraints);
                    if (this.additionalCenterComp != null) {
                        gbConstraints.weightx = 1.0;
                        gbConstraints.weighty = 1.0;
                        gbConstraints.fill = 1;
                        ++gbConstraints.gridy;
                        this.add((Component)this.additionalCenterComp, gbConstraints);
                    }
                    this.elementEditor.addPropertyChangeListener(event -> this.repaint());
                    this.addPopupMenu();
                }
                catch (Exception ex) {
                    System.err.println(ex.getMessage());
                    ex.printStackTrace();
                    this.elementEditor = null;
                }
            }
        }
        if (this.elementEditor == null) {
            this.add((Component)this.cantEditLabel, "Center");
        }
        this.propChangeSupport.firePropertyChange("", null, null);
        this.validate();
    }

    private LayoutManager getButtonLayout(int additionalOffset, List<JButton> bList) {
        int cols = 3;
        int lines = 1 + (bList.size() + additionalOffset - 1) / cols;
        return new GridLayout(lines, cols);
    }

    public void removeUpperActionButton(String text) {
        this.removeActionButton(this.upperButtonList, text);
    }

    public void removeLowerActionButton(String text) {
        this.removeActionButton(this.lowerButtonList, text);
    }

    protected void removeActionButton(List<JButton> bList, String text) {
        JButton but = null;
        for (JButton jb : bList) {
            if (!text.equals(jb.getText())) continue;
            but = jb;
            break;
        }
        if (but != null) {
            bList.remove(but);
        }
    }

    public void addUpperActionButton(String text, ActionListener al) {
        this.addActionButton(this.upperButtonList, text, al);
    }

    private ActionListener makeSelectionKnownAL(ActionListener al) {
        return e -> {
            if (this.selectableList != null) {
                this.selectableList.setSelectionByIndices(this.elementList.getSelectedIndices());
            }
            al.actionPerformed(e);
        };
    }

    public void addLowerActionButton(String text, ActionListener al) {
        this.addActionButton(this.lowerButtonList, text, al);
    }

    public void addActionButton(List<JButton> bList, String text, ActionListener al) {
        JButton but = new JButton(text);
        but.addActionListener(this.makeSelectionKnownAL(al));
        bList.add(but);
    }

    @Override
    public void setValue(Object o) {
        this.updateEditorType(o);
    }

    public void selectDeselectAll() {
        if (this.areAllSelected()) {
            this.elementList.getSelectionModel().clearSelection();
        } else {
            this.elementList.setSelectionInterval(0, this.elementList.getModel().getSize() - 1);
        }
    }

    public boolean areAllSelected() {
        return this.elementList.getSelectedIndices().length == this.elementList.getModel().getSize();
    }

    @Override
    public Object getValue() {
        if (this.listModel == null) {
            return null;
        }
        if (this.selectableList != null) {
            return this.selectableList;
        }
        int length = this.listModel.getSize();
        Object result = Array.newInstance(this.elementClass, length);
        for (int i = 0; i < length; ++i) {
            Array.set(result, i, this.listModel.elementAt(i));
        }
        return result;
    }

    public void addPopupItem(String text, ActionListener al) {
        JMenuItem item = this.createMenuItem(text, true, this.makeSelectionKnownAL(al));
        this.popupItemList.add(item);
    }

    public void addPopupMenu() {
        if (this.popupItemList.size() > 0) {
            this.elementList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (ArrayEditor.this.selectableList != null) {
                        ArrayEditor.this.selectableList.setSelectionByIndices(ArrayEditor.this.elementList.getSelectedIndices());
                    }
                    if ((e.getModifiers() & 0x10) != 16) {
                        JPopupMenu popupMenu = new JPopupMenu();
                        for (JMenuItem item : ArrayEditor.this.popupItemList) {
                            popupMenu.add(item);
                        }
                        popupMenu.show(ArrayEditor.this, e.getX(), e.getY());
                    }
                }
            });
        }
    }

    private JMenuItem createMenuItem(String title, boolean enabled, ActionListener aListener) {
        JMenuItem item = new JMenuItem(title);
        item.addActionListener(aListener);
        item.setEnabled(enabled);
        return item;
    }

    @Override
    public String getJavaInitializationString() {
        return "null";
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        String rep;
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getAscent()) / 2;
        if (this.listModel.getSize() == 0) {
            rep = "Empty";
        } else {
            rep = this.listModel.getSize() + " of " + StringTools.cutClassName(this.elementClass.getName());
            Object maybeName = BeanInspector.callIfAvailable(this.listModel.get(0), "getName", new Object[0]);
            if (maybeName != null) {
                rep = rep + " (" + maybeName + "...)";
            }
        }
        gfx.drawString(rep, 2, fm.getHeight() + vpad - 3);
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException(text);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propChangeSupport == null) {
            this.propChangeSupport = new PropertyChangeSupport(this);
        }
        this.propChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propChangeSupport == null) {
            this.propChangeSupport = new PropertyChangeSupport(this);
        }
        this.propChangeSupport.removePropertyChangeListener(l);
    }

    public boolean isWithAddButton() {
        return this.withAddButton;
    }

    public void setWithAddButton(boolean withAddButton) {
        this.withAddButton = withAddButton;
        if (this.view != null) {
            this.view.setVisible(withAddButton);
        }
    }

    public boolean isWithSetButton() {
        return this.withSetButton;
    }

    public void setWithSetButton(boolean withSetButton) {
        this.withSetButton = withSetButton;
    }

    public boolean isWithDeleteButton() {
        return this.withDeleteButton;
    }

    public void setWithDeleteButton(boolean wB) {
        this.withDeleteButton = wB;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
    }

    private class EditorListCellRenderer
    implements ListCellRenderer {
        private Class editorClass;
        private Class valueClass;

        public EditorListCellRenderer(Class editorClass, Class valueClass) {
            this.editorClass = editorClass;
            this.valueClass = valueClass;
        }

        public Component getListCellRendererComponent(final JList list, Object value, int index, final boolean isSelected, boolean cellHasFocus) {
            try {
                final PropertyEditor e = (PropertyEditor)this.editorClass.newInstance();
                if (e instanceof GenericObjectEditor) {
                    ((GenericObjectEditor)e).setClassType(this.valueClass);
                }
                e.setValue(value);
                return new JPanel(){

                    @Override
                    public void paintComponent(Graphics g) {
                        Insets i = this.getInsets();
                        Rectangle box = new Rectangle(i.left, i.top, this.getWidth(), this.getHeight());
                        g.setColor(isSelected ? list.getSelectionBackground() : list.getBackground());
                        g.fillRect(0, 0, this.getWidth(), this.getHeight());
                        g.setColor(isSelected ? list.getSelectionForeground() : list.getForeground());
                        e.paintValue(g, box);
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        Font f = this.getFont();
                        FontMetrics fm = this.getFontMetrics(f);
                        Dimension newPref = new Dimension(0, fm.getHeight());
                        newPref.height = this.getFontMetrics(this.getFont()).getHeight() * 6 / 4;
                        newPref.width = newPref.height * 6;
                        return newPref;
                    }
                };
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    private class ActionJList
    extends MouseAdapter {
        protected JList list;
        ArrayEditor gae = null;

        public ActionJList(JList l, ArrayEditor genAE) {
            this.list = l;
            this.gae = genAE;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int index;
            if (e.getClickCount() == 2 && (index = this.list.locationToIndex(e.getPoint())) >= 0 && this.list.getCellBounds(index, index).contains(e.getPoint())) {
                PropertyPanel propPanel = null;
                Component comp = this.gae.view;
                if (comp instanceof PropertyPanel) {
                    propPanel = (PropertyPanel)comp;
                } else {
                    System.err.println("Error, invalid property panel in " + this.getClass());
                }
                ListModel dlm = this.list.getModel();
                Object item = dlm.getElementAt(index);
                this.list.ensureIndexIsVisible(index);
                propPanel.getEditor().setValue(item);
                propPanel.showDialog();
            }
        }
    }
}

