/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui.editor;

import eva2.gui.PropertyDoubleArray;
import eva2.gui.editor.MyFocusListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DoubleArrayEditor
extends JPanel
implements PropertyEditor {
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private JLabel label = new JLabel("Can't edit", 0);
    private PropertyDoubleArray doubleArray;
    private JPanel customEditor;
    private JPanel dataPanel;
    private JPanel buttonPanel;
    private JTextField[][] inputTextFields;
    private JButton okButton;
    private JButton addButton;
    private JButton deleteButton;
    private JButton normalizeButton;
    private int lastFocussedRow = -1;
    ActionListener addAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            DoubleArrayEditor.this.doubleArray.addRowCopy(DoubleArrayEditor.this.lastFocussedRow);
            DoubleArrayEditor.this.updateEditor();
        }
    };
    ActionListener deleteAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!DoubleArrayEditor.this.doubleArray.isValidRow(DoubleArrayEditor.this.lastFocussedRow)) {
                DoubleArrayEditor.this.doubleArray.deleteRow(DoubleArrayEditor.this.doubleArray.getNumRows() - 1);
            } else {
                DoubleArrayEditor.this.doubleArray.deleteRow(DoubleArrayEditor.this.lastFocussedRow);
            }
            DoubleArrayEditor.this.updateEditor();
        }
    };
    ActionListener normalizeAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            DoubleArrayEditor.this.doubleArray.normalizeColumns();
            DoubleArrayEditor.this.updateEditor();
        }
    };
    KeyListener readDoubleArrayAction = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }

        @Override
        public void keyReleased(KeyEvent event) {
            double[][] tmpDD = new double[DoubleArrayEditor.this.inputTextFields.length][DoubleArrayEditor.this.inputTextFields[0].length];
            for (int i = 0; i < tmpDD.length; ++i) {
                for (int j = 0; j < tmpDD[0].length; ++j) {
                    try {
                        double d = 0.0;
                        tmpDD[i][j] = d = Double.parseDouble(DoubleArrayEditor.this.inputTextFields[i][j].getText());
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            DoubleArrayEditor.this.doubleArray.setDoubleArray(tmpDD);
        }
    };

    private void initCustomEditor() {
        this.customEditor = new JPanel();
        this.customEditor.setLayout(new BorderLayout());
        this.customEditor.add((Component)new JLabel("Current Double Array:"), "North");
        this.dataPanel = new JPanel();
        this.updateDataPanel();
        this.customEditor.add((Component)this.dataPanel, "Center");
        this.buttonPanel = new JPanel();
        this.addButton = new JButton("Add");
        this.addButton.addActionListener(this.addAction);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this.deleteAction);
        this.normalizeButton = new JButton("Normalize");
        this.normalizeButton.addActionListener(this.normalizeAction);
        this.okButton = new JButton("OK");
        this.okButton.setEnabled(true);
        this.okButton.addActionListener(e -> {
            if (this.customEditor.getTopLevelAncestor() != null && this.customEditor.getTopLevelAncestor() instanceof Window) {
                Window w = (Window)this.customEditor.getTopLevelAncestor();
                w.dispose();
            }
        });
        this.buttonPanel.add(this.addButton);
        this.buttonPanel.add(this.deleteButton);
        this.buttonPanel.add(this.normalizeButton);
        this.buttonPanel.add(this.okButton);
        this.customEditor.add((Component)this.buttonPanel, "South");
        this.updateEditor();
    }

    private void updateEditor() {
        if (this.customEditor != null) {
            this.updateDataPanel();
            this.customEditor.validate();
            this.customEditor.repaint();
        }
    }

    private void updateDataPanel() {
        int numRows = this.doubleArray.getNumRows();
        int numCols = this.doubleArray.getNumCols();
        this.dataPanel.removeAll();
        this.dataPanel.setLayout(new GridLayout(numRows, numCols + 1));
        this.inputTextFields = new JTextField[numRows][numCols];
        for (int i = 0; i < numRows; ++i) {
            JLabel label = new JLabel("Value X" + i + ": ");
            this.dataPanel.add(label);
            for (int j = 0; j < numCols; ++j) {
                this.inputTextFields[i][j] = new JTextField();
                this.inputTextFields[i][j].setText("" + this.doubleArray.getValue(i, j));
                this.inputTextFields[i][j].addKeyListener(this.readDoubleArrayAction);
                this.inputTextFields[i][j].addFocusListener(new MyFocusListener(i, this));
                this.dataPanel.add(this.inputTextFields[i][j]);
            }
        }
    }

    public void notifyFocusID(int id) {
        this.lastFocussedRow = id;
    }

    @Override
    public void setValue(Object o) {
        if (o instanceof PropertyDoubleArray) {
            this.doubleArray = (PropertyDoubleArray)o;
            this.updateEditor();
        }
    }

    @Override
    public Object getValue() {
        return this.doubleArray;
    }

    @Override
    public String getJavaInitializationString() {
        return "TEST";
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException(text);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
        }
        this.support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
        }
        this.support.removePropertyChangeListener(l);
    }

    public void addOkListener(ActionListener a) {
        this.okButton.addActionListener(a);
    }

    public void removeOkListener(ActionListener a) {
        this.okButton.removeActionListener(a);
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getAscent()) / 2;
        String rep = "Edit double array...";
        gfx.drawString(rep, 2, fm.getHeight() + vpad - 3);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.initCustomEditor();
        }
        return this.customEditor;
    }
}

