/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui.editor;

import eva2.gui.PropertyValueSelector;
import eva2.gui.editor.TestEnum;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyEditorSupport;
import javax.swing.JFrame;

public class EnumEditor
extends PropertyEditorSupport {
    private Enum[] enumConstants;

    @Override
    public String getAsText() {
        return this.getValue().toString();
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Enum) {
            this.enumConstants = (Enum[])((Enum)value).getClass().getEnumConstants();
            super.setValue(value);
        } else if (value.getClass().isArray() && value.getClass().getComponentType().isEnum()) {
            Enum[] e = (Enum[])value;
            this.enumConstants = (Enum[])e.getClass().getComponentType().getEnumConstants();
            super.setValue(value);
        }
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        for (int i = 0; i < this.enumConstants.length; ++i) {
            if (!text.equals(this.enumConstants[i].toString())) continue;
            this.setValue(this.enumConstants[i]);
            return;
        }
        throw new IllegalArgumentException("Invalid text for enum");
    }

    @Override
    public String[] getTags() {
        if (this.getValue() == null) {
            return null;
        }
        String[] tags = new String[this.enumConstants.length];
        for (int i = 0; i < tags.length; ++i) {
            tags[i] = this.enumConstants[i].toString();
        }
        return tags;
    }

    public static void main(String[] args) {
        try {
            TestEnum initial = TestEnum.asdf;
            EnumEditor ed = new EnumEditor();
            ed.setValue((Object)initial);
            PropertyValueSelector ps = new PropertyValueSelector(ed);
            JFrame f = new JFrame();
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            f.getContentPane().setLayout(new BorderLayout());
            f.getContentPane().add((Component)ps, "Center");
            f.pack();
            f.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

