/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui.editor;

import eva2.gui.PropertyEpsilonThreshold;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EpsilonThresholdEditor
extends JPanel
implements PropertyEditor {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private PropertyEpsilonThreshold epsilonThreshhold;
    private JPanel customEditor;
    private JPanel dataPanel;
    private JPanel buttonPanel;
    private JPanel targetPanel;
    private JTextField[] targetTextField;
    private JTextField[] punishTextField;
    private JComboBox objectiveComboBox;
    private JButton okButton;
    ItemListener objectiveAction = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent event) {
            ((EpsilonThresholdEditor)EpsilonThresholdEditor.this).epsilonThreshhold.optimizeObjective = EpsilonThresholdEditor.this.objectiveComboBox.getSelectedIndex();
            EpsilonThresholdEditor.this.updateEditor();
        }
    };
    KeyListener readDoubleArrayAction = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }

        @Override
        public void keyReleased(KeyEvent event) {
            double[] tmpT = ((EpsilonThresholdEditor)EpsilonThresholdEditor.this).epsilonThreshhold.targetValue;
            double[] tmpP = ((EpsilonThresholdEditor)EpsilonThresholdEditor.this).epsilonThreshhold.punishment;
            for (int i = 0; i < tmpT.length; ++i) {
                try {
                    double d = 0.0;
                    tmpT[i] = d = Double.parseDouble(EpsilonThresholdEditor.this.targetTextField[i].getText());
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    double d = 0.0;
                    tmpP[i] = d = Double.parseDouble(EpsilonThresholdEditor.this.punishTextField[i].getText());
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ((EpsilonThresholdEditor)EpsilonThresholdEditor.this).epsilonThreshhold.targetValue = tmpT;
            ((EpsilonThresholdEditor)EpsilonThresholdEditor.this).epsilonThreshhold.punishment = tmpP;
        }
    };

    private void initCustomEditor() {
        this.customEditor = new JPanel();
        this.customEditor.setLayout(new BorderLayout());
        this.targetPanel = new JPanel();
        this.targetPanel.setLayout(new GridLayout(1, 2));
        this.targetPanel.add(new JLabel("Optimize:"));
        this.objectiveComboBox = new JComboBox();
        for (int i = 0; i < this.epsilonThreshhold.targetValue.length; ++i) {
            this.objectiveComboBox.addItem("Objective " + i);
        }
        this.targetPanel.add(this.objectiveComboBox);
        this.objectiveComboBox.addItemListener(this.objectiveAction);
        this.customEditor.add((Component)this.targetPanel, "North");
        this.dataPanel = new JPanel();
        this.updateDataPanel();
        this.customEditor.add((Component)this.dataPanel, "Center");
        this.buttonPanel = new JPanel();
        this.okButton = new JButton("OK");
        this.okButton.setEnabled(true);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EpsilonThresholdEditor.this.customEditor.getTopLevelAncestor() != null && EpsilonThresholdEditor.this.customEditor.getTopLevelAncestor() instanceof Window) {
                    Window w = (Window)EpsilonThresholdEditor.this.customEditor.getTopLevelAncestor();
                    w.dispose();
                }
            }
        });
        this.buttonPanel.add(this.okButton);
        this.customEditor.add((Component)this.buttonPanel, "South");
        this.updateEditor();
    }

    private void updateEditor() {
        if (this.customEditor != null) {
            this.updateDataPanel();
            this.customEditor.validate();
            this.customEditor.repaint();
        }
    }

    private void updateDataPanel() {
        double[] tmpT = this.epsilonThreshhold.targetValue;
        double[] tmpP = this.epsilonThreshhold.punishment;
        int obj = this.epsilonThreshhold.optimizeObjective;
        this.dataPanel.removeAll();
        this.dataPanel.setLayout(new GridLayout(tmpT.length + 1, 3));
        this.dataPanel.add(new JLabel());
        this.dataPanel.add(new JLabel("Target Value"));
        this.dataPanel.add(new JLabel("Punishment"));
        this.targetTextField = new JTextField[tmpT.length];
        this.punishTextField = new JTextField[tmpT.length];
        for (int i = 0; i < tmpT.length; ++i) {
            JLabel label = new JLabel("Objective " + i + ": ");
            this.dataPanel.add(label);
            this.targetTextField[i] = new JTextField();
            this.targetTextField[i].setText("" + tmpT[i]);
            this.targetTextField[i].addKeyListener(this.readDoubleArrayAction);
            this.dataPanel.add(this.targetTextField[i]);
            this.punishTextField[i] = new JTextField();
            this.punishTextField[i].setText("" + tmpP[i]);
            this.punishTextField[i].addKeyListener(this.readDoubleArrayAction);
            this.dataPanel.add(this.punishTextField[i]);
        }
        this.targetTextField[obj].setEditable(false);
        this.punishTextField[obj].setEditable(false);
    }

    @Override
    public void setValue(Object o) {
        if (o instanceof PropertyEpsilonThreshold) {
            this.epsilonThreshhold = (PropertyEpsilonThreshold)o;
            this.updateEditor();
        }
    }

    @Override
    public Object getValue() {
        return this.epsilonThreshhold;
    }

    @Override
    public String getJavaInitializationString() {
        return "TEST";
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException(text);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void addOkListener(ActionListener a) {
        this.okButton.addActionListener(a);
    }

    public void removeOkListener(ActionListener a) {
        this.okButton.removeActionListener(a);
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getAscent()) / 2;
        String rep = "Edit Epsilon Threshhold";
        gfx.drawString(rep, 2, fm.getHeight() + vpad - 3);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.initCustomEditor();
        }
        return this.customEditor;
    }
}

