/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui.editor;

import eva2.gui.PropertyFilePath;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class FilePathEditor
extends JPanel
implements PropertyEditor {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private PropertyFilePath filePath;
    private JFileChooser fileChooser;
    private JPanel panel;
    ActionListener fileChooserAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            Window w;
            if (event.getActionCommand().equals("ApproveSelection")) {
                FilePathEditor.this.filePath.setCompleteFilePath(FilePathEditor.this.fileChooser.getSelectedFile().getAbsolutePath());
                FilePathEditor.this.propertyChangeSupport.firePropertyChange("", FilePathEditor.this.filePath, null);
                w = (Window)FilePathEditor.this.fileChooser.getTopLevelAncestor();
                w.dispose();
                FilePathEditor.this.panel = null;
            }
            if (event.getActionCommand().equals("CancelSelection")) {
                FilePathEditor.this.filePath.setCompleteFilePath(FilePathEditor.this.fileChooser.getSelectedFile().getAbsolutePath());
                FilePathEditor.this.propertyChangeSupport.firePropertyChange("", FilePathEditor.this.filePath, null);
                w = (Window)FilePathEditor.this.fileChooser.getTopLevelAncestor();
                if (w != null) {
                    w.dispose();
                }
                FilePathEditor.this.panel = null;
            }
        }
    };

    @Override
    public void setValue(Object o) {
        if (o instanceof PropertyFilePath) {
            this.filePath = (PropertyFilePath)o;
        }
    }

    @Override
    public Object getValue() {
        return this.filePath;
    }

    @Override
    public String getJavaInitializationString() {
        return "TEST";
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException(text);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getAscent()) / 2;
        String rep = this.filePath.fileName;
        gfx.drawString(rep, 2, fm.getHeight() + vpad - 3);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        this.panel = new JPanel();
        this.fileChooser = new JFileChooser();
        File file = new File(this.filePath.getCompleteFilePath());
        this.fileChooser.setSelectedFile(file);
        this.fileChooser.setMultiSelectionEnabled(false);
        this.panel.add(this.fileChooser);
        this.fileChooser.addActionListener(this.fileChooserAction);
        return this.panel;
    }
}

