/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui.editor;

import eva2.EvAInfo;
import eva2.gui.OptimizationEditorPanel;
import eva2.tools.ReflectPackage;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenericObjectEditor
implements PropertyEditor {
    private static final Logger LOGGER = Logger.getLogger(GenericObjectEditor.class.getName());
    private Object object;
    private Object backupObject;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Class<?> classType;
    private OptimizationEditorPanel editorComponent;
    private boolean isEnabled = true;

    public static ArrayList<String> getClassesFromProperties(String className, ArrayList<Class<?>> instances) {
        LOGGER.log(Level.FINEST, "Requesting className: {0}", className);
        String typeOptions = EvAInfo.getProperty(className);
        if (typeOptions == null) {
            return GenericObjectEditor.getClassesFromClassPath(className, instances);
        }
        StringTokenizer st = new StringTokenizer(typeOptions, ", ");
        ArrayList<String> classes = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String current = st.nextToken().trim();
            try {
                Class<?> clz = Class.forName(current);
                if (instances != null) {
                    instances.add(clz);
                }
                classes.add(current);
            }
            catch (ClassNotFoundException ex) {
                LOGGER.log(Level.WARNING, String.format("Requesting className: %1$s, Couldn't load: %2$s", className, current), ex);
            }
        }
        return classes;
    }

    public static ArrayList<String> getClassesFromClassPath(String className, ArrayList<Class<?>> instances) {
        ArrayList<String> classes = new ArrayList<String>();
        Class<?>[] classArray = ReflectPackage.getAssignableClasses(className, true, true);
        if (classArray == null) {
            LOGGER.log(Level.WARNING, String.format("No assignable classes found in property file or on classpath: %1$s for %2$s", "META-INF/EvA2.props", className));
            classes.add(className);
        } else {
            for (Class<?> clazz : classArray) {
                int m = clazz.getModifiers();
                try {
                    Field f = clazz.getDeclaredField("hideFromGOE");
                    if (f.getBoolean(clazz)) {
                        LOGGER.log(Level.FINEST, "Class {0} wants to be hidden from GOE.", clazz);
                        continue;
                    }
                }
                catch (NoSuchFieldException e) {
                    LOGGER.log(Level.FINER, String.format("%1$s does not have a hideFromGOE field", clazz.toString()), e);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    LOGGER.log(Level.FINER, e.getMessage(), e);
                }
                if (Modifier.isAbstract(m) || clazz.isInterface()) continue;
                try {
                    Class[] params = new Class[]{};
                    clazz.getConstructor(params);
                    if (instances != null) {
                        instances.add(clazz);
                    }
                    classes.add(clazz.getName());
                }
                catch (NoSuchMethodException e) {
                    LOGGER.log(Level.WARNING, String.format("GOE warning: Class %1$s has no default constructor", clazz.getName()), e);
                }
            }
        }
        return classes;
    }

    public static boolean setExpertProperty(Class<?> cls, String property, boolean expertValue) {
        try {
            PropertyDescriptor[] props;
            BeanInfo bi = Introspector.getBeanInfo(cls);
            for (PropertyDescriptor prop : props = bi.getPropertyDescriptors()) {
                if (!prop.getName().equals(property) || expertValue == prop.isExpert()) continue;
                prop.setExpert(expertValue);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, String.format("Couldn't set expert property for %1$s/%2$s", cls.getName(), property), e);
            return false;
        }
    }

    public static boolean setHideProperty(Class<?> cls, String property, boolean hide) {
        try {
            PropertyDescriptor[] props;
            BeanInfo bi = Introspector.getBeanInfo(cls);
            for (PropertyDescriptor prop : props = bi.getPropertyDescriptors()) {
                if (!prop.getName().equals(property)) continue;
                if (hide != prop.isHidden()) {
                    prop.setHidden(hide);
                }
                return true;
            }
            LOGGER.log(Level.WARNING, "Property {0} not found", property);
            return false;
        }
        catch (IntrospectionException e) {
            LOGGER.log(Level.WARNING, String.format("Couldn't set hide property for %1$s/%2$s", cls.getName(), property), e);
            return false;
        }
    }

    public static boolean[] setHideAllProperties(Class<?> cls, boolean hide) {
        try {
            BeanInfo bi = Introspector.getBeanInfo(cls);
            PropertyDescriptor[] props = bi.getPropertyDescriptors();
            boolean[] orig = new boolean[props.length];
            for (int i = 0; i < props.length; ++i) {
                orig[i] = props[i].isHidden();
                props[i].setHidden(hide);
            }
            return orig;
        }
        catch (IntrospectionException e) {
            LOGGER.log(Level.WARNING, String.format("Couldn't hide all properties for %1$s/all", cls.getName()), e);
            return null;
        }
    }

    public static void setHideProperties(Class<?> cls, boolean[] hideStates) {
        if (hideStates != null) {
            BeanInfo bi;
            try {
                bi = Introspector.getBeanInfo(cls);
            }
            catch (IntrospectionException e) {
                LOGGER.log(Level.WARNING, String.format("Error on introspection of %1$s", cls.getName()), e);
                return;
            }
            PropertyDescriptor[] props = bi.getPropertyDescriptors();
            if (hideStates.length == props.length) {
                for (int i = 0; i < props.length; ++i) {
                    props[i].setHidden(hideStates[i]);
                }
            } else {
                System.err.println("Error, mismatching length of hide state array in GenericObjectEditor.setHideProperites");
            }
        }
    }

    public static boolean setShowProperty(Class<?> cls, String property, boolean show) {
        return GenericObjectEditor.setHideProperty(cls, property, !show);
    }

    public void setEnabled(boolean newVal) {
        if (newVal != this.isEnabled) {
            this.isEnabled = newVal;
        }
    }

    public void setClassType(Class<?> type) {
        this.classType = type;
        if (this.editorComponent != null) {
            this.editorComponent.updateClassType();
        }
    }

    public Class<?> getClassType() {
        return this.classType;
    }

    public void setDefaultValue() {
        if (this.classType == null) {
            LOGGER.log(Level.WARNING, "No ClassType set up for GenericObjectEditor!");
            return;
        }
        Vector<String> v = new Vector<String>(GenericObjectEditor.getClassesFromProperties(this.classType.getName(), null));
        try {
            if (v.size() > 0) {
                this.setObject(Class.forName(v.get(0)).newInstance());
            }
        }
        catch (Exception ex) {
            System.err.println("Exception in setDefaultValue !!!" + ex.getMessage());
        }
    }

    @Override
    public void setValue(Object o) {
        if (o == null || this.classType == null) {
            LOGGER.log(Level.WARNING, "No ClassType set up for GenericObjectEditor!");
            return;
        }
        if (!this.classType.isAssignableFrom(o.getClass())) {
            if (this.classType.isPrimitive()) {
                System.err.println("setValue object not of correct type! Expected " + this.classType.getName() + ", got " + o.getClass().getName());
                System.err.println("setting primitive type");
                this.setObject(o);
            } else {
                System.err.println("setValue object not of correct type! Expected " + this.classType.getName() + ", got " + o.getClass().getName());
            }
            return;
        }
        this.setObject(o);
        if (this.editorComponent != null) {
            this.editorComponent.updateChooser();
        }
    }

    private void setObject(Object c) {
        boolean trueChange = c != this.getValue();
        this.backupObject = this.object;
        this.object = c;
        if (this.editorComponent != null) {
            this.editorComponent.updateChildPropertySheet();
            if (trueChange) {
                this.propertyChangeSupport.firePropertyChange("", this.backupObject, this.object);
            }
        }
    }

    @Override
    public Object getValue() {
        return this.object;
    }

    @Override
    public String getJavaInitializationString() {
        return "new " + this.object.getClass().getName() + "()";
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        if (this.isEnabled && this.object != null) {
            int dotPos;
            MethodDescriptor[] methods;
            int getNameMethod = -1;
            String rep = "";
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(this.object.getClass());
                methods = beanInfo.getMethodDescriptors();
                for (int i = 0; i < methods.length; ++i) {
                    if (!methods[i].getName().equalsIgnoreCase("getName")) continue;
                    getNameMethod = i;
                    break;
                }
            }
            catch (IntrospectionException ex) {
                LOGGER.log(Level.WARNING, "Could not introspect PropertySheetPanel", ex);
                return;
            }
            if (getNameMethod >= 0) {
                try {
                    rep = (String)methods[getNameMethod].getMethod().invoke(this.object, (Object[])null);
                }
                catch (IllegalAccessException | InvocationTargetException ignored) {
                    // empty catch block
                }
            }
            if (rep.length() <= 0 && (dotPos = (rep = this.object.getClass().getName()).lastIndexOf(46)) != -1) {
                rep = rep.substring(dotPos + 1);
            }
            FontMetrics fm = gfx.getFontMetrics();
            int vpad = (box.height - fm.getHeight()) / 2;
            gfx.drawString(rep, 2, fm.getHeight() + vpad - 2);
        }
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException(text);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.editorComponent == null) {
            this.editorComponent = new OptimizationEditorPanel(this.object, this.backupObject, this.propertyChangeSupport, this);
        }
        return this.editorComponent;
    }

    public void disableOKCancel() {
        if (this.editorComponent == null) {
            this.editorComponent = new OptimizationEditorPanel(this.object, this.backupObject, this.propertyChangeSupport, this);
        }
        this.editorComponent.setEnabledOkCancelButtons(false);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }
}

