/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui.editor;

import eva2.gui.PropertyIntArray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class IntArrayEditor
extends JPanel
implements PropertyEditor {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private PropertyIntArray intArray;
    private JPanel customEditor;
    private JPanel dataPanel;
    private JPanel buttonPanel;
    private JTextField[] inputTextField;
    private JButton okButton;
    KeyListener readIntArrayAction = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }

        @Override
        public void keyReleased(KeyEvent event) {
            int[] tmpD = new int[IntArrayEditor.this.inputTextField.length];
            for (int i = 0; i < tmpD.length; ++i) {
                try {
                    int d = 0;
                    tmpD[i] = d = Integer.parseInt(IntArrayEditor.this.inputTextField[i].getText());
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            IntArrayEditor.this.intArray.setIntArray(tmpD);
        }
    };

    private void initCustomEditor() {
        this.customEditor = new JPanel();
        this.customEditor.setLayout(new BorderLayout());
        this.customEditor.add((Component)new JLabel("Current Int Array:"), "North");
        this.dataPanel = new JPanel();
        this.updateDataPanel();
        this.customEditor.add((Component)this.dataPanel, "Center");
        this.buttonPanel = new JPanel();
        this.okButton = new JButton("OK");
        this.okButton.setEnabled(true);
        this.okButton.addActionListener(e -> {
            if (this.customEditor.getTopLevelAncestor() != null && this.customEditor.getTopLevelAncestor() instanceof Window) {
                Window w = (Window)this.customEditor.getTopLevelAncestor();
                w.dispose();
            }
        });
        this.buttonPanel.add(this.okButton);
        this.customEditor.add((Component)this.buttonPanel, "South");
        this.updateEditor();
    }

    private void updateEditor() {
        if (this.customEditor != null) {
            this.updateDataPanel();
            this.customEditor.validate();
            this.customEditor.repaint();
        }
    }

    private void updateDataPanel() {
        int[] tmpD = this.intArray.getIntArray();
        this.dataPanel.removeAll();
        this.dataPanel.setLayout(new GridLayout(tmpD.length, 2));
        this.inputTextField = new JTextField[tmpD.length];
        for (int i = 0; i < tmpD.length; ++i) {
            JLabel label = new JLabel("Value X" + i + ": ");
            this.dataPanel.add(label);
            this.inputTextField[i] = new JTextField();
            this.inputTextField[i].setText("" + tmpD[i]);
            this.inputTextField[i].addKeyListener(this.readIntArrayAction);
            this.dataPanel.add(this.inputTextField[i]);
        }
    }

    @Override
    public void setValue(Object o) {
        if (o instanceof PropertyIntArray) {
            this.intArray = (PropertyIntArray)o;
            this.updateEditor();
        }
    }

    @Override
    public Object getValue() {
        return this.intArray;
    }

    @Override
    public String getJavaInitializationString() {
        return "TEST";
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException(text);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void addOkListener(ActionListener a) {
        this.okButton.addActionListener(a);
    }

    public void removeOkListener(ActionListener a) {
        this.okButton.removeActionListener(a);
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getAscent()) / 2;
        String rep = "Edit int[]";
        gfx.drawString(rep, 2, fm.getHeight() + vpad - 3);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.initCustomEditor();
        }
        return this.customEditor;
    }
}

