/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui.editor;

import eva2.gui.MultiLineString;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public class MultiLineStringEditor
implements PropertyEditor {
    protected MultiLineString value;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    @Override
    public void setValue(Object o) {
        this.value = (MultiLineString)o;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setAsText(String s) {
        this.value.setString(s);
    }

    @Override
    public String getAsText() {
        return this.value.getString();
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        final TextArea t = new TextArea(this.value.string);
        t.setSize(300, 150);
        t.addTextListener(new TextListener(){

            @Override
            public void textValueChanged(TextEvent e) {
                MultiLineStringEditor.this.value.setString(t.getText());
                MultiLineStringEditor.this.listeners.firePropertyChange(null, null, null);
            }
        });
        return t;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics g, Rectangle r) {
        g.setClip(r);
        g.drawString("Click to edit...", r.x + 5, r.y + 15);
    }

    @Override
    public String getJavaInitializationString() {
        return "\"" + this.value + "\"";
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.removePropertyChangeListener(l);
    }
}

