/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui.editor;

import eva2.gui.BeanInspector;
import eva2.gui.PropertyDialog;
import eva2.gui.PropertyEditorProvider;
import eva2.gui.TypeSelector;
import eva2.gui.TypeSelectorItem;
import eva2.tools.StringTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ObjectArrayEditor<T>
extends JPanel
implements PropertyEditor {
    private T[] value;
    private JList<T> objectList;
    private DefaultListModel<T> listModel = new DefaultListModel();
    private PropertyChangeSupport propChangeSupport;
    private JButton configButton;

    public ObjectArrayEditor(Class<T> type) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 2;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        TypeSelector typeSelector = new TypeSelector();
        typeSelector.updateClassType(type.getName());
        this.add((Component)typeSelector, c);
        JButton addButton = new JButton("Add");
        c.gridwidth = 1;
        c.gridx = 2;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.add((Component)addButton, c);
        JButton removeButton = new JButton("Remove");
        c.gridx = 2;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.add((Component)removeButton, c);
        this.configButton = new JButton("Config");
        c.gridx = 2;
        c.gridy = 2;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.add((Component)this.configButton, c);
        this.objectList = new JList<T>(this.listModel);
        this.objectList.setVisibleRowCount(10);
        c.gridwidth = 2;
        c.gridheight = 5;
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JScrollPane scrollPane = new JScrollPane(this.objectList);
        this.add((Component)scrollPane, c);
        addButton.addActionListener(event -> {
            String className = ((TypeSelectorItem)typeSelector.getSelectedItem()).getId();
            try {
                Object n = Class.forName(className).newInstance();
                this.listModel.addElement(n);
                this.propChangeSupport.firePropertyChange("", null, null);
            }
            catch (Exception ex) {
                System.err.println("Exception in itemStateChanged " + ex.getMessage());
                System.err.println("Classpath is " + System.getProperty("java.class.path"));
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, "Could not create an example of\n" + className + "\n" + "from the current classpath. Is the resource folder at the right place?\nIs the class abstract or the default constructor missing?", "GenericObjectEditor", 0);
            }
        });
        removeButton.addActionListener(event -> {
            if (!this.objectList.isSelectionEmpty()) {
                this.listModel.remove(this.objectList.getSelectedIndex());
                this.propChangeSupport.firePropertyChange("", null, null);
            }
        });
        this.configButton.addActionListener(event -> {
            T selected = this.objectList.getSelectedValue();
            PropertyEditor editor = PropertyEditorProvider.findEditor(selected.getClass());
            editor.setValue(selected);
            PropertyDialog propertyDialog = new PropertyDialog(null, editor, StringTools.cutClassName(editor.getClass().getName()));
            propertyDialog.setPreferredSize(new Dimension(500, 300));
            propertyDialog.setModal(true);
            propertyDialog.setVisible(true);
            this.propChangeSupport.firePropertyChange("", null, null);
        });
    }

    @Override
    public void setValue(Object value) {
        this.value = (Object[])value;
        this.listModel.removeAllElements();
        for (T i : this.value) {
            this.listModel.addElement(i);
        }
    }

    @Override
    public Object getValue() {
        if (this.listModel == null) {
            return null;
        }
        int length = this.listModel.getSize();
        Object result = Array.newInstance(this.value.getClass().getComponentType(), length);
        for (int i = 0; i < length; ++i) {
            Array.set(result, i, this.listModel.elementAt(i));
        }
        return result;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        String rep;
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getAscent()) / 2;
        if (this.listModel.getSize() == 0) {
            rep = "Empty";
        } else {
            rep = this.listModel.getSize() + " of " + StringTools.cutClassName(this.value.getClass().getComponentType().getName());
            Object maybeName = BeanInspector.callIfAvailable(this.listModel.get(0), "getName", new Object[0]);
            if (maybeName != null) {
                rep = rep + " (" + maybeName + "...)";
            }
        }
        gfx.drawString(rep, 2, fm.getHeight() + vpad - 3);
    }

    @Override
    public String getJavaInitializationString() {
        return null;
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException(text);
    }

    @Override
    public String[] getTags() {
        return new String[0];
    }

    @Override
    public Component getCustomEditor() {
        return this;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propChangeSupport == null) {
            this.propChangeSupport = new PropertyChangeSupport(this);
        }
        this.propChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propChangeSupport == null) {
            this.propChangeSupport = new PropertyChangeSupport(this);
        }
        this.propChangeSupport.removePropertyChangeListener(l);
    }

    public void toggleConfigButton() {
        this.configButton.setEnabled(!this.configButton.isEnabled());
    }
}

