/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui.editor;

import eva2.gui.PropertyEditorProvider;
import eva2.gui.PropertyOptimizationObjectivesWithParam;
import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.tools.AbstractObjectEditor;
import eva2.optimization.tools.GeneralOptimizationEditorProperty;
import eva2.problems.InterfaceOptimizationObjective;
import eva2.tools.BasicResourceLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class OptimizationObjectivesWithParamEditor
extends JPanel
implements PropertyEditor,
PropertyChangeListener {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JLabel label = new JLabel("Can't edit", 0);
    private PropertyOptimizationObjectivesWithParam optimizationObjectivesWithWeights;
    private JComponent editor;
    private JPanel targetList;
    private JTextField[] weights;
    private JComponent[] targets;
    private JButton[] deleteButton;
    private JScrollPane scrollTargets;
    private GeneralOptimizationEditorProperty[] editors;
    private PropertyChangeListener self;
    ActionListener updateTargets = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            OptimizationObjectivesWithParamEditor.this.updateTargetList();
        }
    };
    ActionListener addTarget = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            OptimizationObjectivesWithParamEditor.this.optimizationObjectivesWithWeights.addTarget((InterfaceOptimizationObjective)OptimizationObjectivesWithParamEditor.this.optimizationObjectivesWithWeights.getAvailableTargets()[0].clone());
            int l = OptimizationObjectivesWithParamEditor.this.optimizationObjectivesWithWeights.getSelectedTargets().length;
            GeneralOptimizationEditorProperty[] newEdit = new GeneralOptimizationEditorProperty[l];
            System.arraycopy(OptimizationObjectivesWithParamEditor.this.editors, 0, newEdit, 0, OptimizationObjectivesWithParamEditor.this.editors.length);
            InterfaceOptimizationObjective[] list = OptimizationObjectivesWithParamEditor.this.optimizationObjectivesWithWeights.getSelectedTargets();
            newEdit[--l] = new GeneralOptimizationEditorProperty();
            newEdit[l].name = list[l].getName();
            try {
                newEdit[l].value = list[l];
                newEdit[l].editor = PropertyEditorProvider.findEditor(newEdit[l].value.getClass());
                if (newEdit[l].editor == null) {
                    newEdit[l].editor = PropertyEditorProvider.findEditor(InterfaceOptimizationObjective.class);
                }
                if (newEdit[l].editor instanceof GenericObjectEditor) {
                    ((GenericObjectEditor)newEdit[l].editor).setClassType(InterfaceOptimizationObjective.class);
                }
                newEdit[l].editor.setValue(newEdit[l].value);
                newEdit[l].editor.addPropertyChangeListener(OptimizationObjectivesWithParamEditor.this.self);
                AbstractObjectEditor.findViewFor(newEdit[l]);
                if (newEdit[l].view != null) {
                    newEdit[l].view.repaint();
                }
            }
            catch (Exception e) {
                System.out.println("Darn can't read the value...");
            }
            OptimizationObjectivesWithParamEditor.access$202(OptimizationObjectivesWithParamEditor.this, newEdit);
            OptimizationObjectivesWithParamEditor.this.updateTargetList();
        }
    };
    ActionListener deleteTarget = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            int l = OptimizationObjectivesWithParamEditor.this.optimizationObjectivesWithWeights.getSelectedTargets().length;
            int j = 0;
            GeneralOptimizationEditorProperty[] newEdit = new GeneralOptimizationEditorProperty[l - 1];
            for (int i = 0; i < OptimizationObjectivesWithParamEditor.this.deleteButton.length; ++i) {
                if (event.getSource().equals(OptimizationObjectivesWithParamEditor.this.deleteButton[i])) {
                    OptimizationObjectivesWithParamEditor.this.optimizationObjectivesWithWeights.removeTarget(i);
                    continue;
                }
                newEdit[j] = OptimizationObjectivesWithParamEditor.this.editors[i];
                ++j;
            }
            OptimizationObjectivesWithParamEditor.access$202(OptimizationObjectivesWithParamEditor.this, newEdit);
            OptimizationObjectivesWithParamEditor.this.updateTargetList();
        }
    };
    ActionListener normalizeWeights = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            int i;
            double[] newW = OptimizationObjectivesWithParamEditor.this.optimizationObjectivesWithWeights.getWeights();
            double sum = 0.0;
            for (i = 0; i < newW.length; ++i) {
                sum += newW[i];
            }
            if (sum != 0.0) {
                i = 0;
                while (i < newW.length) {
                    int n = i++;
                    newW[n] = newW[n] / sum;
                }
                OptimizationObjectivesWithParamEditor.this.optimizationObjectivesWithWeights.setWeights(newW);
            }
            OptimizationObjectivesWithParamEditor.this.updateTargetList();
        }
    };
    KeyListener readDoubleArrayAction = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
        }

        @Override
        public void keyReleased(KeyEvent event) {
            double[] newW = OptimizationObjectivesWithParamEditor.this.optimizationObjectivesWithWeights.getWeights();
            for (int i = 0; i < newW.length; ++i) {
                try {
                    double d = 0.0;
                    newW[i] = d = Double.parseDouble(OptimizationObjectivesWithParamEditor.this.weights[i].getText());
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            OptimizationObjectivesWithParamEditor.this.optimizationObjectivesWithWeights.setWeights(newW);
        }
    };

    public OptimizationObjectivesWithParamEditor() {
        this.self = this;
    }

    private void initCustomEditor() {
        this.self = this;
        this.editor = new JPanel();
        this.editor.setPreferredSize(new Dimension(450, 200));
        this.editor.setMinimumSize(new Dimension(450, 200));
        InterfaceOptimizationObjective[] list = this.optimizationObjectivesWithWeights.getSelectedTargets();
        this.editors = new GeneralOptimizationEditorProperty[list.length];
        for (int i = 0; i < list.length; ++i) {
            this.editors[i] = new GeneralOptimizationEditorProperty();
            this.editors[i].name = list[i].getName();
            try {
                this.editors[i].value = list[i];
                this.editors[i].editor = PropertyEditorProvider.findEditor(this.editors[i].value.getClass());
                if (this.editors[i].editor == null) {
                    this.editors[i].editor = PropertyEditorProvider.findEditor(InterfaceOptimizationObjective.class);
                }
                if (this.editors[i].editor instanceof GenericObjectEditor) {
                    ((GenericObjectEditor)this.editors[i].editor).setClassType(InterfaceOptimizationObjective.class);
                }
                this.editors[i].editor.setValue(this.editors[i].value);
                this.editors[i].editor.addPropertyChangeListener(this);
                AbstractObjectEditor.findViewFor(this.editors[i]);
                if (this.editors[i].view == null) continue;
                this.editors[i].view.repaint();
                continue;
            }
            catch (Exception e) {
                System.out.println("Darn can't read the value...");
            }
        }
        this.targetList = new JPanel();
        this.updateTargetList();
        this.scrollTargets = new JScrollPane(this.targetList);
        this.editor.setLayout(new BorderLayout());
        this.editor.add((Component)this.scrollTargets, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        JButton addButton = new JButton("Add Opt. Target");
        JButton normButton = new JButton("Normalize Weights");
        normButton.setEnabled(this.optimizationObjectivesWithWeights.isNormalizationEnabled());
        normButton.addActionListener(this.normalizeWeights);
        addButton.addActionListener(this.addTarget);
        buttonPanel.add(normButton);
        buttonPanel.add(addButton);
        this.editor.add((Component)buttonPanel, "South");
        JTextArea jt = new JTextArea();
        jt.setFont(new Font("SansSerif", 0, 12));
        jt.setEditable(false);
        jt.setLineWrap(true);
        jt.setWrapStyleWord(true);
        jt.setText(this.optimizationObjectivesWithWeights.getDescriptiveString());
        jt.setBackground(this.getBackground());
        JPanel jp = new JPanel();
        jp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Info"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        jp.setLayout(new BorderLayout());
        jp.add((Component)jt, "Center");
        JPanel p2 = new JPanel();
        p2.setLayout(new BorderLayout());
        JButton help = new JButton("Help");
        help.setEnabled(false);
        p2.add((Component)help, "North");
        jp.add((Component)p2, "East");
        GridBagConstraints gbConstraints = new GridBagConstraints();
        this.editor.add((Component)jp, "North");
        this.updateEditor();
    }

    private void updateTargetList() {
        int i;
        BasicResourceLoader loader = BasicResourceLoader.getInstance();
        InterfaceOptimizationObjective[] list = this.optimizationObjectivesWithWeights.getSelectedTargets();
        double[] weights = this.optimizationObjectivesWithWeights.getWeights();
        this.targetList.removeAll();
        this.targetList.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.weights = new JTextField[list.length];
        this.targets = new JComponent[list.length];
        this.deleteButton = new JButton[list.length];
        String[] cups = new String[8];
        for (i = 0; i < cups.length; ++i) {
            cups[i] = "" + (i + 1);
        }
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.weightx = 2.0;
        this.targetList.add((Component)new JLabel(this.optimizationObjectivesWithWeights.getWeigthsLabel()), gbc);
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridx = 1;
        gbc.weightx = 10.0;
        this.targetList.add((Component)new JLabel("Target"), gbc);
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        this.targetList.add((Component)new JLabel("Remove"), gbc);
        for (i = 0; i < list.length; ++i) {
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.gridx = 0;
            gbc.weightx = 2.0;
            this.weights[i] = new JTextField("" + weights[i]);
            this.weights[i].addKeyListener(this.readDoubleArrayAction);
            this.targetList.add((Component)this.weights[i], gbc);
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.gridx = 1;
            gbc.weightx = 10.0;
            this.targets[i] = this.editors[i].view;
            this.targetList.add((Component)this.targets[i], gbc);
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.gridx = 2;
            gbc.weightx = 1.0;
            byte[] bytes = loader.getBytesFromResourceLocation("images/Sub24.gif", true);
            this.deleteButton[i] = new JButton("", new ImageIcon(Toolkit.getDefaultToolkit().createImage(bytes)));
            this.deleteButton[i].addActionListener(this.deleteTarget);
            this.targetList.add((Component)this.deleteButton[i], gbc);
        }
        this.targetList.repaint();
        this.targetList.validate();
        if (this.scrollTargets != null) {
            this.scrollTargets.validate();
            this.scrollTargets.repaint();
        }
        if (this.editor != null) {
            this.editor.validate();
            this.editor.repaint();
        }
    }

    private void updateEditor() {
        if (this.editor != null) {
            this.targetList.validate();
            this.targetList.repaint();
            this.scrollTargets.validate();
            this.scrollTargets.repaint();
            this.editor.validate();
            this.editor.repaint();
        }
    }

    @Override
    public void setValue(Object o) {
        if (o instanceof PropertyOptimizationObjectivesWithParam) {
            this.optimizationObjectivesWithWeights = (PropertyOptimizationObjectivesWithParam)o;
            this.updateEditor();
        }
    }

    @Override
    public Object getValue() {
        return this.optimizationObjectivesWithWeights;
    }

    @Override
    public String getJavaInitializationString() {
        return "TEST";
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException(text);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    public void addOkListener(ActionListener a) {
    }

    public void removeOkListener(ActionListener a) {
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getAscent()) / 2;
        String rep = "Optimization Targets With Weights";
        gfx.drawString(rep, 2, fm.getHeight() + vpad - 3);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.editor == null) {
            this.initCustomEditor();
        }
        return this.editor;
    }

    public void updateCenterComponent(PropertyChangeEvent evt) {
        this.updateEditor();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object newVal = evt.getNewValue();
        Object oldVal = evt.getOldValue();
        InterfaceOptimizationObjective[] list = this.optimizationObjectivesWithWeights.getSelectedTargets();
        for (int i = 0; i < list.length; ++i) {
            if (!oldVal.equals(list[i])) continue;
            list[i] = (InterfaceOptimizationObjective)newVal;
            this.editors[i].name = list[i].getName();
            try {
                this.editors[i].value = list[i];
                this.editors[i].editor = PropertyEditorProvider.findEditor(this.editors[i].value.getClass());
                if (this.editors[i].editor == null) {
                    this.editors[i].editor = PropertyEditorProvider.findEditor(InterfaceOptimizationObjective.class);
                }
                if (this.editors[i].editor instanceof GenericObjectEditor) {
                    ((GenericObjectEditor)this.editors[i].editor).setClassType(InterfaceOptimizationObjective.class);
                }
                this.editors[i].editor.setValue(this.editors[i].value);
                this.editors[i].editor.addPropertyChangeListener(this);
                AbstractObjectEditor.findViewFor(this.editors[i]);
                if (this.editors[i].view != null) {
                    this.editors[i].view.repaint();
                }
            }
            catch (Exception e) {
                System.out.println("Darn can't read the value...");
            }
            this.targets[i] = this.editors[i].view;
        }
        this.updateCenterComponent(evt);
        this.propertyChangeSupport.firePropertyChange("", this.optimizationObjectivesWithWeights, this.optimizationObjectivesWithWeights);
    }

    static /* synthetic */ GeneralOptimizationEditorProperty[] access$202(OptimizationObjectivesWithParamEditor x0, GeneralOptimizationEditorProperty[] x1) {
        x0.editors = x1;
        return x1;
    }
}

