/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui.editor;

import eva2.gui.editor.AbstractListSelectionEditor;
import eva2.tools.StringSelection;
import eva2.tools.StringTools;

public class StringSelectionEditor
extends AbstractListSelectionEditor {
    StringSelection strs = new StringSelection(new String[0], null);

    @Override
    protected boolean actionOnSelect() {
        for (int i = 0; i < this.blackCheck.length; ++i) {
            this.strs.setSelected(i, this.blackCheck[i].isSelected());
        }
        return true;
    }

    @Override
    protected int getElementCount() {
        return this.strs.getLength();
    }

    @Override
    protected String getElementName(int i) {
        return StringTools.humaniseCamelCase(this.strs.getElement(i));
    }

    @Override
    protected String getElementToolTip(int i) {
        return this.strs.getElementInfo(i);
    }

    @Override
    public Object getValue() {
        return this.strs;
    }

    @Override
    protected boolean isElementSelected(int i) {
        return this.strs.isSelected(i);
    }

    @Override
    protected boolean setObject(Object o) {
        if (o instanceof StringSelection) {
            this.strs = (StringSelection)o;
            return true;
        }
        return false;
    }

    @Override
    public String getAsText() {
        if (this.getElementCount() == 0) {
            return null;
        }
        StringBuilder sbuf = new StringBuilder("{");
        boolean first = true;
        for (int i = 0; i < this.getElementCount(); ++i) {
            if (!this.isElementSelected(i)) continue;
            if (!first) {
                sbuf.append(", ");
            }
            sbuf.append(this.getElementName(i));
            first = false;
        }
        sbuf.append("}");
        return sbuf.toString();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        for (int i = 0; i < this.getElementCount(); ++i) {
            this.strs.setSelected(i, text.contains(this.getElementName(i)));
        }
    }
}

