/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui.editor;

import eva2.gui.PropertyValueSelector;
import eva2.tools.BasicResourceLoader;
import eva2.tools.SelectedTag;
import eva2.tools.Tag;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import javax.swing.JFrame;

public class TagEditor
extends PropertyEditorSupport {
    @Override
    public String getJavaInitializationString() {
        SelectedTag s = (SelectedTag)this.getValue();
        Tag[] tags = s.getTags();
        String result = "new SelectedTag(" + s.getSelectedTag().getID() + ", {\n";
        for (int i = 0; i < tags.length; ++i) {
            result = result + "new Tag(" + tags[i].getID() + ",\"" + tags[i].getString() + "\")";
            if (i < tags.length - 1) {
                result = result + ',';
            }
            result = result + '\n';
        }
        return result + "})";
    }

    @Override
    public String getAsText() {
        SelectedTag s = (SelectedTag)this.getValue();
        return s.getSelectedTag().getString();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        SelectedTag s = (SelectedTag)this.getValue();
        Tag[] tags = s.getTags();
        try {
            for (int i = 0; i < tags.length; ++i) {
                if (!text.equals(tags[i].getString())) continue;
                this.setValue(new SelectedTag(tags[i].getID(), tags));
                return;
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(text);
        }
    }

    @Override
    public String[] getTags() {
        SelectedTag s = (SelectedTag)this.getValue();
        Tag[] tags = s.getTags();
        String[] result = new String[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            result[i] = tags[i].getString();
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            PropertyEditorManager.registerEditor(SelectedTag.class, TagEditor.class);
            Tag[] tags = new Tag[]{new Tag(0, "First option"), new Tag(1, "Second option"), new Tag(2, "Third option"), new Tag(3, "Fourth option"), new Tag(4, "Fifth option")};
            SelectedTag initial = new SelectedTag(1, tags);
            TagEditor ce = new TagEditor();
            ce.setValue(initial);
            PropertyValueSelector ps = new PropertyValueSelector(ce);
            JFrame f = new JFrame();
            BasicResourceLoader loader = BasicResourceLoader.getInstance();
            byte[] bytes = loader.getBytesFromResourceLocation("images/icon.png", true);
            f.setIconImage(Toolkit.getDefaultToolkit().createImage(bytes));
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            f.getContentPane().setLayout(new BorderLayout());
            f.getContentPane().add((Component)ps, "Center");
            f.pack();
            f.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

