/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui.plot;

import eva2.tools.chart2d.DArray;
import eva2.tools.chart2d.DBorder;
import eva2.tools.chart2d.DComponent;
import eva2.tools.chart2d.DIntDoubleMap;
import eva2.tools.chart2d.DMeasures;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.DPointIcon;
import eva2.tools.chart2d.DPointSet;
import eva2.tools.chart2d.DRectangle;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.util.ArrayList;

public class DPointSetMultiIcon
extends DComponent {
    protected boolean connectedMI;
    protected DPointIcon iconMI = null;
    protected JumpManager jumperMI = new JumpManager();
    protected ArrayList<DPointIcon> iconsMI = new ArrayList();
    protected Stroke strokeMI = new BasicStroke();
    protected DIntDoubleMap xMI;
    protected DIntDoubleMap yMI;

    public DPointSetMultiIcon() {
        this(10, 2);
    }

    public DPointSetMultiIcon(DIntDoubleMap x_values, DIntDoubleMap y_values) {
        if (x_values.getSize() != y_values.getSize()) {
            throw new IllegalArgumentException("The number of x-values has to be the same than the number of y-values");
        }
        this.xMI = x_values;
        this.yMI = y_values;
        this.restore();
        this.setDBorder(new DBorder(1, 1, 1, 1));
    }

    public DPointSetMultiIcon(int initial_capacity) {
        this(initial_capacity, 2);
    }

    public DPointSetMultiIcon(int initial_capacity, int length_multiplier) {
        this(new DArray(initial_capacity, length_multiplier), new DArray(initial_capacity, length_multiplier));
    }

    public void addDPoint(double x, double y) {
        this.addDPoint(new DPoint(x, y));
    }

    public void addDPoint(DPoint p) {
        this.xMI.addImage(p.x);
        this.yMI.addImage(p.y);
        this.iconsMI.add(p.getIcon());
        this.rectangle.insert(p);
        this.repaint();
    }

    public DPoint getDPoint(int index) {
        if (index >= this.xMI.getSize()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        DPoint p = new DPoint(this.xMI.getImage(index), this.yMI.getImage(index));
        p.setIcon(this.iconMI);
        p.setColor(this.color);
        return p;
    }

    public DPointSet getDPointSet() {
        return new DPointSet(this.xMI, this.yMI);
    }

    public DPointIcon getIcon() {
        return this.iconMI;
    }

    public ArrayList<DPointIcon> getIconsMI() {
        return this.iconsMI;
    }

    public DPoint getNearestDPoint(DPoint point) {
        int minIndex = this.getNearestDPointIndex(point);
        if (minIndex == -1) {
            return null;
        }
        DPoint result = new DPoint(this.xMI.getImage(minIndex), this.yMI.getImage(minIndex));
        result.setIcon(this.iconsMI.get(minIndex));
        return result;
    }

    public int getNearestDPointIndex(DPoint point) {
        double minValue = Double.MAX_VALUE;
        int minIndex = -1;
        for (int i = 0; i < this.xMI.getSize(); ++i) {
            double dy;
            double dx = point.x - this.xMI.getImage(i);
            double dummy = dx * dx + (dy = point.y - this.yMI.getImage(i)) * dy;
            if (!(dummy < minValue)) continue;
            minValue = dummy;
            minIndex = i;
        }
        return minIndex;
    }

    public int getSize() {
        return Math.min(this.xMI.getSize(), this.yMI.getSize());
    }

    public Stroke getStroke() {
        return this.strokeMI;
    }

    public void jump() {
        this.jumperMI.addJump();
    }

    @Override
    public void paint(DMeasures m) {
        try {
            Graphics2D g = (Graphics2D)m.getGraphics();
            g.setStroke(this.strokeMI);
            if (this.color != null) {
                g.setColor(this.color);
            }
            int size = this.getSize();
            if (this.connectedMI && size > 1) {
                this.jumperMI.restore();
                while (this.jumperMI.hasMoreIntervals()) {
                    int[] interval = this.jumperMI.nextInterval();
                    Point p1 = null;
                    for (int i = interval[0]; i < interval[1]; ++i) {
                        Point p2 = m.getPoint(this.xMI.getImage(i), this.yMI.getImage(i));
                        if (p1 != null && p2 != null) {
                            g.drawLine(p1.x, p1.y, p2.x, p2.y);
                        }
                        if (i < this.iconsMI.size() && this.iconsMI.get(i) != null) {
                            g.setStroke(new BasicStroke());
                            g.translate(p2.x, p2.y);
                            this.iconsMI.get(i).paint(g);
                            g.translate(-p2.x, -p2.y);
                            g.setStroke(this.strokeMI);
                        } else if (this.iconMI != null) {
                            g.setStroke(new BasicStroke());
                            g.translate(p2.x, p2.y);
                            this.iconMI.paint(g);
                            g.translate(-p2.x, -p2.y);
                            g.setStroke(this.strokeMI);
                        }
                        p1 = p2;
                    }
                }
            } else {
                for (int i = 0; i < this.iconsMI.size(); ++i) {
                    try {
                        Point p = m.getPoint(this.xMI.getImage(i), this.yMI.getImage(i));
                        if (p == null) continue;
                        if (this.iconsMI.get(i) != null) {
                            g.setStroke(new BasicStroke());
                            g.translate(p.x, p.y);
                            this.iconsMI.get(i).paint(g);
                            g.translate(-p.x, -p.y);
                            g.setStroke(this.strokeMI);
                            continue;
                        }
                        if (this.iconMI == null) {
                            g.drawLine(p.x - 1, p.y - 1, p.x + 1, p.y + 1);
                            g.drawLine(p.x + 1, p.y - 1, p.x - 1, p.y + 1);
                            continue;
                        }
                        g.setStroke(new BasicStroke());
                        g.translate(p.x, p.y);
                        this.iconMI.paint(g);
                        g.translate(-p.x, -p.y);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        System.out.println("The rectangle lies not in the currently painted rectangle.");
                    }
                }
            }
            g.setStroke(new BasicStroke());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void removeAllPoints() {
        if (this.xMI.getSize() == 0) {
            return;
        }
        this.xMI.reset();
        this.yMI.reset();
        this.jumperMI.reset();
        this.repaint();
        this.rectangle = DRectangle.getEmpty();
    }

    public void removeJumps() {
        this.jumperMI.reset();
    }

    protected void restore() {
        if (this.getSize() == 0) {
            this.rectangle = DRectangle.getEmpty();
            return;
        }
        double min_x = this.xMI.getMinImageValue();
        double max_x = this.xMI.getMaxImageValue();
        double min_y = this.yMI.getMinImageValue();
        double max_y = this.yMI.getMaxImageValue();
        this.rectangle = new DRectangle(min_x, min_y, max_x - min_x, max_y - min_y);
    }

    public void setConnected(boolean aFlag) {
        boolean changed = aFlag != this.connectedMI;
        this.connectedMI = aFlag;
        if (changed) {
            this.repaint();
        }
    }

    public void setDPoint(int index, DPoint p) {
        if (index >= this.xMI.getSize()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.rectangle.insert(p);
        this.xMI.setImage(index, p.x);
        this.yMI.setImage(index, p.y);
        this.iconsMI.set(index, p.getIcon());
        this.restore();
        this.repaint();
    }

    public void setIcon(DPointIcon icon) {
        this.iconMI = icon;
        if (icon == null) {
            this.setDBorder(new DBorder(1, 1, 1, 1));
        } else {
            this.setDBorder(icon.getDBorder());
        }
    }

    public void setStroke(Stroke s) {
        if (s == null) {
            s = new BasicStroke();
        }
        this.strokeMI = s;
        this.repaint();
    }

    public String toString() {
        String text = "eva2.tools.chart2d.DPointSet[size:" + this.getSize();
        for (int i = 0; i < this.xMI.getSize(); ++i) {
            text = text + ",(" + this.xMI.getImage(i) + "," + this.yMI.getImage(i) + ")";
        }
        text = text + "]";
        return text;
    }

    class JumpManager {
        protected int index = -1;
        protected ArrayList<Integer> jumps = new ArrayList();

        JumpManager() {
        }

        public void addJump() {
            this.jumps.add(DPointSetMultiIcon.this.getSize());
        }

        public boolean hasMoreIntervals() {
            return this.index < this.jumps.size();
        }

        public int[] nextInterval() {
            int no_jumps = this.jumps.size();
            if (this.index >= no_jumps) {
                throw new ArrayIndexOutOfBoundsException("No more intervals in JumpManager");
            }
            int[] inter = new int[2];
            inter[0] = this.index == -1 ? 0 : this.jumps.get(this.index);
            ++this.index;
            inter[1] = this.index < no_jumps ? this.jumps.get(this.index).intValue() : DPointSetMultiIcon.this.getSize();
            return inter;
        }

        public void reset() {
            this.index = -1;
            this.jumps.clear();
        }

        public void restore() {
            this.index = -1;
        }
    }
}

