/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui.plot;

import eva2.tools.chart2d.DFunction;

public class Exp
extends DFunction {
    private double minValue = 1.0E-10;

    public void setMinValue(double v) {
        if (v > 0.0) {
            this.minValue = v;
        } else {
            System.err.println("Error, minimal value for Exp must be positive!");
        }
    }

    @Override
    public boolean isDefinedAt(double source) {
        return true;
    }

    @Override
    public boolean isInvertibleAt(double image) {
        return image > 0.0;
    }

    @Override
    public double getImageOf(double source) {
        return Math.exp(source);
    }

    @Override
    public double getSourceOf(double target) {
        if (target <= 0.0) {
            return Math.log(this.minValue);
        }
        return Math.log(target);
    }

    public void updateMinValue(double y) {
        if (y < this.minValue && y > 0.0) {
            this.minValue = y;
        }
    }
}

