/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui.plot;

import eva2.gui.InterfaceSelectablePointIcon;
import eva2.gui.plot.Exp;
import eva2.gui.plot.GraphPointSet;
import eva2.gui.plot.GraphPointSetLegend;
import eva2.gui.plot.InterfaceDPointWithContent;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.mocco.paretofrontviewer.InterfaceRefPointListener;
import eva2.tools.ToolBoxGui;
import eva2.tools.chart2d.DArea;
import eva2.tools.chart2d.DBorder;
import eva2.tools.chart2d.DFunction;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.DPointIcon;
import eva2.tools.chart2d.DPointIconCircle;
import eva2.tools.chart2d.DPointIconContent;
import eva2.tools.chart2d.DPointIconCross;
import eva2.tools.chart2d.DPointIconPoint;
import eva2.tools.chart2d.DPointIconText;
import eva2.tools.chart2d.DPointSet;
import eva2.tools.chart2d.ScaledBorder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class FunctionArea
extends DArea
implements Serializable {
    private static final long serialVersionUID = 1238444548498667204L;
    private static final Logger LOGGER = Logger.getLogger(FunctionArea.class.getName());
    private GraphPointSetLegend legendBox = null;
    private ScaledBorder scaledBorder;
    private DPointIcon currentPointIcon;
    private boolean legend = true;
    private boolean log = false;
    private ArrayList<GraphPointSet> pointSetContainer;
    private InterfaceRefPointListener refPointListener;
    private int xPos;
    private int yPos;
    private boolean notifyNegLog = true;
    private boolean doShowGraphToolTips = true;
    private boolean appendIndexInLegend = false;

    public FunctionArea() {
        this.setToolTipText("Graph Info ");
    }

    public FunctionArea(String xname, String yname) {
        this();
        this.setIgnoreRepaint(true);
        this.setPreferredSize(new Dimension(600, 500));
        this.setVisibleRectangle(1.0, 1.0, 100000.0, 1000.0);
        this.setAutoFocus(true);
        this.setMinRectangle(0.0, 0.0, 1.0, 1.0);
        this.setBackground(new Color(253, 253, 253));
        this.scaledBorder = new ScaledBorder();
        this.scaledBorder.xLabel = xname;
        this.scaledBorder.yLabel = yname;
        this.setBorder(this.scaledBorder);
        this.setAutoGrid(true);
        this.setGridVisible(true);
        this.pointSetContainer = new ArrayList(20);
        this.addPopup();
        this.repaint();
        this.notifyNegLog = true;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.isShowGraphToolTips()) {
            int gIndex = this.getNearestGraphIndex(event.getX(), event.getY());
            if (gIndex >= 0) {
                StringBuilder sb = new StringBuilder(super.getToolTipText());
                sb.append(gIndex);
                sb.append(": ");
                sb.append(this.getGraphInfo(gIndex));
                return sb.toString();
            }
            return null;
        }
        return null;
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        if (this.isShowGraphToolTips()) {
            int gIndex = this.getNearestGraphIndex(event.getX(), event.getY());
            if (gIndex >= 0) {
                DPoint pt = this.pointSetContainer.get(gIndex).getMedPoint();
                Point pt2 = this.getDMeasures().getPoint(pt.x, pt.y);
                pt2.x += 5 * (gIndex % 7);
                pt2.y -= 10 + gIndex % 3 * 5;
                return pt2;
            }
            return null;
        }
        return null;
    }

    public void addGraph(int GraphLabel_1, int GraphLabel_2, boolean forceAdd) {
        this.getGraphPointSet(GraphLabel_1).addGraph(this.getGraphPointSet(GraphLabel_2), this.getDMeasures(), forceAdd);
        this.notifyNegLog = true;
    }

    public void addGraphPointSet(GraphPointSet d) {
        this.pointSetContainer.add(d);
    }

    private void addPopup() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16) {
                    DPoint point;
                    JPopupMenu graphPopupMenu = new JPopupMenu();
                    FunctionArea.this.xPos = e.getX();
                    FunctionArea.this.yPos = e.getY();
                    FunctionArea.this.addMenuItem(graphPopupMenu, "Rename graph", ee -> FunctionArea.this.renameGraph(FunctionArea.this.getNearestGraphIndex(FunctionArea.this.xPos, FunctionArea.this.yPos)));
                    String togGTTName = (FunctionArea.this.isShowGraphToolTips() ? "Deactivate" : "Activate") + " graph tool tips";
                    FunctionArea.this.addMenuItem(graphPopupMenu, togGTTName, ee -> FunctionArea.this.setShowGraphToolTips(!FunctionArea.this.isShowGraphToolTips()));
                    String toggleLegend = (FunctionArea.this.isShowLegend() ? "Hide" : "Show") + " legend";
                    FunctionArea.this.addMenuItem(graphPopupMenu, toggleLegend, ee -> FunctionArea.this.toggleLegend());
                    String toggleGrid = (FunctionArea.this.isShowGrid() ? "Hide" : "Show") + " grid";
                    FunctionArea.this.addMenuItem(graphPopupMenu, toggleGrid, ee -> FunctionArea.this.toggleShowGrid());
                    FunctionArea.this.addMenuItem(graphPopupMenu, "Toggle scientific format", ee -> FunctionArea.this.toggleScientificY(true));
                    if (FunctionArea.this.pointSetContainer.size() > 0) {
                        FunctionArea.this.addMenuItem(graphPopupMenu, "Recolor all graphs", ee -> FunctionArea.this.recolorAllGraphsByIndex());
                    }
                    if (FunctionArea.this.refPointListener != null) {
                        DPoint temp = FunctionArea.this.getDMeasures().getDPoint(FunctionArea.this.xPos, FunctionArea.this.yPos);
                        FunctionArea.this.addMenuItem(graphPopupMenu, "Select Reference Point:(" + temp.x + "/" + temp.y + ")", ee -> {
                            DPoint temp1 = FunctionArea.this.getDMeasures().getDPoint(FunctionArea.this.xPos, FunctionArea.this.yPos);
                            double[] point = new double[]{temp1.x, temp1.y};
                            FunctionArea.this.refPointListener.refPointGiven(point);
                        });
                    }
                    if ((point = FunctionArea.this.getNearestDPoint(e.getX(), e.getY())) != null) {
                        FunctionArea.this.addMenuItem(graphPopupMenu, "Nearest point: (" + point.x + "/" + point.y + ")", ee -> {}, false);
                        FunctionArea.this.addMenuItem(graphPopupMenu, "  Remove point", ee -> FunctionArea.this.removePoint(FunctionArea.this.xPos, FunctionArea.this.yPos));
                        if (point.getIcon() instanceof InterfaceSelectablePointIcon) {
                            FunctionArea.this.currentPointIcon = point.getIcon();
                            if (((InterfaceSelectablePointIcon)((Object)FunctionArea.this.currentPointIcon)).getSelectionListener() != null) {
                                AbstractEAIndividual indy = ((InterfaceSelectablePointIcon)((Object)FunctionArea.this.currentPointIcon)).getEAIndividual();
                                String selectTitle = indy.isMarked() ? "  Deselect individual" : "  Select individual";
                                FunctionArea.this.addMenuItem(graphPopupMenu, selectTitle, ee -> ((InterfaceSelectablePointIcon)((Object)FunctionArea.this.currentPointIcon)).getSelectionListener().individualSelected(((InterfaceSelectablePointIcon)((Object)FunctionArea.this.currentPointIcon)).getEAIndividual()));
                            }
                        }
                        if (point.getIcon() instanceof InterfaceDPointWithContent) {
                            FunctionArea.this.currentPointIcon = point.getIcon();
                            FunctionArea.this.addMenuItem(graphPopupMenu, "  Show individual", ee -> ((InterfaceDPointWithContent)((Object)FunctionArea.this.currentPointIcon)).showIndividual());
                        }
                    }
                    if (FunctionArea.this.pointSetContainer.size() > 0) {
                        FunctionArea.this.addMenuItem(graphPopupMenu, "Graph Info: " + FunctionArea.this.getGraphInfo(e.getX(), e.getY()), ee -> {
                            DPoint temp = FunctionArea.this.getDMeasures().getDPoint(FunctionArea.this.xPos, FunctionArea.this.yPos);
                            DPointIcon icon1 = new DPointIcon(){

                                @Override
                                public DBorder getDBorder() {
                                    return new DBorder(4, 4, 4, 4);
                                }

                                @Override
                                public void paint(Graphics g) {
                                    g.drawLine(-2, 0, 2, 0);
                                    g.drawLine(0, 0, 0, 4);
                                }
                            };
                            temp.setIcon(icon1);
                            FunctionArea.this.addDElement(temp);
                        }, false);
                        FunctionArea.this.addMenuItem(graphPopupMenu, "  Remove graph", ee -> FunctionArea.this.clearGraph(FunctionArea.this.xPos, FunctionArea.this.yPos));
                        FunctionArea.this.addMenuItem(graphPopupMenu, "  Change graph color", ee -> FunctionArea.this.changeColorGraph(FunctionArea.this.xPos, FunctionArea.this.yPos));
                    }
                    graphPopupMenu.show(FunctionArea.this, e.getX(), e.getY());
                }
            }
        });
    }

    private JMenuItem addMenuItem(JPopupMenu menu, String title, ActionListener aListener) {
        return this.addMenuItem(menu, title, aListener, true);
    }

    private JMenuItem addMenuItem(JPopupMenu menu, String title, ActionListener aListener, boolean enabled) {
        JMenuItem item = new JMenuItem(title);
        item.addActionListener(aListener);
        item.setEnabled(enabled);
        menu.add(item);
        return item;
    }

    public void addRefPointSelectionListener(InterfaceRefPointListener a) {
        this.refPointListener = a;
    }

    public void changeColorGraph(int GraphLabel) {
        this.getGraphPointSet(GraphLabel).incColor();
        this.repaint();
    }

    public void setColorByIndex(int graphLabel, int colorIndex) {
        this.getGraphPointSet(graphLabel).setColorByIndex(colorIndex);
    }

    public void changeColorGraph(int x, int y) {
        int index = this.getNearestGraphIndex(x, y);
        if (index == -1) {
            return;
        }
        int GraphLabel = this.pointSetContainer.get(index).getGraphLabel();
        this.changeColorGraph(GraphLabel);
        this.updateLegend();
    }

    public void recolorAllGraphsByIndex() {
        int index = 0;
        for (int i = 0; i < this.pointSetContainer.size(); ++i) {
            GraphPointSet gps = this.pointSetContainer.get(i);
            if (gps.getPointCount() <= 0) continue;
            gps.setColorByIndex(index);
            ++index;
        }
        this.updateLegend();
    }

    public boolean checkLoggable() {
        double minY = Double.MAX_VALUE;
        for (int i = 0; i < this.pointSetContainer.size(); ++i) {
            DPointSet pSet = this.pointSetContainer.get(i).getConnectedPointSet();
            if (pSet.getSize() <= 0) continue;
            minY = Math.min(minY, pSet.getMinYVal());
        }
        return minY > 0.0;
    }

    protected double getMinimalPositiveYValue() {
        double minY = Double.MAX_VALUE;
        for (int i = 0; i < this.pointSetContainer.size(); ++i) {
            double tmpMinY;
            DPointSet pSet = this.pointSetContainer.get(i).getConnectedPointSet();
            if (pSet.getSize() <= 0 || !((tmpMinY = Math.min(minY, pSet.getMinPositiveYValue())) > 0.0)) continue;
            minY = tmpMinY;
        }
        return minY;
    }

    protected boolean checkLogValidYValue(double x, double y, int graphLabel) {
        if (y <= 0.0) {
            if (this.log && this.notifyNegLog) {
                System.err.println("Warning: trying to plot value (" + x + "/" + y + ") with y <= 0 in logarithmic mode!");
                this.notifyNegLog = false;
            }
            return false;
        }
        return true;
    }

    private String cleanBlanks(String str, Character rpl) {
        return str.replace(' ', rpl.charValue());
    }

    public void clearAll() {
        this.removeAllDElements();
        for (int i = 0; i < this.pointSetContainer.size(); ++i) {
            this.pointSetContainer.get(i).removeAllPoints();
        }
        this.pointSetContainer.clear();
        if (this.getYScale() instanceof Exp) {
            this.setYScale(new Exp());
        }
        this.notifyNegLog = true;
    }

    public void clearGraph(int graphLabel) {
        this.getGraphPointSet(graphLabel).removeAllPoints();
        this.pointSetContainer.remove(this.getGraphPointSet(graphLabel));
        if (this.getYScale() instanceof Exp) {
            ((Exp)this.getYScale()).setMinValue(this.getMinimalPositiveYValue());
        }
        this.repaint();
        this.notifyNegLog = true;
    }

    public void clearGraph(int x, int y) {
        int index = this.getNearestGraphIndex(x, y);
        if (index == -1) {
            return;
        }
        int GraphLabel = this.pointSetContainer.get(index).getGraphLabel();
        this.clearGraph(GraphLabel);
        this.updateLegend();
    }

    public void clearLegend() {
        this.setLegend(null);
    }

    protected void createFileChooser() {
        JFileChooser fileChooser = new JFileChooser(new File("/resources"));
        fileChooser.setFileSelectionMode(0);
    }

    public void drawCircle(char c, double val, double[] position, int graphID) {
        this.drawCircle(c + "" + val, position, graphID);
    }

    public void drawCircle(double val, double[] position, int graphID) {
        this.drawCircle("" + val, position, graphID);
    }

    public void drawCircle(String label, double xPos, double yPos, int graphID) {
        double[] pos = new double[]{xPos, yPos};
        this.drawCircle(label, pos, graphID);
    }

    public void drawCircle(String label, double[] position, int graphID) {
        this.drawIcon(new DPointIconCircle(), label, position, graphID);
    }

    public void drawIcon(DPointIcon theIcon, String label, double[] position, int graphID) {
        DPointSet popRep = new DPointSet();
        popRep.addDPoint(new DPoint(position[0], position[1]));
        DPointIconText icon = new DPointIconText(label);
        icon.setIcon(theIcon);
        icon.setColor(this.getGraphPointSet(graphID).getColor());
        popRep.setIcon(icon);
        this.addDElement(popRep);
    }

    public void drawIcon(int iconType, String label, double[] position, int graphID) {
        DPointIcon theIcon;
        switch (iconType) {
            case 0: {
                theIcon = new DPointIconCircle();
                break;
            }
            case 1: {
                theIcon = new DPointIconCross();
                break;
            }
            default: {
                theIcon = new DPointIconPoint();
            }
        }
        this.drawIcon(theIcon, label, position, graphID);
    }

    public void drawLine(double[] p1, double[] p2) {
        DPointSet popRep = new DPointSet();
        popRep.setConnected(true);
        popRep.addDPoint(new DPoint(p1[0], p1[1]));
        popRep.addDPoint(new DPoint(p2[0], p2[1]));
        this.addDElement(popRep);
    }

    public void exportToAscii() {
        this.exportToAscii((File)null);
    }

    public boolean exportToAscii(File file) {
        int j;
        int i;
        String[] s = null;
        int maxSize = 0;
        for (i = 0; i < this.pointSetContainer.size(); ++i) {
            if (this.pointSetContainer.get(i).getConnectedPointSet().getSize() <= maxSize) continue;
            maxSize = this.pointSetContainer.get(i).getConnectedPointSet().getSize();
        }
        if (maxSize > 0) {
            s = new String[maxSize + 1];
            for (j = 0; j <= maxSize; ++j) {
                s[j] = "";
            }
        } else {
            System.err.println("Error: no data to export");
            return true;
        }
        for (i = 0; i < this.pointSetContainer.size(); ++i) {
            if (this.pointSetContainer.get(i) != null) {
                GraphPointSet set = this.pointSetContainer.get(i);
                DPointSet pset = set.getConnectedPointSet();
                s[0] = s[0] + " t " + this.cleanBlanks(set.getInfoString(), Character.valueOf('_'));
                for (int j2 = 1; j2 < s.length; ++j2) {
                    if (j2 - 1 < pset.getSize()) {
                        s[j2] = s[j2] + " " + pset.getDPoint((int)(j2 - 1)).x + " " + pset.getDPoint((int)(j2 - 1)).y;
                        continue;
                    }
                    int n = j2;
                    s[n] = s[n] + " ? ?";
                }
                continue;
            }
            System.err.println("error in FunctionArea::exportToAscii");
        }
        if (file == null) {
            for (j = 0; j < s.length; ++j) {
                System.out.println(s[j]);
            }
            return true;
        }
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(file));
            for (int j3 = 0; j3 < s.length; ++j3) {
                out.println(s[j3]);
            }
            out.flush();
            out.close();
            return true;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Error while writing to file.", ex);
            return false;
        }
    }

    public boolean exportToAscii(String prefix) {
        SimpleDateFormat formatter = new SimpleDateFormat("E'_'yyyy.MM.dd'_'HH.mm.ss");
        String fname = prefix + "PlotExport_" + formatter.format(new Date()) + ".txt";
        try {
            File f = new File(fname);
            f.createNewFile();
            return this.exportToAscii(f);
        }
        catch (Exception e) {
            System.err.println("Error:" + e.getMessage());
            return false;
        }
    }

    public int getContainerSize() {
        return this.pointSetContainer.size();
    }

    public String getGraphInfo(int x, int y) {
        String ret = "";
        if (this.pointSetContainer == null || this.pointSetContainer.size() == 0) {
            return ret;
        }
        int minindex = this.getNearestGraphIndex(x, y);
        if (minindex >= 0) {
            return this.pointSetContainer.get(minindex).getInfoString();
        }
        return "none";
    }

    public String getGraphInfo(int graphIndex) {
        String ret = "";
        if (this.pointSetContainer == null || this.pointSetContainer.size() == 0) {
            return ret;
        }
        if (graphIndex >= 0 && graphIndex < this.pointSetContainer.size()) {
            return this.pointSetContainer.get(graphIndex).getInfoString();
        }
        return "none";
    }

    public Color getGraphColor(int graphIndex) {
        if (graphIndex >= 0) {
            return this.pointSetContainer.get(graphIndex).getColor();
        }
        return null;
    }

    private GraphPointSet getGraphPointSet(int GraphLabel) {
        for (int i = 0; i < this.pointSetContainer.size(); ++i) {
            GraphPointSet xx;
            if (!(this.pointSetContainer.get(i) instanceof GraphPointSet) || (xx = this.pointSetContainer.get(i)).getGraphLabel() != GraphLabel) continue;
            return xx;
        }
        GraphPointSet NewPointSet = new GraphPointSet(GraphLabel, this);
        return NewPointSet;
    }

    private DPoint getNearestDPoint(int x, int y) {
        double distmin = 1.0E7;
        DPoint ret = null;
        DPoint point1 = this.getDMeasures().getDPoint(x, y);
        DPoint point2 = null;
        double dist = 0.0;
        for (int i = 0; i < this.pointSetContainer.size(); ++i) {
            GraphPointSet pointset;
            if (this.pointSetContainer.get(i) == null || (point2 = (pointset = this.pointSetContainer.get(i)).getNearestDPoint(point1)) == null) continue;
            dist = (point1.x - point2.x) * (point1.x - point2.x) + (point1.y - point2.y) * (point1.y - point2.y);
            if (dist < distmin) {
                distmin = dist;
                ret = point2;
            }
            if (dist != distmin || ret.getIcon() instanceof DPointIconContent || ret.getIcon() instanceof InterfaceSelectablePointIcon) continue;
            distmin = dist;
            ret = point2;
        }
        return ret;
    }

    private int getNearestGraphIndex(int x, int y) {
        double distmin = 1.0E7;
        int minindex = -1;
        DPoint point1 = this.getDMeasures().getDPoint(x, y);
        DPoint point2 = null;
        double dist = 0.0;
        for (int i = 0; i < this.pointSetContainer.size(); ++i) {
            GraphPointSet pointset = this.pointSetContainer.get(i);
            point2 = pointset.getNearestDPoint(point1);
            if (point2 == null) continue;
            if (point1 == null) {
                System.err.println("point1 == null");
            }
            if (!((dist = (point1.x - point2.x) * (point1.x - point2.x) + (point1.y - point2.y) * (point1.y - point2.y)) < distmin)) continue;
            distmin = dist;
            minindex = i;
        }
        return minindex;
    }

    public int getPointCount(int label) {
        return this.getGraphPointSet(label).getPointCount();
    }

    public InterfaceRefPointListener getRefPointSelectionListener() {
        return this.refPointListener;
    }

    public boolean isStatisticsGraph(int x, int y) {
        boolean ret = false;
        if (this.pointSetContainer == null || this.pointSetContainer.size() == 0) {
            return ret;
        }
        int minindex = this.getNearestGraphIndex(x, y);
        ret = this.pointSetContainer.get(minindex).isStatisticsGraph();
        return ret;
    }

    public void jump() {
        for (int i = 0; i < this.pointSetContainer.size(); ++i) {
            this.pointSetContainer.get(i).jump();
        }
    }

    @Override
    public void paint(Graphics g) {
        Dimension winDim = this.getSize();
        int theHeight = winDim.height;
        int theWidth = winDim.width;
        BufferedImage bufferedImage = new BufferedImage(theWidth, theHeight, 1);
        Graphics2D g2D = bufferedImage.createGraphics();
        if (this.legendBox != null && this.legend) {
            this.legendBox.paintIn(g2D, this.scaledBorder.getInnerRect(this));
        }
        super.paint(g2D);
        g.drawImage(bufferedImage, 0, 0, this);
    }

    public DPointSet[] printPoints() {
        DPointSet[] ret = new DPointSet[this.pointSetContainer.size()];
        for (int i = 0; i < this.pointSetContainer.size(); ++i) {
            System.out.println("");
            System.out.println("GraphPointSet No " + i);
            ret[i] = this.pointSetContainer.get(i).printPoints();
        }
        return ret;
    }

    public DPointSet printPoints(int i) {
        System.out.println("");
        System.out.println("GraphPointSet No " + i);
        return this.pointSetContainer.get(i).printPoints();
    }

    public void removePoint(int x, int y) {
        DPoint point = this.getNearestDPoint(x, y);
        int index = this.getNearestGraphIndex(x, y);
        if (index == -1 || point == null) {
            return;
        }
        GraphPointSet pointset = this.pointSetContainer.get(index);
        pointset.removePoint(point);
    }

    public void removeRefPointSelectionListeners() {
        this.refPointListener = null;
    }

    public void setConnectedPoint(double x, double y, int graphLabel) {
        DFunction scF = this.getYScale();
        if (scF instanceof Exp) {
            ((Exp)scF).updateMinValue(y);
        }
        this.getGraphPointSet(graphLabel).addDPoint(x, y);
    }

    public void setConnectedPoint(double[] p, int graphLabel) {
        this.setConnectedPoint(p[0], p[1], graphLabel);
    }

    public void setGraphColor(int GraphLabel, Color color) {
        this.getGraphPointSet(GraphLabel).setColor(color);
    }

    public void setGraphColor(int GraphLabel, int colorindex) {
        this.getGraphPointSet(GraphLabel).setColorByIndex(colorindex);
    }

    public void setInfoString(int GraphLabel, String Info, float stroke) {
        this.getGraphPointSet(GraphLabel).setInfoString(Info, stroke);
    }

    protected void setLegend(GraphPointSetLegend lBox) {
        this.legendBox = lBox;
        if (lBox != null && this.legend) {
            this.repaint();
        }
    }

    public void setUnconnectedPoint(double x, double y, int GraphLabel) {
        DFunction scF = this.getYScale();
        if (scF instanceof Exp) {
            ((Exp)scF).updateMinValue(y);
        }
        this.getGraphPointSet(GraphLabel).addDPoint(x, y);
        this.getGraphPointSet(GraphLabel).setConnectedMode(false);
        this.repaint();
    }

    public void setUnconnectedPoint(double[] p, int GraphLabel) {
        this.setUnconnectedPoint(p[0], p[1], GraphLabel);
    }

    private void toggleLegend() {
        this.legend = !this.legend;
        this.repaint();
    }

    public boolean isShowLegend() {
        return this.legend;
    }

    public void setShowLegend(boolean on) {
        this.legend = on;
        this.legendBox = !on ? null : new GraphPointSetLegend(this.pointSetContainer, this.isAppendIndexInLegend());
        this.repaint();
    }

    private boolean renameGraph(int graphIndex) {
        if (this.pointSetContainer == null || this.pointSetContainer.size() == 0) {
            return false;
        }
        if (graphIndex >= 0 && graphIndex < this.pointSetContainer.size()) {
            String oldName = this.getGraphInfo(graphIndex);
            String newName = ToolBoxGui.getInputPaneInitialVal(this, "Rename a graph", "Enter new name for graph " + graphIndex + ":", oldName);
            if (newName != null) {
                return this.renameGraph(graphIndex, newName);
            }
            return true;
        }
        return false;
    }

    private boolean renameGraph(int graphIndex, String newName) {
        if (this.pointSetContainer == null || this.pointSetContainer.size() == 0) {
            return false;
        }
        if (graphIndex >= 0 && graphIndex < this.pointSetContainer.size()) {
            GraphPointSet gps = this.pointSetContainer.get(graphIndex);
            gps.setInfoString(newName);
            this.updateLegend();
            return true;
        }
        return false;
    }

    public void toggleLog() {
        boolean setMinPos = false;
        if (!this.log && !this.checkLoggable()) {
            LOGGER.warning("Toggling logarithmic scale with values <= 0! Some points will not be displayed.");
            setMinPos = true;
        }
        if (!this.log) {
            this.setMinRectangle(0.001, 0.001, 1.0, 1.0);
            Exp exp = new Exp();
            if (setMinPos) {
                exp.setMinValue(this.getMinimalPositiveYValue());
            }
            this.setYScale(exp);
            this.scaledBorder.setSrcdY(Math.log(10.0));
            this.scaledBorder.setScientificPattern(false);
            this.log = true;
        } else {
            this.log = false;
            this.setYScale(null);
            ScaledBorder buffer = this.scaledBorder;
            this.scaledBorder = new ScaledBorder();
            this.scaledBorder.xLabel = buffer.xLabel;
            this.scaledBorder.yLabel = buffer.yLabel;
            this.scaledBorder.setStandardPattern(false);
            this.setBorder(this.scaledBorder);
        }
        this.repaint();
    }

    public void toggleScientificY(boolean immediateRepaint) {
        this.scaledBorder.toggleDecPattern(false);
        if (immediateRepaint) {
            this.repaint();
        }
    }

    public void toggleLog(boolean log) {
        if (log != log) {
            this.toggleLog();
        }
    }

    public void updateLegend() {
        GraphPointSetLegend lb = new GraphPointSetLegend(this.pointSetContainer, this.isAppendIndexInLegend());
        this.setLegend(lb);
    }

    public String getInfoString(int j) {
        return this.getGraphPointSet(j).getInfoString();
    }

    public void setShowGraphToolTips(boolean doShowGraphToolTips) {
        this.doShowGraphToolTips = doShowGraphToolTips;
    }

    public boolean isShowGraphToolTips() {
        return this.doShowGraphToolTips;
    }

    public void setAppendIndexInLegend(boolean appendIndexInLegend) {
        this.appendIndexInLegend = appendIndexInLegend;
    }

    public boolean isAppendIndexInLegend() {
        return this.appendIndexInLegend;
    }
}

