/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui.plot;

import eva2.gui.plot.Plot;
import eva2.gui.plot.PlotInterface;
import java.io.Serializable;

public class Graph
implements Serializable {
    private PlotInterface plotter;
    private int graphLabel;
    private String infoString;

    public Graph(String info, PlotInterface plotter, int x) {
        this.infoString = info;
        this.plotter = plotter;
        this.graphLabel = x;
        if (plotter == null) {
            System.out.println("In constructor plotter == null");
        }
        plotter.setInfoString(this.graphLabel, info, 1.0f);
    }

    public String getInfo() {
        return this.infoString;
    }

    public void setInfoString(String info, float stroke) {
        this.plotter.setInfoString(this.graphLabel, info, stroke);
    }

    public int getGraphLabel() {
        return this.graphLabel;
    }

    public void setConnectedPoint(double x, double y) {
        this.plotter.setConnectedPoint(x, y, this.graphLabel);
    }

    public void clear() {
        this.plotter.clearGraph(this.graphLabel);
    }

    public void setUnconnectedPoint(double x, double y) {
        this.plotter.setUnconnectedPoint(x, y, this.graphLabel);
    }

    public int getPointCount() {
        return this.plotter.getPointCount(this.graphLabel);
    }

    public boolean addGraph(Graph x) {
        boolean useForce = false;
        if (this.getPointCount() != 0 && this.getPointCount() != x.getPointCount()) {
            useForce = true;
        }
        this.plotter.jump();
        this.plotter.addGraph(this.graphLabel, x.getGraphLabel(), useForce);
        return !useForce;
    }

    public void jump() {
        this.plotter.jump();
    }

    public void setColorByIndex(int j) {
        ((Plot)this.plotter).setColorByIndex(this.graphLabel, j);
    }
}

