/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui.plot;

import eva2.gui.plot.DPointSetMultiIcon;
import eva2.gui.plot.FunctionArea;
import eva2.tools.chart2d.DArea;
import eva2.tools.chart2d.DMeasures;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.DPointIcon;
import eva2.tools.chart2d.DPointSet;
import eva2.tools.math.Mathematics;
import java.awt.BasicStroke;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;

public class GraphPointSet {
    public static Color[] colorSequence = new Color[]{Color.black, Color.red, Color.blue, Color.pink, Color.green, Color.gray, Color.magenta, Color.cyan, Color.orange, new Color(148, 0, 211), new Color(72, 209, 204), new Color(128, 128, 0), new Color(34, 139, 34), new Color(100, 149, 237)};
    private int colorOffset = 0;
    private DArea area;
    private int cacheIndex = 0;
    private int cacheSize = 0;
    private double[] cachex;
    private double[] cachey;
    private Color color;
    private DPointSetMultiIcon connectedPointSet;
    private int graphLabel;
    private DPointIcon icon;
    private String infoString = "Incomplete_Run";
    private boolean isStatisticsGraph = false;
    private ArrayList<PointSet> pointSetContainer = new ArrayList();
    private float stroke = 1.0f;

    public GraphPointSet(int GraphLabel, DArea Area) {
        this.cachex = new double[this.cacheSize];
        this.cachey = new double[this.cacheSize];
        this.area = Area;
        this.graphLabel = GraphLabel;
        this.connectedPointSet = new DPointSetMultiIcon(100);
        this.connectedPointSet.setStroke(new BasicStroke(this.stroke));
        this.connectedPointSet.setConnected(true);
        this.setColor(this.indexToColor(GraphLabel));
        this.initGraph(Area);
    }

    private GraphPointSet(int size, int GraphLabel) {
        this.graphLabel = GraphLabel;
        this.cachex = new double[this.cacheSize];
        this.cachey = new double[this.cacheSize];
        this.connectedPointSet = new DPointSetMultiIcon(100);
        this.connectedPointSet.setStroke(new BasicStroke(this.stroke));
        this.connectedPointSet.setConnected(true);
        this.color = Color.black;
        this.color = this.indexToColor(GraphLabel);
        this.connectedPointSet.setColor(this.color);
    }

    public void addDPoint(double x, double y) {
        if (this.cacheIndex == this.cacheSize) {
            for (int i = 0; i < this.cacheSize; ++i) {
                this.connectedPointSet.addDPoint(this.cachex[i], this.cachey[i]);
            }
            this.connectedPointSet.addDPoint(x, y);
            this.cacheIndex = 0;
        } else {
            this.cachex[this.cacheIndex] = x;
            this.cachey[this.cacheIndex] = y;
            ++this.cacheIndex;
        }
    }

    public void addDPoint(DPoint p) {
        this.connectedPointSet.addDPoint(p);
    }

    public void addGraph(GraphPointSet set, DMeasures measures, boolean useForce) {
        if (set.connectedPointSet.getSize() != this.connectedPointSet.getSize() && this.connectedPointSet.getSize() != 0 && !useForce) {
            System.err.println("WARNING addGraph not possible, lost last graph");
            System.err.println(" connectedPointSet.getSize() " + this.connectedPointSet.getSize());
            return;
        }
        if (set.getPointSet().getSize() == 0) {
            System.err.println("Refusing to add empty graph...");
            return;
        }
        this.isStatisticsGraph = true;
        this.removeAllPoints();
        this.connectedPointSet.setColor(set.getColor());
        this.pointSetContainer.add(set.getPointSet());
        int[] index = new int[this.pointSetContainer.size()];
        int[] GraphSize = new int[this.pointSetContainer.size()];
        for (int i = 0; i < this.pointSetContainer.size(); ++i) {
            GraphSize[i] = this.pointSetContainer.get(i).getSize();
            if (GraphSize[i] > 0) continue;
            System.err.println("Warning: invalid graph size of " + GraphSize[i] + " at " + i + "!  (GraphPointSet.addGraph)");
        }
        if (Mathematics.sum(GraphSize) == 0) {
            System.err.println("Error: not adding empty graphs... (GraphPointSet.addGraph)");
            return;
        }
        boolean allSetsHaveMorePoints = true;
        double[] y = new double[this.pointSetContainer.size()];
        block1: while (allSetsHaveMorePoints) {
            double nextXValue = this.pointSetContainer.get(0).x[index[0]];
            for (int i = 1; i < this.pointSetContainer.size(); ++i) {
                if (!(nextXValue > this.pointSetContainer.get(i).x[index[i]])) continue;
                nextXValue = this.pointSetContainer.get(i).x[index[i]];
            }
            int numberofpoints = 0;
            for (int i = 0; i < this.pointSetContainer.size(); ++i) {
                if (nextXValue == this.pointSetContainer.get(i).x[index[i]]) {
                    y[i] = this.pointSetContainer.get(i).y[index[i]];
                    int n = i;
                    index[n] = index[n] + 1;
                    ++numberofpoints;
                    continue;
                }
                y[i] = 0.0;
            }
            double ymean = Mathematics.sum(y) / (double)numberofpoints;
            this.addDPoint(nextXValue, ymean);
            for (int i = 0; i < this.pointSetContainer.size(); ++i) {
                if (GraphSize[i] > index[i]) continue;
                allSetsHaveMorePoints = false;
                continue block1;
            }
        }
    }

    public Color getColor() {
        return this.connectedPointSet.getColor();
    }

    public DPointSet getConnectedPointSet() {
        return this.connectedPointSet.getDPointSet();
    }

    public int getGraphLabel() {
        return this.graphLabel;
    }

    public String getInfoString() {
        return this.infoString;
    }

    public DPoint getNearestDPoint(DPoint p) {
        return this.connectedPointSet.getNearestDPoint(p);
    }

    public int getPointCount() {
        return this.connectedPointSet.getSize();
    }

    public PointSet getPointSet() {
        return new PointSet(this.connectedPointSet.getDPointSet());
    }

    public DPointSetMultiIcon getReference2ConnectedPointSet() {
        return this.connectedPointSet;
    }

    public void incColor() {
        ++this.colorOffset;
        this.setColor(this.indexToColor(this.graphLabel + this.colorOffset));
    }

    private Color indexToColor(int index) {
        int k = index % colorSequence.length;
        return colorSequence[k];
    }

    public void initGraph(DArea Area) {
        this.area = Area;
        this.area.addDElement(this.connectedPointSet);
        ((FunctionArea)this.area).addGraphPointSet(this);
    }

    public boolean isStatisticsGraph() {
        return this.isStatisticsGraph;
    }

    public void jump() {
        this.connectedPointSet.jump();
    }

    public DPointSet printPoints() {
        for (int i = 0; i < this.connectedPointSet.getSize(); ++i) {
            DPoint p = this.connectedPointSet.getDPoint(i);
            double x = p.x;
            double y = p.y;
            System.out.println("point " + i + " x = " + x + "y = " + y);
        }
        return this.connectedPointSet.getDPointSet();
    }

    public void removeAllPoints() {
        this.connectedPointSet.removeAllPoints();
    }

    public void removePoint(DPoint x) {
        int i;
        System.out.println("removePoint " + x.x + " " + x.y);
        DPoint[] buf = new DPoint[this.connectedPointSet.getSize()];
        for (i = 0; i < this.connectedPointSet.getSize(); ++i) {
            buf[i] = this.connectedPointSet.getDPoint(i);
        }
        this.connectedPointSet.removeAllPoints();
        for (i = 0; i < buf.length; ++i) {
            if (buf[i].x == x.x && buf[i].y == x.y) {
                System.out.println("point found");
                continue;
            }
            this.connectedPointSet.addDPoint(buf[i]);
        }
    }

    public void setColor(Color c) {
        this.color = c;
        this.connectedPointSet.setColor(this.color);
    }

    public void setColorByIndex(int i) {
        this.setColor(this.indexToColor(i));
    }

    public void setConnectedMode(boolean p) {
        this.connectedPointSet.setConnected(p);
    }

    public void setIcon(DPointIcon p) {
        this.icon = p;
        this.connectedPointSet.setIcon(p);
    }

    public void setInfoString(String x, float stroke) {
        this.infoString = x;
        this.stroke = stroke;
    }

    public void setInfoString(String x) {
        this.infoString = x;
    }

    public DPoint getMedPoint() {
        if (this.connectedPointSet == null) {
            return null;
        }
        int medX = this.connectedPointSet.getSize() / 2;
        return this.connectedPointSet.getDPoint(medX);
    }

    class PointSet
    implements Serializable {
        private static final long serialVersionUID = -5863595580492128866L;
        private Color color;
        private double[] x;
        private double[] y;

        public PointSet(DPointSet pointset) {
            this.color = pointset.getColor();
            this.x = new double[pointset.getSize()];
            this.y = new double[pointset.getSize()];
            for (int i = 0; i < pointset.getSize(); ++i) {
                DPoint point = pointset.getDPoint(i);
                this.x[i] = point.x;
                this.y[i] = point.y;
            }
        }

        public DPointSet getDPointSet() {
            DPointSet ret = new DPointSet(100);
            ret.setColor(this.color);
            for (int i = 0; i < this.x.length; ++i) {
                ret.addDPoint(this.x[i], this.y[i]);
            }
            return ret;
        }

        public int getSize() {
            return this.x.length;
        }
    }
}

