/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui.plot;

import eva2.gui.plot.GraphPointSet;
import eva2.tools.Pair;
import eva2.tools.StringTools;
import eva2.tools.chart2d.SlimRect;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GraphPointSetLegend {
    SortedSet<Pair<String, Color>> legendEntries = new TreeSet<Pair<String, Color>>(comparator);
    private static final PairComp comparator = new PairComp();

    public GraphPointSetLegend(List<GraphPointSet> pointSetContainer, boolean appendIndex) {
        for (int i = 0; i < pointSetContainer.size(); ++i) {
            GraphPointSet pointset = pointSetContainer.get(i);
            if (pointset.getPointSet().getSize() <= 0) continue;
            String entryStr = appendIndex ? StringTools.expandPrefixZeros(i, pointSetContainer.size() - 1) + ": " + pointset.getInfoString() : pointset.getInfoString();
            this.legendEntries.add(new Pair<String, Color>(entryStr, pointset.getColor()));
        }
    }

    public GraphPointSetLegend(List<GraphPointSet> pointSetContainer) {
        this(pointSetContainer, false);
    }

    public void addToContainer(JComponent comp) {
        for (Pair pair : this.legendEntries) {
            JLabel label = new JLabel((String)pair.head);
            label.setForeground((Color)pair.tail);
            comp.add(label);
        }
    }

    public static JPanel makeLegendPanel(Color bgCol, ArrayList<GraphPointSet> pointSetContainer) {
        JPanel pan = new JPanel();
        pan.setBackground(bgCol);
        pan.setLayout(new BoxLayout(pan, 1));
        GraphPointSetLegend lBox = new GraphPointSetLegend(pointSetContainer);
        lBox.addToContainer(pan);
        return pan;
    }

    public static JFrame makeLegendFrame(Color bgCol, ArrayList<GraphPointSet> pointSetContainer) {
        JFrame frame = new JFrame("Legend");
        frame.add(GraphPointSetLegend.makeLegendPanel(bgCol, pointSetContainer));
        frame.pack();
        frame.setVisible(true);
        return frame;
    }

    public void paintIn(JComponent component) {
        Graphics g = component.getGraphics();
        FontMetrics fm = g.getFontMetrics();
        int yOffs = 5 + fm.getHeight();
        int xOffs = 0;
        Color origCol = g.getColor();
        for (Pair pair : this.legendEntries) {
            g.setColor((Color)pair.tail);
            Rectangle2D rect = fm.getStringBounds((String)pair.head, g);
            xOffs = (int)((double)component.getWidth() - rect.getWidth() - 5.0);
            g.drawString((String)pair.head, xOffs, yOffs);
            yOffs = (int)((double)yOffs + (5.0 + rect.getHeight()));
        }
        g.setColor(origCol);
    }

    public void paintIn(Graphics g, SlimRect rect) {
        this.paintIn(g, (int)rect.getX(), (int)rect.getY(), (int)rect.getX() + (int)rect.getWidth());
    }

    private void paintIn(Graphics g, int x, int y, int maxX) {
        FontMetrics fm = g.getFontMetrics();
        double fontHeightSum = 0.0;
        int padding = 5;
        double yOffs = padding + y + fm.getHeight();
        int minX = Integer.MAX_VALUE;
        Color origCol = g.getColor();
        for (Pair pair : this.legendEntries) {
            Rectangle2D stringBounds = fm.getStringBounds((String)pair.head, g);
            minX = Math.min(minX, (int)((double)maxX - stringBounds.getWidth() - 20.0));
            fontHeightSum += stringBounds.getHeight() + (double)padding;
        }
        int boxHeight = (int)(fontHeightSum + (double)padding);
        int n = maxX - minX + 20 - padding;
        g.setColor(Color.WHITE);
        g.fillRect(minX - 20, padding + y, n, boxHeight);
        g.setColor(Color.BLACK);
        g.drawRect(minX - 20, padding + y, n, boxHeight);
        for (Pair pair : this.legendEntries) {
            g.setColor((Color)pair.tail);
            Rectangle2D stringBounds = fm.getStringBounds((String)pair.head, g);
            g.drawString((String)pair.head, minX + 5, (int)yOffs);
            g.drawLine(minX - 15, (int)(yOffs - stringBounds.getHeight() / 2.0) + 1, minX, (int)(yOffs - stringBounds.getHeight() / 2.0) + 1);
            yOffs += (double)padding + stringBounds.getHeight();
        }
        g.setColor(origCol);
    }

    private static class PairComp
    implements Comparator<Pair<String, Color>> {
        private PairComp() {
        }

        @Override
        public int compare(Pair<String, Color> o1, Pair<String, Color> o2) {
            int comp = o1.car().compareTo(o2.car());
            return comp == 0 ? (comp = Integer.valueOf(o1.cdr().getRGB()).compareTo(o2.cdr().getRGB())) : comp;
        }
    }
}

