/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui.plot;

import eva2.gui.plot.Graph;
import eva2.gui.plot.Plot;
import eva2.gui.plot.PlotContainer;
import eva2.gui.plot.PlotInterface;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GraphWindow {
    private static final Logger LOGGER = Logger.getLogger(GraphWindow.class.getName());
    private static int graphCounter = -1;
    private static PlotContainer plotContainer;
    private PlotInterface plotter;
    private String name;

    public static GraphWindow getInstance(String graphWindowName, String strx, String stry) {
        if (plotContainer == null) {
            plotContainer = new PlotContainer();
        }
        GraphWindow ret = null;
        try {
            if (plotContainer.containsName(graphWindowName)) {
                ret = plotContainer.getPlot(graphWindowName);
            }
            if (ret == null || !ret.isValid()) {
                if (ret != null) {
                    plotContainer.remove(ret);
                }
                ret = new GraphWindow(graphWindowName, strx, stry);
                plotContainer.add(ret);
            }
        }
        catch (Exception ee) {
            System.out.println("GraphWindow ERROR : " + ee.getMessage());
            ee.printStackTrace();
        }
        return ret;
    }

    public boolean isValid() {
        return this.plotter != null && this.plotter.isValid();
    }

    public PlotInterface getPlotter() {
        return this.plotter;
    }

    private GraphWindow(String plotName, String strx, String stry) {
        this.name = plotName;
        this.plotter = new Plot(plotName, strx, stry, true);
    }

    public String getName() {
        return this.name;
    }

    public Graph getNewGraph(String infoString) {
        LOGGER.log(Level.FINEST, "Graph.getNewGraph No:{0} - {1} created.", new Object[]{++graphCounter, infoString});
        return new Graph(infoString, this.plotter, graphCounter);
    }
}

