/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui.plot;

import eva2.gui.JEFrame;
import eva2.gui.plot.FunctionArea;
import eva2.gui.plot.PlotInterface;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.population.Population;
import eva2.tools.BasicResourceLoader;
import eva2.tools.chart2d.DPointSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Formatter;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.metal.MetalIconFactory;

public class Plot
implements PlotInterface,
Serializable {
    private static final long serialVersionUID = -9027101244918249825L;
    private JFileChooser fileChooser;
    private JPanel buttonPanel;
    private String plotName;
    private String xAxisText;
    private String yAxisText;
    protected FunctionArea plotArea;
    protected JInternalFrame internalFrame;

    public Plot(String plotName, String xname, String yname, double[] x, double[] y) {
        this(plotName, xname, yname, true);
        DPointSet points = new DPointSet();
        for (int i = 0; i < x.length; ++i) {
            points.addDPoint(x[i], y[i]);
        }
        this.plotArea.addDElement(points);
    }

    public Plot(String PlotName, String xname, String yname) {
        this(PlotName, xname, yname, true);
    }

    public Plot(String plotName, String xname, String yname, boolean init) {
        this.xAxisText = xname;
        this.yAxisText = yname;
        this.plotName = plotName;
        if (init) {
            this.init();
        }
    }

    protected void installButtons(JPanel buttonPan) {
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(e -> this.clearAll());
        JButton loglinButton = new JButton("Log/Lin");
        loglinButton.setToolTipText("Toggle between a linear and a log scale on the y-axis.");
        loglinButton.addActionListener(e -> this.plotArea.toggleLog());
        JButton exportButton = new JButton("Export to TSV");
        exportButton.setToolTipText("Exports the graph data to a simple TSV file.");
        exportButton.addActionListener(e -> this.exportPlot());
        JButton dumpButton = new JButton("Dump");
        dumpButton.setToolTipText("Dump the graph data to standard output");
        dumpButton.addActionListener(e -> this.plotArea.exportToAscii());
        JButton saveImageButton = new JButton("Save as PNG...");
        saveImageButton.addActionListener(e -> {
            FunctionArea fArea = this.getFunctionArea();
            Object[] resolutions = new Object[]{new Dimension(1920, 1080), new Dimension(1024, 768)};
            Dimension outputDimension = (Dimension)JOptionPane.showInputDialog(fArea, "Select image resolution: ", "Image Resolution", -1, MetalIconFactory.getTreeComputerIcon(), resolutions, resolutions[0]);
            if (outputDimension == null) {
                return;
            }
            BufferedImage bImg = new BufferedImage((int)outputDimension.getWidth(), (int)outputDimension.getHeight(), 1);
            Graphics2D g = bImg.createGraphics();
            Dimension d = fArea.getSize();
            fArea.setSize(outputDimension);
            fArea.paintAll(g);
            fArea.setSize(d);
            JFileChooser fc = new JFileChooser();
            if (fc.showSaveDialog(this.internalFrame) != 0) {
                return;
            }
            try {
                File file = new File(fc.getSelectedFile().getAbsolutePath() + ".png");
                ImageIO.write((RenderedImage)bImg, "png", file);
            }
            catch (Exception eee) {
                System.err.println("Error on exporting PNG: " + eee.getMessage());
            }
        });
        buttonPan.add(clearButton);
        buttonPan.add(loglinButton);
        buttonPan.add(dumpButton);
        buttonPan.add(exportButton);
        buttonPan.add(saveImageButton);
    }

    @Override
    public void init() {
        this.internalFrame = new JEFrame("Plot: " + this.plotName);
        BasicResourceLoader loader = BasicResourceLoader.getInstance();
        byte[] bytes = loader.getBytesFromResourceLocation("images/icon.png", true);
        this.buttonPanel = new JPanel();
        this.plotArea = new FunctionArea(this.xAxisText, this.yAxisText);
        this.buttonPanel.setLayout(new FlowLayout(0, 10, 10));
        this.installButtons(this.buttonPanel);
        this.internalFrame.add((Component)this.buttonPanel, "Last");
        this.internalFrame.add((Component)this.plotArea, "Center");
        this.internalFrame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                super.internalFrameClosing(e);
                Plot.this.plotArea.clearAll();
                Plot.this.plotArea = null;
                Plot.this.internalFrame.dispose();
            }
        });
        this.internalFrame.pack();
        this.internalFrame.setVisible(true);
    }

    public void setAppendIndexInLegend(boolean appendIndexInLegend) {
        this.plotArea.setAppendIndexInLegend(appendIndexInLegend);
    }

    public boolean isAppendIndexInLegend() {
        return this.plotArea.isAppendIndexInLegend();
    }

    public boolean isShowGraphToolTips() {
        return this.plotArea.isShowGraphToolTips();
    }

    public void setShowGraphToolTips(boolean doShowGraphToolTips) {
        this.plotArea.setShowGraphToolTips(doShowGraphToolTips);
    }

    public void drawPopulation(String prefix, Population pop) {
        for (int i = 0; i < pop.size(); ++i) {
            this.drawIndividual(0, 2, prefix, pop.getEAIndividual(i));
        }
    }

    public void drawIndividual(int iconType, int graphID, String prefix, AbstractEAIndividual indy) {
        StringBuffer sb = new StringBuffer();
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format("%s %.3e", prefix, indy.getFitness(0));
        this.getFunctionArea().drawIcon(iconType, sb.toString(), indy.getDoublePosition(), graphID);
    }

    public void setPreferredSize(Dimension prefSize) {
        if (this.internalFrame != null) {
            this.internalFrame.setPreferredSize(prefSize);
            this.internalFrame.pack();
        }
    }

    @Override
    public boolean isValid() {
        return this.internalFrame != null && this.plotArea != null;
    }

    @Override
    public void setConnectedPoint(double x, double y, int func) {
        this.plotArea.setConnectedPoint(x, y, func);
    }

    @Override
    public int getPointCount(int graphLabel) {
        return this.plotArea.getPointCount(graphLabel);
    }

    @Override
    public void addGraph(int g1, int g2, boolean forceAdd) {
        this.plotArea.addGraph(g1, g2, forceAdd);
    }

    @Override
    public void setUnconnectedPoint(double x, double y, int GraphLabel) {
        this.plotArea.setUnconnectedPoint(x, y, GraphLabel);
    }

    @Override
    public void clearAll() {
        this.plotArea.clearAll();
        this.plotArea.removeAllDElements();
        this.plotArea.clearLegend();
        this.internalFrame.repaint();
    }

    @Override
    public void clearGraph(int graphNumber) {
        this.plotArea.clearGraph(graphNumber);
    }

    @Override
    public void setInfoString(int graphLabel, String info, float stroke) {
        this.plotArea.setInfoString(graphLabel, info, stroke);
    }

    @Override
    public void jump() {
        this.plotArea.jump();
    }

    protected Object openObject() {
        int returnVal;
        if (this.fileChooser == null) {
            this.createFileChooser();
        }
        if ((returnVal = this.fileChooser.showOpenDialog(this.internalFrame)) == 0) {
            File selected = this.fileChooser.getSelectedFile();
            try {
                ObjectInputStream oi = new ObjectInputStream(new BufferedInputStream(new FileInputStream(selected)));
                Object obj = oi.readObject();
                oi.close();
                Class<?> ClassType = Class.forName("FunctionArea");
                if (!ClassType.isAssignableFrom(obj.getClass())) {
                    throw new Exception("Object not of type: " + ClassType.getName());
                }
                return obj;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.internalFrame, "Couldn't read object: " + selected.getName() + "\n" + ex.getMessage(), "Open object file", 0);
            }
        }
        return null;
    }

    protected void dumpPlot() {
        this.plotArea.exportToAscii();
    }

    protected void exportPlot() {
        int returnVal;
        if (this.fileChooser == null) {
            this.createFileChooser();
        }
        if ((returnVal = this.fileChooser.showSaveDialog(this.internalFrame)) == 0) {
            File sFile = this.fileChooser.getSelectedFile();
            if (sFile.exists() && (returnVal = JOptionPane.showConfirmDialog(this.internalFrame, "The file " + sFile.getName() + " already exists. Overwrite?")) != 0) {
                return;
            }
            if (!this.plotArea.exportToAscii(sFile)) {
                JOptionPane.showMessageDialog(this.internalFrame, "Couldn't write to file: " + sFile.getName(), "Export error", 0);
            }
        }
    }

    protected void saveObject(Object object) {
        int returnVal;
        if (this.fileChooser == null) {
            this.createFileChooser();
        }
        if ((returnVal = this.fileChooser.showSaveDialog(this.internalFrame)) == 0) {
            File sFile = this.fileChooser.getSelectedFile();
            try {
                ObjectOutputStream oo = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(sFile)));
                oo.writeObject(object);
                oo.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.internalFrame, "Couldn't write to file: " + sFile.getName() + "\n" + ex.getMessage(), "Save object", 0);
            }
        }
    }

    protected void createFileChooser() {
        this.fileChooser = new JFileChooser(new File("/resources"));
        this.fileChooser.setFileSelectionMode(0);
    }

    @Override
    public String getName() {
        return this.plotName;
    }

    public FunctionArea getFunctionArea() {
        return this.plotArea;
    }

    public void dispose() {
        this.internalFrame.dispose();
        this.internalFrame = null;
    }

    public void setCornerPoints(double[][] range, int graphLabel) {
        this.setUnconnectedPoint(range[0][0], range[1][0], graphLabel);
        this.setUnconnectedPoint(range[0][1], range[1][1], graphLabel);
    }

    public void setColorByIndex(int graphLabel, int index) {
        this.getFunctionArea().setColorByIndex(graphLabel, index);
    }

    public void recolorAllGraphsByIndex() {
        this.getFunctionArea().recolorAllGraphsByIndex();
    }
}

