/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui.plot;

import eva2.gui.plot.Plot;
import eva2.problems.Interface2DBorderProblem;
import eva2.problems.InterfaceFirstOrderDerivableProblem;
import eva2.tools.chart2d.DRectangle;
import eva2.tools.diagram.ColorBarCalculator;
import eva2.tools.math.Mathematics;
import java.awt.Color;
import javax.swing.JPanel;

public class TopoPlot
extends Plot {
    Interface2DBorderProblem prob = null;
    double[][] range = null;
    boolean withGrads = false;
    private int gridx = 50;
    private int gridy = 50;
    int colorScale = 0;

    public TopoPlot(String PlotName, String xname, String yname) {
        super(PlotName, xname, yname, true);
    }

    public TopoPlot(String PlotName, String xname, String yname, double[] a, double[] b) {
        super(PlotName, xname, yname, a, b);
    }

    public void setParams(int gridX, int gridY, int color_scale) {
        if (gridX > this.internalFrame.getWidth()) {
            gridX = this.internalFrame.getWidth();
        }
        if (gridY > this.internalFrame.getHeight()) {
            gridY = this.internalFrame.getHeight();
        }
        this.gridx = gridX;
        this.gridy = gridY;
        this.colorScale = color_scale;
    }

    @Override
    protected void installButtons(JPanel buttonPan) {
        super.installButtons(buttonPan);
    }

    public void setParams(int gridX, int gridY) {
        this.setParams(gridX, gridY, this.colorScale);
    }

    public void setTopology(Interface2DBorderProblem problem) {
        this.setTopology(problem, problem.get2DBorder(), false);
    }

    public void setTopology(Interface2DBorderProblem problem, double[][] border, boolean withGradientsIfAvailable) {
        int x;
        this.prob = problem;
        this.range = border;
        this.withGrads = withGradientsIfAvailable;
        double[] sizeXY = Mathematics.getAbsRange(border);
        double deltaX = sizeXY[0] / (double)this.gridx;
        double deltaY = sizeXY[1] / (double)this.gridy;
        double maxDeriv = 0.0;
        double[] pos = new double[2];
        double fitRange = 0.0;
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        for (int x2 = 0; x2 < this.gridx; ++x2) {
            for (int y = 0; y < this.gridy; ++y) {
                pos[0] = border[0][0] + (double)x2 * deltaX;
                pos[1] = border[1][0] + (double)y * deltaY;
                double tmp = (float)problem.functionValue(pos);
                if (tmp < min) {
                    min = tmp;
                }
                if (tmp > max) {
                    max = tmp;
                }
                if (!withGradientsIfAvailable || !(problem instanceof InterfaceFirstOrderDerivableProblem)) continue;
                double[] deriv = ((InterfaceFirstOrderDerivableProblem)((Object)problem)).getFirstOrderGradients(problem.project2DPoint(pos));
                for (int i = 0; i < 2; ++i) {
                    maxDeriv = Math.max(maxDeriv, Math.abs(deriv[i]));
                }
            }
        }
        fitRange = Math.abs(max - min);
        ColorBarCalculator colorBar = new ColorBarCalculator(this.colorScale);
        this.internalFrame.setVisible(false);
        for (x = 0; x < this.gridx; ++x) {
            for (int y = 0; y < this.gridy; ++y) {
                pos[0] = border[0][0] + (double)x * deltaX;
                pos[1] = border[1][0] + (double)y * deltaY;
                DRectangle rect = new DRectangle(pos[0] - deltaX / 2.0, pos[1] - deltaY / 2.0, deltaX, deltaY);
                Color color = new Color(colorBar.getRGB((float)((problem.functionValue(pos) - min) / fitRange)));
                rect.setColor(color);
                rect.setFillColor(color);
                this.plotArea.addDElement(rect);
            }
        }
        if (withGradientsIfAvailable && problem instanceof InterfaceFirstOrderDerivableProblem) {
            for (x = 0; x < this.gridx; ++x) {
                for (int y = 0; y < this.gridy; ++y) {
                    pos[0] = border[0][0] + (double)x * deltaX;
                    pos[1] = border[1][0] + (double)y * deltaY;
                    double[] derivPos = ((InterfaceFirstOrderDerivableProblem)((Object)problem)).getFirstOrderGradients(problem.project2DPoint(pos));
                    Mathematics.svDiv(1.1 * (2.0 * maxDeriv / Math.max(deltaX, deltaY)), derivPos, derivPos);
                    Mathematics.vvAdd(pos, derivPos, derivPos);
                    this.getFunctionArea().drawLine(pos, derivPos);
                    this.getFunctionArea().drawIcon(1, "", derivPos, 0);
                }
            }
        }
        this.internalFrame.setVisible(true);
    }
}

