/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization;

import eva2.gui.BeanInspector;
import eva2.optimization.InterfaceNotifyOnInformers;
import eva2.optimization.InterfaceOptimizationParameters;
import eva2.optimization.operator.postprocess.InterfacePostProcessParams;
import eva2.optimization.operator.postprocess.PostProcessParams;
import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.InterfaceAdditionalPopulationInformer;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Parameter;
import eva2.yaml.BeanSerializer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractOptimizationParameters
implements InterfaceOptimizationParameters,
Serializable {
    protected static final Logger LOGGER = Logger.getLogger(AbstractOptimizationParameters.class.getName());
    protected long randomSeed = 0L;
    protected InterfaceOptimizer optimizer;
    protected InterfaceOptimizationProblem problem;
    protected InterfaceTerminator terminator;
    protected InterfacePostProcessParams postProcessParams = new PostProcessParams(false);
    protected transient InterfacePopulationChangedEventListener populationChangedEventListener;
    private transient List<InterfaceNotifyOnInformers> toInformAboutInformers = null;

    protected AbstractOptimizationParameters() {
    }

    protected AbstractOptimizationParameters(AbstractOptimizationParameters optimizationParameters) {
        this();
        this.optimizer = optimizationParameters.optimizer;
        this.problem = optimizationParameters.problem;
        this.terminator = optimizationParameters.terminator;
        this.optimizer.setProblem(this.problem);
        this.randomSeed = optimizationParameters.randomSeed;
        this.postProcessParams = optimizationParameters.postProcessParams;
    }

    public AbstractOptimizationParameters(InterfaceOptimizer opt, InterfaceOptimizationProblem prob, InterfaceTerminator term) {
        this();
        this.optimizer = opt;
        this.problem = prob;
        this.terminator = term;
        this.postProcessParams = new PostProcessParams(false);
        opt.setProblem(prob);
    }

    public void setSameParams(AbstractOptimizationParameters parameters) {
        this.setOptimizer(parameters.optimizer);
        this.setProblem(parameters.problem);
        this.setTerminator(parameters.terminator);
        this.optimizer.setProblem(this.problem);
        this.setRandomSeed(parameters.randomSeed);
        this.setPostProcessParams(parameters.postProcessParams);
    }

    public void addPopulationChangedEventListener(InterfacePopulationChangedEventListener ea) {
        this.populationChangedEventListener = ea;
        if (this.optimizer != null) {
            this.optimizer.addPopulationChangedEventListener(this.populationChangedEventListener);
        }
    }

    public boolean removePopulationChangedEventListener(InterfacePopulationChangedEventListener ea) {
        if (this.populationChangedEventListener == ea) {
            this.populationChangedEventListener = null;
            if (this.optimizer != null) {
                this.optimizer.removePopulationChangedEventListener(ea);
            }
            return true;
        }
        return false;
    }

    public void saveInstance(String fileName) {
        try {
            FileOutputStream fileStream = new FileOutputStream(fileName);
            String yaml = BeanSerializer.serializeObject(this);
            fileStream.write(yaml.getBytes());
            fileStream.close();
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Could not store instance object.", ex);
        }
    }

    @Override
    public void saveInstance() {
        String fileName = this.getClass().getSimpleName() + ".yml";
        this.saveInstance(fileName);
    }

    public String toString() {
        StringBuilder sBuilder = new StringBuilder(this.getName());
        sBuilder.append("\n");
        sBuilder.append("seed=");
        sBuilder.append(this.randomSeed);
        sBuilder.append("\nProblem: ");
        sBuilder.append(BeanInspector.toString(this.problem));
        sBuilder.append("\nOptimizer: ");
        sBuilder.append(BeanInspector.toString(this.optimizer));
        sBuilder.append("\nTerminator: ");
        sBuilder.append(BeanInspector.toString(this.terminator));
        sBuilder.append("\n");
        return sBuilder.toString();
    }

    @Override
    public void addInformableInstance(InterfaceNotifyOnInformers o) {
        if (this.toInformAboutInformers == null) {
            this.toInformAboutInformers = new LinkedList<InterfaceNotifyOnInformers>();
        }
        if (!this.toInformAboutInformers.contains(o)) {
            this.toInformAboutInformers.add(o);
        }
        o.setInformers(this.getInformerList());
    }

    @Override
    public boolean removeInformableInstance(InterfaceNotifyOnInformers o) {
        if (this.toInformAboutInformers == null) {
            return false;
        }
        return this.toInformAboutInformers.remove(o);
    }

    private void fireNotifyOnInformers() {
        if (this.toInformAboutInformers != null) {
            for (InterfaceNotifyOnInformers listener : this.toInformAboutInformers) {
                listener.setInformers(this.getInformerList());
            }
        }
    }

    @Override
    @Parameter(description="The optimization strategy to use.")
    public void setOptimizer(InterfaceOptimizer optimizer) {
        this.optimizer = optimizer;
        this.optimizer.setProblem(this.problem);
        if (this.populationChangedEventListener != null) {
            this.optimizer.addPopulationChangedEventListener(this.populationChangedEventListener);
        }
        this.fireNotifyOnInformers();
    }

    private List<InterfaceAdditionalPopulationInformer> getInformerList() {
        LinkedList<InterfaceAdditionalPopulationInformer> ret = new LinkedList<InterfaceAdditionalPopulationInformer>();
        if (this.problem != null) {
            ret.add(this.problem);
        }
        if (this.optimizer instanceof InterfaceAdditionalPopulationInformer) {
            ret.add((InterfaceAdditionalPopulationInformer)((Object)this.optimizer));
        }
        return ret;
    }

    @Override
    public InterfaceOptimizer getOptimizer() {
        return this.optimizer;
    }

    @Override
    public String getName() {
        return "Optimization parameters";
    }

    @Override
    @Parameter(description="Choose the problem that is to optimize and the EA individual parameters.")
    public void setProblem(InterfaceOptimizationProblem problem) {
        this.problem = problem;
        this.optimizer.setProblem(this.problem);
        this.fireNotifyOnInformers();
    }

    @Override
    public InterfaceOptimizationProblem getProblem() {
        return this.problem;
    }

    @Override
    @Parameter(name="seed", description="Random number seed, set to zero to use current system time.")
    public void setRandomSeed(long x) {
        this.randomSeed = x;
    }

    @Override
    public long getRandomSeed() {
        return this.randomSeed;
    }

    @Override
    @Parameter(description="The termination criterion.")
    public void setTerminator(InterfaceTerminator term) {
        this.terminator = term;
    }

    @Override
    public InterfaceTerminator getTerminator() {
        return this.terminator;
    }

    @Override
    public InterfacePostProcessParams getPostProcessParams() {
        return this.postProcessParams;
    }

    @Override
    @Parameter(description="Parameters for the post processing step.")
    public void setPostProcessParams(InterfacePostProcessParams ppp) {
        this.postProcessParams = ppp;
    }

    @Override
    public void setDoPostProcessing(boolean doPP) {
        this.postProcessParams.setDoPostProcessing(doPP);
    }
}

