/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization;

import eva2.optimization.AbstractOptimizationParameters;
import eva2.optimization.InterfaceOptimizationParameters;
import eva2.optimization.operator.terminators.EvaluationTerminator;
import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.strategies.DifferentialEvolution;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.F1Problem;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import eva2.yaml.OptimizationConstructor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Level;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;

@Description(value="Select the optimization parameters.")
public class OptimizationParameters
extends AbstractOptimizationParameters
implements InterfaceOptimizationParameters,
Serializable {
    public static OptimizationParameters getInstance() {
        return OptimizationParameters.getInstance("OptimizationParameters.yml", true);
    }

    public static OptimizationParameters getInstance(String yamlFile, boolean casually) {
        OptimizationParameters instance = null;
        try {
            FileInputStream fileStream = new FileInputStream(yamlFile);
            instance = (OptimizationParameters)new Yaml((BaseConstructor)new OptimizationConstructor()).load((InputStream)fileStream);
        }
        catch (Exception ex) {
            System.out.println(ex.getStackTrace() + "\n" + ex.getMessage());
            LOGGER.log(Level.INFO, "Could not load OptimizationParameters.yml.", ex);
        }
        if (instance == null) {
            instance = new OptimizationParameters();
        }
        return instance;
    }

    public OptimizationParameters() {
        super(new DifferentialEvolution(), new F1Problem(), new EvaluationTerminator(5000));
    }

    public OptimizationParameters(InterfaceOptimizer opt, InterfaceOptimizationProblem prob, InterfaceTerminator term) {
        super(opt, prob, term);
    }

    private OptimizationParameters(OptimizationParameters parameters) {
        super(parameters);
    }

    @Override
    public String getName() {
        return "Optimization parameters";
    }

    public Object clone() {
        return new OptimizationParameters(this);
    }
}

