/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization;

import eva2.gui.BeanInspector;
import eva2.optimization.InterfaceNotifyOnInformers;
import eva2.optimization.InterfaceOptimizationParameters;
import eva2.optimization.InterfaceProcessor;
import eva2.optimization.OptimizationStateListener;
import eva2.optimization.operator.paramcontrol.ConstantParameters;
import eva2.optimization.operator.paramcontrol.InterfaceParameterControl;
import eva2.optimization.operator.postprocess.PostProcess;
import eva2.optimization.operator.postprocess.PostProcessParams;
import eva2.optimization.operator.terminators.EvaluationTerminator;
import eva2.optimization.operator.terminators.GenerationTerminator;
import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.population.Population;
import eva2.optimization.statistics.InterfaceStatistics;
import eva2.optimization.statistics.InterfaceTextListener;
import eva2.optimization.statistics.StatisticsWithGUI;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractOptimizationProblem;
import eva2.problems.InterfaceAdditionalPopulationInformer;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.EVAERROR;
import eva2.tools.StringTools;
import eva2.tools.math.RNG;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class Processor
extends Thread
implements InterfaceProcessor,
InterfacePopulationChangedEventListener {
    private static final Logger LOGGER = Logger.getLogger(Processor.class.getName());
    private volatile boolean isOptimizationRunning;
    private InterfaceStatistics statistics;
    private InterfaceOptimizationParameters optimizationParameters;
    private boolean createInitialPopulations = true;
    private boolean saveParams = true;
    private OptimizationStateListener optimizationStateListener;
    private boolean wasRestarted = false;
    private int runCounter = 0;
    private Population resultPopulation = null;
    private boolean userAborted = false;

    @Override
    public void addListener(OptimizationStateListener module) {
        LOGGER.log(Level.FINEST, "Processor: setting module as listener: " + (module == null ? "null" : module.toString()));
        this.optimizationStateListener = module;
    }

    public Processor(InterfaceStatistics statistics, InterfaceOptimizationParameters optimizationParameters) {
        this.optimizationParameters = optimizationParameters;
        this.statistics = statistics;
        if (statistics != null && optimizationParameters != null && statistics.getStatisticsParameters() instanceof InterfaceNotifyOnInformers) {
            optimizationParameters.addInformableInstance((InterfaceNotifyOnInformers)((Object)statistics.getStatisticsParameters()));
        }
    }

    public boolean isOptimizationRunning() {
        return this.isOptimizationRunning;
    }

    protected void setOptimizationRunning(boolean bRun) {
        this.isOptimizationRunning = bRun;
    }

    public void setSaveParams(boolean doSave) {
        this.saveParams = doSave;
    }

    @Override
    public void startOptimization() {
        this.createInitialPopulations = true;
        if (this.isOptimizationRunning()) {
            LOGGER.log(Level.WARNING, "Processor is already running.");
            return;
        }
        this.resultPopulation = null;
        this.userAborted = false;
        this.wasRestarted = false;
        this.setOptimizationRunning(true);
    }

    public boolean wasAborted() {
        return this.userAborted;
    }

    @Override
    public void restartOptimization() {
        this.createInitialPopulations = false;
        if (this.isOptimizationRunning()) {
            LOGGER.log(Level.WARNING, "Processor is already running.");
            return;
        }
        this.userAborted = false;
        this.wasRestarted = true;
        this.setOptimizationRunning(true);
    }

    @Override
    public void stopOptimization() {
        this.setOptimizationRunning(false);
    }

    @Override
    public void run() {
        this.setPriority(1);
        while (true) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                System.err.println("There was an error in sleep Processor.run()" + e);
            }
            this.runOptimizationOnce();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Population runOptimizationOnce() {
        try {
            EVAERROR.clearMsgCache();
            this.setName(this.getInfoString());
            if (this.isOptimizationRunning() && this.saveParams) {
                try {
                    this.optimizationParameters.saveInstance();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Could not save optimization instance!", e);
                }
            }
            while (this.isOptimizationRunning()) {
                this.setPriority(3);
                this.resultPopulation = this.optimize();
                this.setPriority(1);
            }
        }
        catch (Exception e) {
            String errMsg = e.toString();
            if (errMsg.length() == 0) {
                errMsg = "check console output for error messages.";
            }
            errMsg = "Exception in Processor: " + errMsg;
            LOGGER.log(Level.SEVERE, errMsg, e);
            e.printStackTrace();
            try {
                JOptionPane.showMessageDialog(null, StringTools.wrapLine(errMsg, 60, 0.2), "Error in Optimization", 0);
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
            this.setOptimizationRunning(false);
            if (this.optimizationStateListener != null) {
                this.optimizationStateListener.performedStop();
                this.optimizationStateListener.updateProgress(0, errMsg);
            }
        }
        finally {
            this.setName("Optimization Processor");
        }
        return this.resultPopulation;
    }

    protected Population optimize() {
        Population resultPop = null;
        if (!this.isOptimizationRunning()) {
            LOGGER.warning("Was startOptimization already called?");
            this.setOptimizationRunning(true);
        }
        RNG.setRandomSeed(this.optimizationParameters.getRandomSeed());
        if (this.optimizationStateListener != null) {
            if (this.wasRestarted) {
                this.optimizationStateListener.performedRestart(this.getInfoString());
            } else {
                this.optimizationStateListener.performedStart(this.getInfoString());
            }
        }
        this.runCounter = 0;
        InterfaceTerminator terminator = this.optimizationParameters.getTerminator();
        InterfaceOptimizer optimizer = this.optimizationParameters.getOptimizer();
        InterfaceOptimizationProblem problem = this.optimizationParameters.getProblem();
        optimizer.addPopulationChangedEventListener(this);
        while (this.isOptimizationRunning() && this.runCounter < this.statistics.getStatisticsParameters().getMultiRuns()) {
            LOGGER.info(String.format("Starting Optimization %d/%d", this.runCounter + 1, this.statistics.getStatisticsParameters().getMultiRuns()));
            this.statistics.startOptimizationPerformed(this.getInfoString(), this.runCounter, this.optimizationParameters, this.getInformerList());
            problem.initializeProblem();
            optimizer.setProblem(problem);
            terminator.initialize(problem);
            this.maybeInitParamCtrl(this.optimizationParameters);
            if (this.createInitialPopulations) {
                optimizer.initialize();
            }
            if (this.optimizationStateListener != null) {
                this.optimizationStateListener.updateProgress(this.getStatusPercent(optimizer.getPopulation(), this.runCounter, this.statistics.getStatisticsParameters().getMultiRuns()), null);
            }
            do {
                this.maybeUpdateParamCtrl(this.optimizationParameters);
                optimizer.optimize();
            } while (this.isOptimizationRunning() && !terminator.isTerminated(optimizer.getAllSolutions()));
            ++this.runCounter;
            this.maybeFinishParamCtrl(this.optimizationParameters);
            this.userAborted = !this.isOptimizationRunning();
            this.statistics.stopOptimizationPerformed(!this.userAborted, terminator.lastTerminationMessage());
            if (!this.userAborted) {
                resultPop = this.performPostProcessing();
                if (resultPop == null) {
                    resultPop = optimizer.getAllSolutions().getSolutions();
                }
            } else {
                resultPop = optimizer.getAllSolutions().getSolutions();
            }
            this.statistics.postProcessingPerformed(resultPop);
        }
        this.setOptimizationRunning(false);
        if (this.optimizationStateListener != null) {
            this.optimizationStateListener.performedStop();
        }
        if (this.optimizationStateListener != null) {
            this.optimizationStateListener.updateProgress(0, null);
        }
        optimizer.removePopulationChangedEventListener(this);
        return resultPop;
    }

    private void iterateParamCtrl(Object instance, String methodName, Object[] args) {
        Object paramCtrlReturn = null;
        paramCtrlReturn = BeanInspector.callIfAvailable(instance, "getParamControl", null);
        if (null != paramCtrlReturn) {
            if (paramCtrlReturn instanceof Object[]) {
                Object[] controllersOrSubControllables;
                for (Object controllerOrSubControllable : controllersOrSubControllables = (Object[])paramCtrlReturn) {
                    if (controllerOrSubControllable instanceof InterfaceParameterControl) {
                        args[0] = instance;
                        if (controllerOrSubControllable instanceof ConstantParameters) continue;
                        BeanInspector.callIfAvailable(controllerOrSubControllable, methodName, args);
                        continue;
                    }
                    args[0] = controllerOrSubControllable;
                    this.iterateParamCtrl(controllerOrSubControllable, methodName, args);
                }
            } else if (paramCtrlReturn instanceof InterfaceParameterControl && !(paramCtrlReturn instanceof ConstantParameters)) {
                BeanInspector.callIfAvailable(paramCtrlReturn, methodName, args);
            }
        }
    }

    private void maybeInitParamCtrl(InterfaceOptimizationParameters goParams) {
        this.iterateParamCtrl(goParams.getOptimizer(), "initialize", new Object[]{goParams.getOptimizer(), goParams.getOptimizer().getPopulation()});
        this.iterateParamCtrl(goParams.getProblem(), "initialize", new Object[]{goParams.getProblem(), goParams.getOptimizer().getPopulation()});
    }

    private void maybeFinishParamCtrl(InterfaceOptimizationParameters goParams) {
        this.iterateParamCtrl(goParams.getOptimizer(), "finish", new Object[]{goParams.getOptimizer(), goParams.getOptimizer().getPopulation()});
        this.iterateParamCtrl(goParams.getProblem(), "finish", new Object[]{goParams.getProblem(), goParams.getOptimizer().getPopulation()});
    }

    private void maybeUpdateParamCtrl(InterfaceOptimizationParameters goParams) {
        InterfaceTerminator terminator = goParams.getTerminator();
        InterfaceOptimizer optimizer = goParams.getOptimizer();
        Object[] args = terminator instanceof GenerationTerminator ? new Object[]{optimizer, optimizer.getPopulation(), optimizer.getPopulation().getGeneration(), ((GenerationTerminator)terminator).getGenerations()} : (terminator instanceof EvaluationTerminator ? new Object[]{optimizer, optimizer.getPopulation(), optimizer.getPopulation().getFunctionCalls(), ((EvaluationTerminator)terminator).getFitnessCalls()} : new Object[]{optimizer});
        this.iterateParamCtrl(optimizer, "updateParameters", args);
        args[0] = goParams.getProblem();
        this.iterateParamCtrl(goParams.getProblem(), "updateParameters", args);
    }

    private int getStatusPercent(Population pop, int currentRun, int multiRuns) {
        int curProgress;
        double percentPerRun = 100.0 / (double)multiRuns;
        if (this.optimizationParameters.getTerminator() instanceof EvaluationTerminator) {
            double curRunPerf = (double)pop.getFunctionCalls() * percentPerRun / (double)((EvaluationTerminator)this.optimizationParameters.getTerminator()).getFitnessCalls();
            curProgress = (int)((double)currentRun * percentPerRun + curRunPerf);
        } else if (this.optimizationParameters.getTerminator() instanceof GenerationTerminator) {
            double curRunPerf = (double)pop.getGeneration() * percentPerRun / (double)((GenerationTerminator)this.optimizationParameters.getTerminator()).getGenerations();
            curProgress = (int)((double)currentRun * percentPerRun + curRunPerf);
        } else {
            curProgress = (int)((double)currentRun * percentPerRun);
        }
        return curProgress;
    }

    @Override
    public void registerPopulationStateChanged(Object source, String name) {
        if (name.equals("NextGenerationPerformed")) {
            this.statistics.createNextGenerationPerformed(this.optimizationParameters.getOptimizer().getPopulation(), this.optimizationParameters.getOptimizer(), this.getInformerList());
            if (this.optimizationStateListener != null) {
                this.optimizationStateListener.updateProgress(this.getStatusPercent(this.optimizationParameters.getOptimizer().getPopulation(), this.runCounter, this.statistics.getStatisticsParameters().getMultiRuns()), null);
            }
        }
    }

    protected List<InterfaceAdditionalPopulationInformer> getInformerList() {
        ArrayList<InterfaceAdditionalPopulationInformer> informerList = new ArrayList<InterfaceAdditionalPopulationInformer>(2);
        informerList.add(this.optimizationParameters.getProblem());
        if (this.optimizationParameters.getOptimizer() instanceof InterfaceAdditionalPopulationInformer) {
            informerList.add((InterfaceAdditionalPopulationInformer)((Object)this.optimizationParameters.getOptimizer()));
        }
        return informerList;
    }

    @Override
    public String getInfoString() {
        InterfaceOptimizationProblem problem = this.optimizationParameters.getProblem();
        return problem.getName() + "{" + problem.getProblemDimension() + "}+" + this.optimizationParameters.getOptimizer().getName();
    }

    public InterfaceStatistics getStatistics() {
        return this.statistics;
    }

    public InterfaceOptimizationParameters getOptimizationParameters() {
        return this.optimizationParameters;
    }

    public void setOptimizationParameters(InterfaceOptimizationParameters params) {
        if (params != null) {
            this.optimizationParameters = params;
        } else {
            System.err.println("Setting parameters failed (parameters were null) (Processor.setOptimizationParameters)");
        }
    }

    public Population getResultPopulation() {
        return this.resultPopulation;
    }

    public Population performPostProcessing() {
        PostProcessParams ppp = (PostProcessParams)this.optimizationParameters.getPostProcessParams();
        if (ppp.isDoPostProcessing()) {
            return this.performPostProcessing(ppp, (InterfaceTextListener)((Object)this.statistics));
        }
        return null;
    }

    public Population performPostProcessing(PostProcessParams ppp, InterfaceTextListener listener) {
        if (ppp.isDoPostProcessing()) {
            Population resultPop;
            if (listener != null) {
                listener.println("Post processing params: " + BeanInspector.toString(ppp));
                if (this.statistics instanceof StatisticsWithGUI) {
                    ((StatisticsWithGUI)this.statistics).maybeShowProxyPrinter();
                }
            }
            if ((resultPop = (Population)this.optimizationParameters.getOptimizer().getAllSolutions().getSolutions().clone()).getFunctionCalls() != this.optimizationParameters.getOptimizer().getPopulation().getFunctionCalls()) {
                resultPop.setFunctionCalls(this.optimizationParameters.getOptimizer().getPopulation().getFunctionCalls());
            }
            PostProcess.checkAccuracy((AbstractOptimizationProblem)this.optimizationParameters.getProblem(), resultPop, ppp.getAccuracies(), ppp.getAccAssumeConv(), -1.0, ppp.getAccMaxEval(), null, true, listener);
            this.resultPopulation = resultPop = PostProcess.postProcess(ppp, resultPop, (AbstractOptimizationProblem)this.optimizationParameters.getProblem(), listener);
            return resultPop;
        }
        return null;
    }
}

