/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals;

import eva2.gui.BeanInspector;
import eva2.optimization.individuals.IndividualInterface;
import eva2.optimization.individuals.InterfaceDataTypeBinary;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.individuals.InterfaceDataTypeInteger;
import eva2.optimization.individuals.InterfaceDataTypePermutation;
import eva2.optimization.individuals.InterfaceDataTypeProgram;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.individuals.codings.gp.InterfaceProgram;
import eva2.optimization.operator.constraint.InterfaceConstraint;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.operator.crossover.NoCrossover;
import eva2.optimization.operator.initialization.DefaultInitialization;
import eva2.optimization.operator.initialization.InterfaceInitialization;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.operator.mutation.NoMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.EVAERROR;
import eva2.tools.math.RNG;
import eva2.util.annotation.Hidden;
import eva2.util.annotation.Parameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractEAIndividual
implements IndividualInterface,
Serializable {
    protected int age = 0;
    private long id = 0L;
    private static long idCounter = 0L;
    private boolean logParents = false;
    private Long[] parentIDs = null;
    private transient AbstractEAIndividual[] parentTree = null;
    protected double[] fitness = new double[1];
    private double constraintViolation = 0.0;
    public boolean areaConst4ParallelViolated = false;
    public boolean isMarked = false;
    public boolean isPenalized = false;
    protected double[] selectionProbability = new double[1];
    protected double crossoverProbability = 1.0;
    protected double mutationProbability = 0.2;
    protected InterfaceMutation mutationOperator = new NoMutation();
    protected InterfaceCrossover crossoverOperator = new NoCrossover();
    protected InterfaceInitialization initializationOperator = new DefaultInitialization();
    protected HashMap<String, Object> dataHash = new HashMap();
    private int individualIndex = -1;

    public AbstractEAIndividual() {
        this.id = ++idCounter;
    }

    public long getIndyID() {
        return this.id;
    }

    public int getIndividualIndex() {
        return this.individualIndex;
    }

    @Hidden
    public void setIndividualIndex(int index) {
        this.individualIndex = index;
    }

    public abstract Object clone();

    public void setOperators(InterfaceInitialization initOp, InterfaceMutation mutOp, double pMut, InterfaceCrossover coOp, double pCross) {
        this.initializationOperator = initOp;
        this.mutationProbability = pMut;
        this.mutationOperator = mutOp;
        this.crossoverProbability = pCross;
        this.crossoverOperator = coOp;
    }

    public void setOperators(InterfaceMutation mutOp, double pMut, InterfaceCrossover coOp, double pCross) {
        this.setOperators(new DefaultInitialization(), mutOp, pMut, coOp, pCross);
    }

    public void initCloneOperators(InterfaceMutation mutOp, double pMut, InterfaceCrossover coOp, double pCross, InterfaceOptimizationProblem problem) {
        this.mutationProbability = pMut;
        this.mutationOperator = (InterfaceMutation)mutOp.clone();
        this.mutationOperator.initialize(this, problem);
        this.crossoverProbability = pCross;
        this.crossoverOperator = (InterfaceCrossover)coOp.clone();
        this.crossoverOperator.init(this, problem);
    }

    public static AbstractEAIndividual setOperators(AbstractEAIndividual indy, InterfaceMutation mutOp, double pMut, InterfaceCrossover coOp, double pCross) {
        indy.setOperators(mutOp, pMut, coOp, pCross);
        return indy;
    }

    public void cloneAEAObjects(AbstractEAIndividual individual) {
        this.dataHash = (HashMap)individual.dataHash.clone();
        this.constraintViolation = individual.constraintViolation;
        this.isMarked = individual.isMarked;
        this.isPenalized = individual.isPenalized;
        this.individualIndex = individual.individualIndex;
        this.initializationOperator = individual.initializationOperator.clone();
        if (individual.parentIDs != null) {
            this.parentIDs = new Long[individual.parentIDs.length];
            System.arraycopy(individual.parentIDs, 0, this.parentIDs, 0, this.parentIDs.length);
            this.parentTree = new AbstractEAIndividual[individual.parentTree.length];
            System.arraycopy(individual.parentTree, 0, this.parentTree, 0, this.parentTree.length);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractEAIndividual) {
            AbstractEAIndividual indy = (AbstractEAIndividual)obj;
            if (!this.equalFitness(indy)) {
                return false;
            }
            this.constraintViolation = indy.constraintViolation;
            if (!this.equalGenotypes(indy)) {
                return false;
            }
            if (this.mutationProbability != indy.mutationProbability) {
                return false;
            }
            if (this.crossoverProbability != indy.crossoverProbability) {
                return false;
            }
            if (!this.mutationOperator.equals(indy.mutationOperator)) {
                return false;
            }
            return this.crossoverOperator.equals(indy.crossoverOperator);
        }
        return false;
    }

    public boolean equalFitness(AbstractEAIndividual indy) {
        double[] oF;
        double[] myF = this.getFitness();
        if (myF.length != (oF = indy.getFitness()).length) {
            return false;
        }
        for (int i = 0; i < oF.length; ++i) {
            if (myF[i] == oF[i]) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return "AbstractEAIndividual";
    }

    public void giveNewName() {
    }

    public int hashCode() {
        String t = AbstractEAIndividual.getDefaultStringRepresentation(this);
        return t.hashCode();
    }

    public abstract boolean equalGenotypes(AbstractEAIndividual var1);

    public void initialize(InterfaceOptimizationProblem opt) {
        this.initializationOperator.initialize(this, opt);
        this.mutationOperator.initialize(this, opt);
        this.crossoverOperator.init(this, opt);
    }

    public abstract void initByValue(Object var1, InterfaceOptimizationProblem var2);

    public void mutate() {
        if (RNG.flipCoin(this.mutationProbability)) {
            this.mutationOperator.mutate(this);
        }
    }

    public AbstractEAIndividual[] mateWith(Population partners) {
        AbstractEAIndividual[] result;
        block5: {
            int i;
            block4: {
                if (!RNG.flipCoin(this.crossoverProbability)) break block4;
                result = this.crossoverOperator.mate(this, partners);
                if (!this.logParents) break block5;
                for (int i2 = 0; i2 < result.length; ++i2) {
                    result[i2].setParents(this, partners);
                }
                break block5;
            }
            result = new AbstractEAIndividual[partners.size() + 1];
            result[0] = (AbstractEAIndividual)this.clone();
            for (i = 0; i < partners.size(); ++i) {
                result[i + 1] = (AbstractEAIndividual)((AbstractEAIndividual)partners.get(i)).clone();
            }
            if (this.logParents) {
                result[0].setParent(this);
                for (i = 0; i < partners.size(); ++i) {
                    result[i + 1].setParent(partners.getEAIndividual(i));
                }
            }
        }
        return result;
    }

    protected void setParents(AbstractEAIndividual parent, Population parents) {
        int parentCnt = parents == null ? 1 : 1 + parents.size();
        this.parentIDs = new Long[parentCnt];
        this.parentTree = new AbstractEAIndividual[parentCnt];
        this.parentIDs[0] = parent.getIndyID();
        this.parentTree[0] = (AbstractEAIndividual)parent.clone();
        if (parents != null && parents.size() > 0) {
            for (int i = 0; i < parents.size(); ++i) {
                this.parentIDs[i + 1] = parents.getEAIndividual(i).getIndyID();
                this.parentTree[i + 1] = (AbstractEAIndividual)parents.getEAIndividual(i).clone();
            }
        }
    }

    public void setParents(List<AbstractEAIndividual> parents) {
        if (parents == null || parents.size() == 0) {
            this.parentIDs = null;
            this.parentTree = null;
        } else {
            int parentCnt = parents.size();
            this.parentIDs = new Long[parentCnt];
            this.parentTree = new AbstractEAIndividual[parentCnt];
            for (int i = 0; i < parentCnt; ++i) {
                this.parentIDs[i] = parents.get(i).getIndyID();
                this.parentTree[i] = (AbstractEAIndividual)parents.get(i).clone();
            }
        }
    }

    public String getHeritageTree(int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getIndyID());
        sb.append(" ");
        if (depth > 0 && this.parentTree != null) {
            sb.append("[ ");
            for (int i = 0; i < this.parentTree.length; ++i) {
                sb.append(this.parentTree[i].getHeritageTree(depth - 1));
            }
            sb.append("] ");
        }
        return sb.toString();
    }

    protected void setParent(AbstractEAIndividual parent) {
        this.setParents(parent, null);
    }

    public Long[] getParentIDs() {
        return this.parentIDs;
    }

    public int getAge() {
        return this.age;
    }

    @Hidden
    public void setAge(int age) {
        this.age = age;
    }

    public void incrAge() {
        ++this.age;
    }

    public void resetUserData() {
        this.dataHash.clear();
    }

    public void resetConstraintViolation() {
        this.isPenalized = false;
        this.constraintViolation = 0.0;
    }

    public void addConstraintViolation(double c) {
        this.constraintViolation += Math.abs(c);
    }

    public double getConstraintViolation() {
        return this.constraintViolation;
    }

    public boolean violatesConstraint() {
        return this.constraintViolation > 0.0;
    }

    @Hidden
    public void setMarked(boolean t) {
        this.isMarked = t;
    }

    public boolean isMarked() {
        return this.isMarked;
    }

    public boolean isMarkedPenalized() {
        return this.isPenalized;
    }

    public void setMarkPenalized(boolean p) {
        this.isPenalized = p;
    }

    @Override
    public double[] getFitness() {
        return this.fitness;
    }

    public double getFitness(int index) {
        if (this.fitness.length > index) {
            return this.fitness[index];
        }
        return 0.0;
    }

    @Override
    @Hidden
    public void setFitness(double[] fitness) {
        this.fitness = fitness;
    }

    public void SetFitness(int index, double fitness) {
        if (this.fitness.length > index) {
            this.fitness[index] = fitness;
        } else {
            double[] tmpD = new double[index + 1];
            System.arraycopy(this.fitness, 0, tmpD, 0, this.fitness.length);
            this.fitness = tmpD;
            this.fitness[index] = fitness;
        }
    }

    public void resetFitness(double resetVal) {
        if (this.fitness != null) {
            for (int i = 0; i < this.fitness.length; ++i) {
                this.fitness[i] = resetVal;
            }
        }
    }

    public void checkAreaConst4Parallelization(ArrayList Constraints) {
        this.areaConst4ParallelViolated = false;
        if (Constraints != null) {
            for (int i = 0; i < Constraints.size(); ++i) {
                if (((InterfaceConstraint)Constraints.get(i)).isValid(this)) continue;
                this.areaConst4ParallelViolated = true;
            }
        }
    }

    public boolean isDominating(AbstractEAIndividual indy) {
        if (this.areaConst4ParallelViolated) {
            return false;
        }
        if (indy.areaConst4ParallelViolated) {
            return true;
        }
        return AbstractEAIndividual.isDominatingFitness(this.getFitness(), indy.getFitness());
    }

    public static boolean isDominatingFitness(double[] fit1, double[] fit2) {
        boolean result = true;
        for (int i = 0; result && i < fit1.length && i < fit2.length; ++i) {
            if (!AbstractEAIndividual.firstIsFiniteAndLargerNonEqual(fit1[i], fit2[i])) continue;
            result = false;
        }
        return result;
    }

    private static boolean firstIsFiniteAndLargerOrEqual(double a, double b) {
        return !Double.isNaN(a) && !Double.isInfinite(a) && a >= b;
    }

    private static boolean firstIsFiniteAndLargerNonEqual(double a, double b) {
        return !Double.isNaN(a) && !Double.isInfinite(a) && a > b;
    }

    public static boolean isDominatingFitnessNotEqual(double[] fit1, double[] fit2) {
        boolean result = true;
        for (int i = 0; result && i < fit1.length && i < fit2.length; ++i) {
            if (!(fit1[i] >= fit2[i])) continue;
            result = false;
        }
        return result;
    }

    public int compareConstraintViolation(AbstractEAIndividual indy) {
        if (this.constraintViolation > 0.0 && indy.constraintViolation <= 0.0) {
            return -1;
        }
        if (this.constraintViolation <= 0.0 && indy.constraintViolation > 0.0) {
            return 1;
        }
        if (this.constraintViolation < indy.constraintViolation) {
            return 1;
        }
        if (this.constraintViolation > indy.constraintViolation) {
            return -1;
        }
        return 0;
    }

    public boolean isDominatingDebConstraints(AbstractEAIndividual indy) {
        int constrViolComp = this.compareConstraintViolation(indy);
        if (constrViolComp == 0) {
            return AbstractEAIndividual.isDominatingFitness(this.getFitness(), indy.getFitness());
        }
        return constrViolComp > 0;
    }

    public boolean isDominatingEqual(AbstractEAIndividual indy) {
        if (this.areaConst4ParallelViolated) {
            return false;
        }
        if (indy.areaConst4ParallelViolated) {
            return true;
        }
        return AbstractEAIndividual.isDominatingFitnessNotEqual(this.getFitness(), indy.getFitness());
    }

    public boolean isDominatingDebConstraintsEqual(AbstractEAIndividual indy) {
        int constrViolComp = this.compareConstraintViolation(indy);
        if (constrViolComp == 0) {
            return AbstractEAIndividual.isDominatingFitnessNotEqual(this.getFitness(), indy.getFitness());
        }
        return constrViolComp > 0;
    }

    public double[] getSelectionProbability() {
        return this.selectionProbability;
    }

    public double getSelectionProbability(int index) {
        if (this.selectionProbability.length > index) {
            return this.selectionProbability[index];
        }
        return 0.0;
    }

    @Hidden
    public void setSelectionProbability(double[] sel) {
        this.selectionProbability = sel;
    }

    public void setSelectionProbability(int index, double sel) {
        if (this.selectionProbability.length > index) {
            this.selectionProbability[index] = sel;
        } else {
            double[] tmpD = new double[index + 1];
            System.arraycopy(this.selectionProbability, 0, tmpD, 0, this.selectionProbability.length);
            this.selectionProbability = tmpD;
            this.selectionProbability[index] = sel;
        }
    }

    @Parameter(name="mutator", description="The mutation operator to use.")
    public void setMutationOperator(InterfaceMutation mutator) {
        this.mutationOperator = mutator;
    }

    public InterfaceMutation getMutationOperator() {
        return this.mutationOperator;
    }

    @Parameter(name="pm", description="The chance that mutation occurs.")
    public void setMutationProbability(double mutprob) {
        if (mutprob < 0.0) {
            mutprob = 0.0;
        }
        if (mutprob > 1.0) {
            mutprob = 1.0;
        }
        this.mutationProbability = mutprob;
    }

    public double getMutationProbability() {
        return this.mutationProbability;
    }

    @Parameter(name="crossover", description="The crossover operator.")
    public void setCrossoverOperator(InterfaceCrossover crossover) {
        this.crossoverOperator = crossover;
    }

    public InterfaceCrossover getCrossoverOperator() {
        return this.crossoverOperator;
    }

    @Parameter(name="pc", description="The crossover rate")
    public void setCrossoverProbability(double prob) {
        this.crossoverProbability = prob;
        if (this.crossoverProbability > 1.0) {
            this.crossoverProbability = 1.0;
        }
        if (this.crossoverProbability < 0.0) {
            this.crossoverProbability = 0.0;
        }
    }

    public double getCrossoverProbability() {
        return this.crossoverProbability;
    }

    public InterfaceInitialization getInitOperator() {
        return this.initializationOperator;
    }

    @Parameter(name="initop", description="The initialization method for the individual")
    public void setInitOperator(InterfaceInitialization mInitOperator) {
        this.initializationOperator = mInitOperator;
    }

    public void putData(String name, Object obj) {
        this.dataHash.put(name, obj);
    }

    public Object getData(String name) {
        Object data = this.dataHash.get(name);
        if (data == null) {
            if (name.compareToIgnoreCase("Fitness") == 0) {
                data = this.getFitness();
            } else {
                EVAERROR.errorMsgOnce("Warning: data key " + name + " unknown (pot. multiple errors)!");
            }
        }
        return data;
    }

    public boolean hasData(String key) {
        if (this.dataHash.get(key) == null) {
            return key.compareToIgnoreCase("Fitness") == 0;
        }
        return true;
    }

    public abstract String getStringRepresentation();

    public static String getDefaultStringRepresentation(AbstractEAIndividual individual) {
        StringBuilder sb = new StringBuilder("Fit.:\t");
        sb.append(BeanInspector.toString(individual.getFitness()));
        if (individual.isMarkedPenalized() || individual.violatesConstraint()) {
            sb.append(", X");
        }
        sb.append(", ID: ");
        sb.append(individual.getIndyID());
        sb.append(",\t");
        sb.append(AbstractEAIndividual.getDefaultDataString(individual));
        if (individual.getParentIDs() != null) {
            sb.append(", parents: ");
            sb.append(BeanInspector.toString(individual.getParentIDs()));
        }
        return sb.toString();
    }

    public static String getDefaultDataString(IndividualInterface individual) {
        return AbstractEAIndividual.getDefaultDataString(individual, ",");
    }

    public static Object getDefaultDataObject(IndividualInterface individual) {
        if (individual instanceof InterfaceDataTypeBinary) {
            return ((InterfaceDataTypeBinary)((Object)individual)).getBinaryData().clone();
        }
        if (individual instanceof InterfaceDataTypeInteger) {
            return ((InterfaceDataTypeInteger)((Object)individual)).getIntegerData().clone();
        }
        if (individual instanceof InterfaceDataTypeDouble) {
            return ((InterfaceDataTypeDouble)((Object)individual)).getDoubleData().clone();
        }
        if (individual instanceof InterfaceDataTypePermutation) {
            return ((InterfaceDataTypePermutation)((Object)individual)).getPermutationData()[0].clone();
        }
        if (individual instanceof InterfaceDataTypeProgram) {
            return ((InterfaceDataTypeProgram)((Object)individual)).getProgramDataWithoutUpdate().clone();
        }
        System.err.println("error in AbstractEAIndividual.getDefaultDataObject: type " + individual.getClass() + " not implemented");
        return individual;
    }

    public static String getDefaultDataString(IndividualInterface individual, String separator) {
        if (individual == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer("");
        Formatter fm = new Formatter(sb);
        char left = '{';
        char right = '}';
        sb.append(left);
        if (individual instanceof InterfaceDataTypeBinary) {
            BitSet b = ((InterfaceDataTypeBinary)((Object)individual)).getBinaryData();
            for (int i = 0; i < ((InterfaceDataTypeBinary)((Object)individual)).size(); ++i) {
                if (b.get(i)) {
                    sb.append("1");
                    continue;
                }
                sb.append("0");
            }
        } else if (individual instanceof InterfaceDataTypeInteger) {
            int[] b = ((InterfaceDataTypeInteger)((Object)individual)).getIntegerData();
            for (int i = 0; i < b.length; ++i) {
                sb.append(b[i]);
                if (i + 1 >= b.length) continue;
                sb.append(separator);
            }
        } else if (individual instanceof InterfaceDataTypeDouble) {
            double[] d = ((InterfaceDataTypeDouble)((Object)individual)).getDoubleData();
            for (int i = 0; i < d.length; ++i) {
                fm.format("% .3f", d[i]);
                if (i + 1 >= d.length) continue;
                sb.append(separator);
            }
        } else if (individual instanceof InterfaceDataTypePermutation) {
            int[] b = ((InterfaceDataTypePermutation)((Object)individual)).getPermutationData()[0];
            for (int i = 0; i < b.length; ++i) {
                sb.append(b[i]);
                if (i + 1 >= b.length) continue;
                sb.append(separator);
            }
        } else if (individual instanceof InterfaceDataTypeProgram) {
            InterfaceProgram[] b = ((InterfaceDataTypeProgram)((Object)individual)).getProgramDataWithoutUpdate();
            for (int i = 0; i < b.length; ++i) {
                sb.append(b[i].getStringRepresentation());
                if (i + 1 >= b.length) continue;
                sb.append(separator);
            }
        } else {
            if (BeanInspector.hasMethod((Object)individual, "toString", null) != null) {
                EVAERROR.errorMsgOnce("warning in AbstractEAIndividual::getDefaultDataString: type " + individual.getClass() + " has no default data representation, using toString...");
                return individual.toString();
            }
            System.err.println("error in AbstractEAIndividual::getDefaultDataString: type " + individual.getClass() + " not implemented");
        }
        sb.append(right);
        return sb.toString();
    }

    public String toString() {
        return AbstractEAIndividual.getDefaultStringRepresentation(this);
    }

    public static double[] getDoublePositionShallow(AbstractEAIndividual indy) {
        if (indy instanceof InterfaceESIndividual) {
            return ((InterfaceESIndividual)((Object)indy)).getDGenotype();
        }
        if (indy instanceof InterfaceDataTypeDouble) {
            return ((InterfaceDataTypeDouble)((Object)indy)).getDoubleData();
        }
        if (indy instanceof InterfaceDataTypeInteger) {
            int[] intData = ((InterfaceDataTypeInteger)((Object)indy)).getIntegerData();
            double[] pos = new double[intData.length];
            for (int i = 0; i < intData.length; ++i) {
                pos[i] = intData[i];
            }
            return pos;
        }
        EVAERROR.errorMsgOnce("Unhandled case in AbstractEAIndividual.getDoublePositionShallow()!");
        return null;
    }

    public static double[] getDoublePosition(AbstractEAIndividual indy) {
        double[] position = AbstractEAIndividual.getDoublePositionShallow(indy);
        return position;
    }

    public static boolean setDoublePosition(AbstractEAIndividual indy, double[] pos) {
        if (indy instanceof InterfaceESIndividual) {
            ((InterfaceESIndividual)((Object)indy)).setDGenotype(pos);
            return true;
        }
        if (indy instanceof InterfaceDataTypeDouble) {
            ((InterfaceDataTypeDouble)((Object)indy)).setDoubleGenotype(pos);
            return true;
        }
        if (indy instanceof InterfaceDataTypeInteger) {
            EVAERROR.errorMsgOnce("Warning, double position truncated to integer! (AbstractEAIndividual.setDoublePosition)");
            int[] intData = new int[pos.length];
            for (int i = 0; i < intData.length; ++i) {
                intData[i] = (int)pos[i];
            }
            ((InterfaceDataTypeInteger)((Object)indy)).setIntGenotype(intData);
            return true;
        }
        EVAERROR.errorMsgOnce("Unhandled case in AbstractEAIndividual.setDoublePosition()!");
        return false;
    }

    public double[] getDoublePosition() {
        return AbstractEAIndividual.getDoublePosition(this);
    }

    protected boolean isLogParents() {
        return this.logParents;
    }

    protected void setLogParents(boolean logParents) {
        this.logParents = logParents;
    }

    @Override
    public IndividualInterface getClone() {
        return (IndividualInterface)this.clone();
    }

    public boolean isDominantNotEqual(double[] otherFitness) {
        return AbstractEAIndividual.isDominatingFitnessNotEqual(this.fitness, otherFitness);
    }

    @Override
    public boolean isDominant(double[] otherFitness) {
        return AbstractEAIndividual.isDominatingFitness(this.fitness, otherFitness);
    }

    @Override
    public boolean isDominant(IndividualInterface indy) {
        return this.isDominatingDebConstraints((AbstractEAIndividual)indy);
    }

    public static Object getIndyData(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceDataTypeBinary) {
            BitSet b = ((InterfaceDataTypeBinary)((Object)individual)).getBinaryData();
            return b;
        }
        if (individual instanceof InterfaceDataTypeInteger) {
            int[] b = ((InterfaceDataTypeInteger)((Object)individual)).getIntegerData();
            return b;
        }
        if (individual instanceof InterfaceDataTypeDouble) {
            double[] b = ((InterfaceDataTypeDouble)((Object)individual)).getDoubleData();
            return b;
        }
        if (individual instanceof InterfaceDataTypePermutation) {
            int[] b = ((InterfaceDataTypePermutation)((Object)individual)).getPermutationData()[0];
            return b;
        }
        if (individual instanceof InterfaceDataTypeProgram) {
            InterfaceProgram[] b = ((InterfaceDataTypeProgram)((Object)individual)).getProgramData();
            return b;
        }
        System.err.println("error in AbstractEAIndividual::getDefaultDataString: type " + individual.getClass() + " not implemented");
        return null;
    }
}

