/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.Comparator;

@Description(value="A comparator class for general EA individuals. Compares individuals based on their fitness in context of minimization.")
public class EAIndividualComparator
implements Comparator<Object>,
Serializable {
    private String indyDataKey = "";
    private int fitCriterion = -1;
    private boolean preferFeasible = true;

    public EAIndividualComparator() {
        this("", -1, true);
    }

    public EAIndividualComparator(String indyDataKey) {
        this(indyDataKey, -1, true);
    }

    public EAIndividualComparator(int fitnessCriterion) {
        this("", fitnessCriterion, true);
    }

    public EAIndividualComparator(int fitIndex, boolean preferFeasible) {
        this("", fitIndex, preferFeasible);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof EAIndividualComparator) {
            EAIndividualComparator o = (EAIndividualComparator)other;
            if ((this.indyDataKey.equals(o.indyDataKey) || this.indyDataKey != null && this.indyDataKey.equals(o.indyDataKey)) && this.fitCriterion == o.fitCriterion && this.preferFeasible == o.preferFeasible) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.indyDataKey.hashCode() + 100 + this.fitCriterion + (this.preferFeasible ? 7 : 13);
    }

    public EAIndividualComparator(String indyDataKey, int fitnessCriterion, boolean preferFeasible) {
        this.indyDataKey = indyDataKey;
        this.fitCriterion = fitnessCriterion;
        this.preferFeasible = preferFeasible;
    }

    public EAIndividualComparator(EAIndividualComparator other) {
        this.indyDataKey = other.indyDataKey;
        this.fitCriterion = other.fitCriterion;
        this.preferFeasible = other.preferFeasible;
    }

    public Object clone() {
        return new EAIndividualComparator(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int compare(Object o1, Object o2) {
        boolean o2domO1;
        boolean o1domO2;
        block11: {
            if (this.preferFeasible) {
                int constrViolComp = ((AbstractEAIndividual)o1).compareConstraintViolation((AbstractEAIndividual)o2);
                if (constrViolComp > 0) {
                    return -1;
                }
                if (constrViolComp < 0) {
                    return 1;
                }
            }
            if (this.indyDataKey != null && this.indyDataKey.length() > 0) {
                double[] fit1 = (double[])((AbstractEAIndividual)o1).getData(this.indyDataKey);
                double[] fit2 = (double[])((AbstractEAIndividual)o2).getData(this.indyDataKey);
                if (fit1 == null) throw new RuntimeException("Unknown individual data key " + this.indyDataKey + ", unable to compare individuals (" + this.getClass().getSimpleName() + ")");
                if (fit2 == null) {
                    throw new RuntimeException("Unknown individual data key " + this.indyDataKey + ", unable to compare individuals (" + this.getClass().getSimpleName() + ")");
                }
                if (this.fitCriterion < 0) {
                    o1domO2 = AbstractEAIndividual.isDominatingFitness(fit1, fit2);
                    o2domO1 = AbstractEAIndividual.isDominatingFitness(fit2, fit1);
                    break block11;
                } else {
                    if (fit1[this.fitCriterion] == fit2[this.fitCriterion]) {
                        return 0;
                    }
                    if (!(fit1[this.fitCriterion] < fit2[this.fitCriterion])) return 1;
                    return -1;
                }
            }
            if (this.fitCriterion < 0) {
                o1domO2 = ((AbstractEAIndividual)o1).isDominating((AbstractEAIndividual)o2);
                o2domO1 = ((AbstractEAIndividual)o2).isDominating((AbstractEAIndividual)o1);
            } else {
                if (((AbstractEAIndividual)o1).getFitness()[this.fitCriterion] == ((AbstractEAIndividual)o2).getFitness()[this.fitCriterion]) {
                    return 0;
                }
                if (!(((AbstractEAIndividual)o1).getFitness()[this.fitCriterion] < ((AbstractEAIndividual)o2).getFitness()[this.fitCriterion])) return 1;
                return -1;
            }
        }
        if (!(o1domO2 ^ o2domO1)) return 0;
        if (!o1domO2) return 1;
        return -1;
    }

    public String getIndyDataKey() {
        return this.indyDataKey;
    }

    public void setIndyDataKey(String indyDataKey) {
        this.indyDataKey = indyDataKey;
    }

    public String indyDataKeyTipText() {
        return "A String can be given which retrievies individual properties based on which the comparison is performed.";
    }

    public int getFitCriterion() {
        return this.fitCriterion;
    }

    public void setFitCriterion(int fitCriterion) {
        this.fitCriterion = fitCriterion;
    }

    public String fitCriterionTipText() {
        return "If -1, dominance is used, otherwise the indexed fitness criterion (for multiobjective problems)";
    }

    public boolean isPreferFeasible() {
        return this.preferFeasible;
    }

    public void setPreferFeasible(boolean priorConst) {
        this.preferFeasible = priorConst;
    }

    public String preferFeasibleTipText() {
        return "Activate preference of feasible individuals in any comparison acc. to Deb's rules.";
    }

    public String getName() {
        return "IndividualComparator";
    }
}

