/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.individuals.InterfaceDataTypeBinary;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.crossover.CrossoverESDefault;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.operator.mutation.MutateESGlobal;
import eva2.problems.InterfaceHasInitRange;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.BitSet;

@Description(value="This is an ES individual adopted to optimize binary values.")
public class ESIndividualBinaryData
extends AbstractEAIndividual
implements InterfaceESIndividual,
InterfaceDataTypeBinary,
Serializable {
    private BitSet phenotype = new BitSet();
    private double[] genotype;
    private boolean useHardSwitch = false;
    private double[][] initializationRange;

    public ESIndividualBinaryData() {
        this.mutationProbability = 1.0;
        this.mutationOperator = new MutateESGlobal();
        this.crossoverProbability = 0.5;
        this.crossoverOperator = new CrossoverESDefault();
        this.genotype = new double[1];
        this.initializationRange = new double[1][2];
        this.initializationRange[0][0] = 0.0;
        this.initializationRange[0][1] = 1.0;
    }

    public ESIndividualBinaryData(ESIndividualBinaryData individual) {
        if (individual.phenotype != null) {
            this.phenotype = (BitSet)individual.phenotype.clone();
        }
        this.genotype = new double[individual.genotype.length];
        this.initializationRange = new double[individual.genotype.length][2];
        for (int i = 0; i < this.genotype.length; ++i) {
            this.genotype[i] = individual.genotype[i];
            this.initializationRange[i][0] = individual.initializationRange[i][0];
            this.initializationRange[i][1] = individual.initializationRange[i][1];
        }
        this.useHardSwitch = individual.useHardSwitch;
        this.age = individual.age;
        this.crossoverOperator = individual.crossoverOperator;
        this.crossoverProbability = individual.crossoverProbability;
        this.mutationOperator = (InterfaceMutation)individual.mutationOperator.clone();
        this.mutationProbability = individual.mutationProbability;
        this.selectionProbability = new double[individual.selectionProbability.length];
        System.arraycopy(individual.selectionProbability, 0, this.selectionProbability, 0, this.selectionProbability.length);
        this.fitness = new double[individual.fitness.length];
        System.arraycopy(individual.fitness, 0, this.fitness, 0, this.fitness.length);
        this.cloneAEAObjects(individual);
    }

    @Override
    public Object clone() {
        return new ESIndividualBinaryData(this);
    }

    @Override
    public boolean equalGenotypes(AbstractEAIndividual individual) {
        if (individual instanceof ESIndividualBinaryData) {
            ESIndividualBinaryData indy = (ESIndividualBinaryData)individual;
            if (this.genotype == null || indy.genotype == null) {
                return false;
            }
            if (this.initializationRange == null || indy.initializationRange == null) {
                return false;
            }
            for (int i = 0; i < this.initializationRange.length; ++i) {
                if (this.genotype[i] != indy.genotype[i]) {
                    return false;
                }
                if (this.initializationRange[i][0] != indy.initializationRange[i][0]) {
                    return false;
                }
                if (this.initializationRange[i][1] == indy.initializationRange[i][1]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setBinaryDataLength(int length) {
        this.genotype = new double[length];
        this.initializationRange = new double[length][2];
        for (int i = 0; i < this.initializationRange.length; ++i) {
            this.initializationRange[i][0] = 0.0;
            this.initializationRange[i][1] = 1.0;
        }
    }

    @Override
    public int size() {
        return this.genotype.length;
    }

    @Override
    public BitSet getBinaryData() {
        if (this.useHardSwitch) {
            for (int i = 0; i < this.genotype.length; ++i) {
                if (this.genotype[i] > 0.5) {
                    this.phenotype.set(i);
                    continue;
                }
                this.phenotype.clear(i);
            }
        } else {
            for (int i = 0; i < this.genotype.length; ++i) {
                if (RNG.flipCoin(this.genotype[i])) {
                    this.phenotype.set(i);
                    continue;
                }
                this.phenotype.clear(i);
            }
        }
        return this.phenotype;
    }

    @Override
    public BitSet getBinaryDataWithoutUpdate() {
        return this.phenotype;
    }

    @Override
    public void setBinaryPhenotype(BitSet binaryData) {
        this.phenotype = binaryData;
    }

    @Override
    public void setBinaryGenotype(BitSet binaryData) {
        this.setBinaryPhenotype(binaryData);
        for (int i = 0; i < this.genotype.length; ++i) {
            if (this.useHardSwitch) {
                if (binaryData.get(i)) {
                    this.genotype[i] = RNG.randomDouble(0.55, 1.0);
                    continue;
                }
                this.genotype[i] = RNG.randomDouble(0.0, 0.45);
                continue;
            }
            this.genotype[i] = binaryData.get(i) ? 0.9 : 0.1;
        }
    }

    @Override
    public void initByValue(Object obj, InterfaceOptimizationProblem opt) {
        if (obj instanceof BitSet) {
            BitSet bs = (BitSet)obj;
            this.setBinaryGenotype(bs);
        } else {
            this.defaultInit(opt);
            System.out.println("Initial value for ESIndividualBinaryData is no BitSet!");
        }
        this.mutationOperator.initialize(this, opt);
        this.crossoverOperator.init(this, opt);
    }

    @Override
    public String getStringRepresentation() {
        int i;
        String result = "";
        result = result + "ESIndividual coding double: (";
        result = result + "Fitness {";
        for (i = 0; i < this.fitness.length; ++i) {
            result = result + this.fitness[i] + ";";
        }
        result = result + "}/SelProb{";
        for (i = 0; i < this.selectionProbability.length; ++i) {
            result = result + this.selectionProbability[i] + ";";
        }
        result = result + "})\n Value: ";
        result = result + "[";
        for (i = 0; i < this.genotype.length; ++i) {
            result = result + this.genotype[i] + "; ";
        }
        result = result + "]";
        return result;
    }

    @Override
    public double[] getDGenotype() {
        return this.genotype;
    }

    @Override
    public void setDGenotype(double[] b) {
        this.genotype = b;
        for (int i = 0; i < this.genotype.length; ++i) {
            if (this.genotype[i] < this.initializationRange[i][0]) {
                this.genotype[i] = this.initializationRange[1][0];
            }
            if (!(this.genotype[i] > this.initializationRange[i][1])) continue;
            this.genotype[i] = this.initializationRange[1][1];
        }
    }

    @Override
    public double[][] getDoubleRange() {
        return this.initializationRange;
    }

    @Override
    public void defaultMutate() {
        ESIndividualDoubleData.defaultMutate(this.genotype, this.initializationRange);
    }

    @Override
    public void defaultInit(InterfaceOptimizationProblem prob) {
        if (prob != null && prob instanceof InterfaceHasInitRange && ((InterfaceHasInitRange)((Object)prob)).getInitializationRange() != null) {
            ESIndividualDoubleData.defaultInit(this.genotype, (double[][])((InterfaceHasInitRange)((Object)prob)).getInitializationRange());
        } else {
            ESIndividualDoubleData.defaultInit(this.genotype, this.initializationRange);
        }
    }

    @Override
    public String getName() {
        return "ES individual";
    }

    public void setToggleInterpretation(boolean b) {
        this.useHardSwitch = b;
    }

    public boolean getToggleInterpretation() {
        return this.useHardSwitch;
    }

    public String toggleInterpretationTipText() {
        return "Toggle between interpretation as probability or if(>0.5).";
    }
}

