/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals;

import eva2.optimization.enums.MutateESCrossoverType;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.crossover.CrossoverESDefault;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.operator.mutation.MutateESGlobal;
import eva2.problems.InterfaceHasInitRange;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.EVAERROR;
import eva2.tools.math.Mathematics;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import eva2.util.annotation.Hidden;
import java.io.Serializable;
import java.util.logging.Logger;

@Description(value="This is an ES individual suited to optimize double values.")
public class ESIndividualDoubleData
extends AbstractEAIndividual
implements InterfaceESIndividual,
InterfaceDataTypeDouble,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(ESIndividualDoubleData.class.getName());
    private double[] genotype;
    private double[] phenotype;
    private double[][] range;

    public ESIndividualDoubleData() {
        this.mutationProbability = 1.0;
        this.mutationOperator = new MutateESGlobal(0.2, MutateESCrossoverType.intermediate);
        this.crossoverProbability = 0.5;
        this.crossoverOperator = new CrossoverESDefault();
        this.genotype = new double[1];
        this.phenotype = null;
        this.range = new double[1][2];
        this.range[0][0] = -10.0;
        this.range[0][1] = 10.0;
    }

    public ESIndividualDoubleData(ESIndividualDoubleData individual) {
        if (individual.phenotype != null) {
            this.phenotype = new double[individual.phenotype.length];
            System.arraycopy(individual.phenotype, 0, this.phenotype, 0, this.phenotype.length);
        }
        this.genotype = new double[individual.genotype.length];
        this.range = new double[individual.range.length][2];
        for (int i = 0; i < this.genotype.length; ++i) {
            this.genotype[i] = individual.genotype[i];
            this.range[i][0] = individual.range[i][0];
            this.range[i][1] = individual.range[i][1];
        }
        this.age = individual.age;
        this.crossoverOperator = individual.crossoverOperator;
        this.crossoverProbability = individual.crossoverProbability;
        this.mutationOperator = (InterfaceMutation)individual.mutationOperator.clone();
        this.mutationProbability = individual.mutationProbability;
        this.selectionProbability = new double[individual.selectionProbability.length];
        System.arraycopy(individual.selectionProbability, 0, this.selectionProbability, 0, this.selectionProbability.length);
        this.fitness = new double[individual.fitness.length];
        System.arraycopy(individual.fitness, 0, this.fitness, 0, this.fitness.length);
        this.cloneAEAObjects(individual);
    }

    @Override
    public Object clone() {
        return new ESIndividualDoubleData(this);
    }

    @Override
    public boolean equalGenotypes(AbstractEAIndividual individual) {
        if (individual instanceof ESIndividualDoubleData) {
            ESIndividualDoubleData indy = (ESIndividualDoubleData)individual;
            if (this.genotype == null || indy.genotype == null) {
                return false;
            }
            if (this.range == null || indy.range == null) {
                return false;
            }
            if (this.genotype.length != indy.genotype.length) {
                return false;
            }
            if (this.range.length != indy.range.length) {
                return false;
            }
            for (int i = 0; i < this.genotype.length; ++i) {
                if (this.genotype[i] != indy.genotype[i]) {
                    return false;
                }
                if (this.range[i][0] != indy.range[i][0]) {
                    return false;
                }
                if (this.range[i][1] == indy.range[i][1]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setDoubleDataLength(int length) {
        int i;
        double[] newDesPa = new double[length];
        double[][] newRange = new double[length][2];
        for (i = 0; i < newDesPa.length && i < this.genotype.length; ++i) {
            newDesPa[i] = this.genotype[i];
            newRange[i][0] = this.range[i][0];
            newRange[i][1] = this.range[i][1];
        }
        for (i = this.genotype.length; i < newDesPa.length; ++i) {
            newDesPa[i] = this.genotype[this.genotype.length - 1];
            newRange[i][0] = this.range[this.genotype.length - 1][0];
            newRange[i][1] = this.range[this.genotype.length - 1][1];
        }
        this.genotype = newDesPa;
        this.range = newRange;
        this.phenotype = null;
    }

    @Override
    public int size() {
        return this.genotype.length;
    }

    @Override
    @Hidden
    public void setDoubleRange(double[][] range) {
        if (range.length != this.range.length) {
            LOGGER.warning("Trying to set a range of length " + range.length + " to a vector of length " + this.range.length + "!\n Use method setDoubleDataLength first! (ESIndividualDoubleData:setDoubleRange)");
        }
        for (int i = 0; i < this.range.length && i < range.length; ++i) {
            this.range[i][0] = range[i][0];
            this.range[i][1] = range[i][1];
        }
    }

    @Override
    public double[][] getDoubleRange() {
        return this.range;
    }

    @Override
    public double[] getDoubleData() {
        if (this.phenotype != null) {
            return this.phenotype;
        }
        this.phenotype = new double[this.genotype.length];
        System.arraycopy(this.genotype, 0, this.phenotype, 0, this.genotype.length);
        return this.phenotype;
    }

    @Override
    public double[] getDoubleDataWithoutUpdate() {
        if (this.phenotype == null) {
            return this.getDoubleData();
        }
        return this.phenotype;
    }

    @Override
    public void setDoublePhenotype(double[] doubleData) {
        this.phenotype = doubleData;
    }

    @Override
    public void setDoubleGenotype(double[] doubleData) {
        this.setDoublePhenotype(null);
        this.genotype = new double[doubleData.length];
        System.arraycopy(doubleData, 0, this.genotype, 0, doubleData.length);
    }

    @Override
    public void initialize(InterfaceOptimizationProblem opt) {
        super.initialize(opt);
        if (!Mathematics.isInRange(this.genotype, this.range)) {
            EVAERROR.errorMsgOnce("Warning: Individual out of range after initialization (and potential initial crossover/mutation)!");
        }
    }

    @Override
    public void initByValue(Object obj, InterfaceOptimizationProblem opt) {
        if (obj instanceof double[]) {
            double[] bs = (double[])obj;
            if (bs.length != this.genotype.length) {
                System.out.println("Init value and requested length doesn't match!");
            }
            this.setDoubleGenotype(bs);
        } else {
            this.defaultInit(opt);
            System.out.println("Initial value for ESIndividualDoubleData is not double[]!");
        }
        this.mutationOperator.initialize(this, opt);
        this.crossoverOperator.init(this, opt);
    }

    @Override
    public String getStringRepresentation() {
        int i;
        StringBuilder strB = new StringBuilder(200);
        strB.append("ESIndividual coding double: (Fitness {");
        for (i = 0; i < this.fitness.length; ++i) {
            strB.append(this.fitness[i]);
            strB.append(";");
        }
        strB.append("}/SelProb{");
        for (i = 0; i < this.selectionProbability.length; ++i) {
            strB.append(this.selectionProbability[i]);
            strB.append(";");
        }
        strB.append("}) Value: [");
        for (i = 0; i < this.genotype.length; ++i) {
            strB.append(this.genotype[i]);
            strB.append("; ");
        }
        strB.append("]");
        return strB.toString();
    }

    @Override
    public double[] getDGenotype() {
        return this.genotype;
    }

    @Override
    @Hidden
    public void setDGenotype(double[] b) {
        this.genotype = b;
        this.phenotype = null;
        for (int i = 0; i < this.genotype.length; ++i) {
            if (this.genotype[i] < this.range[i][0]) {
                this.genotype[i] = this.range[i][0];
            }
            if (!(this.genotype[i] > this.range[i][1])) continue;
            this.genotype[i] = this.range[i][1];
        }
    }

    public void setDGenotypeNocheck(double[] b) {
        this.phenotype = null;
        this.genotype = b;
    }

    @Override
    public void defaultMutate() {
        ESIndividualDoubleData.defaultMutate(this.genotype, this.range);
        this.phenotype = null;
    }

    public static void defaultMutate(double[] genotype, double[][] range) {
        int mutationIndex;
        int n = mutationIndex = RNG.randomInt(0, genotype.length - 1);
        genotype[n] = genotype[n] + (range[mutationIndex][1] - range[mutationIndex][0]) / 2.0 * RNG.gaussianDouble(0.05f);
        if (genotype[mutationIndex] < range[mutationIndex][0]) {
            genotype[mutationIndex] = range[mutationIndex][0];
        }
        if (genotype[mutationIndex] > range[mutationIndex][1]) {
            genotype[mutationIndex] = range[mutationIndex][1];
        }
    }

    @Override
    public void defaultInit(InterfaceOptimizationProblem prob) {
        if (prob != null && prob instanceof InterfaceHasInitRange && ((InterfaceHasInitRange)((Object)prob)).getInitializationRange() != null) {
            ESIndividualDoubleData.defaultInit(this.genotype, (double[][])((InterfaceHasInitRange)((Object)prob)).getInitializationRange());
        } else {
            ESIndividualDoubleData.defaultInit(this.genotype, this.range);
        }
        this.phenotype = null;
    }

    public static void defaultInit(double[] genotype, double[][] range) {
        for (int i = 0; i < genotype.length; ++i) {
            genotype[i] = RNG.randomDouble(range[i][0], range[i][1]);
        }
    }

    @Override
    public String getName() {
        return "ES individual";
    }
}

