/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeInteger;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.crossover.CrossoverESDefault;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.operator.mutation.MutateESGlobal;
import eva2.problems.InterfaceHasInitRange;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is an ES individual suited to optimize integer values.")
public class ESIndividualIntegerData
extends AbstractEAIndividual
implements InterfaceESIndividual,
InterfaceDataTypeInteger,
Serializable {
    private double[] genotype;
    private int[] phenotype;
    private int[][] range;

    public ESIndividualIntegerData() {
        this.mutationProbability = 1.0;
        this.mutationOperator = new MutateESGlobal();
        this.crossoverProbability = 0.5;
        this.crossoverOperator = new CrossoverESDefault();
        this.genotype = new double[1];
        this.range = new int[1][2];
        this.range[0][0] = -10;
        this.range[0][1] = 10;
    }

    public ESIndividualIntegerData(ESIndividualIntegerData individual) {
        if (individual.phenotype != null) {
            this.phenotype = new int[individual.phenotype.length];
            System.arraycopy(individual.phenotype, 0, this.phenotype, 0, this.phenotype.length);
        }
        this.genotype = new double[individual.genotype.length];
        this.range = new int[individual.genotype.length][2];
        for (int i = 0; i < this.genotype.length; ++i) {
            this.genotype[i] = individual.genotype[i];
            this.range[i][0] = individual.range[i][0];
            this.range[i][1] = individual.range[i][1];
        }
        this.age = individual.age;
        this.crossoverOperator = individual.crossoverOperator;
        this.crossoverProbability = individual.crossoverProbability;
        this.mutationOperator = (InterfaceMutation)individual.mutationOperator.clone();
        this.mutationProbability = individual.mutationProbability;
        this.selectionProbability = new double[individual.selectionProbability.length];
        System.arraycopy(individual.selectionProbability, 0, this.selectionProbability, 0, this.selectionProbability.length);
        this.fitness = new double[individual.fitness.length];
        System.arraycopy(individual.fitness, 0, this.fitness, 0, this.fitness.length);
        this.cloneAEAObjects(individual);
    }

    @Override
    public Object clone() {
        return new ESIndividualIntegerData(this);
    }

    @Override
    public boolean equalGenotypes(AbstractEAIndividual individual) {
        if (individual instanceof ESIndividualIntegerData) {
            ESIndividualIntegerData indy = (ESIndividualIntegerData)individual;
            if (this.genotype == null || indy.genotype == null) {
                return false;
            }
            if (this.range == null || indy.range == null) {
                return false;
            }
            for (int i = 0; i < this.range.length; ++i) {
                if (this.genotype[i] != indy.genotype[i]) {
                    return false;
                }
                if (this.range[i][0] != indy.range[i][0]) {
                    return false;
                }
                if (this.range[i][1] == indy.range[i][1]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setIntegerDataLength(int length) {
        int i;
        double[] newDesPa = new double[length];
        int[][] newRange = new int[length][2];
        for (i = 0; i < newDesPa.length && i < this.genotype.length; ++i) {
            newDesPa[i] = this.genotype[i];
            newRange[i][0] = this.range[i][0];
            newRange[i][1] = this.range[i][1];
        }
        for (i = this.genotype.length; i < newDesPa.length; ++i) {
            newDesPa[i] = this.genotype[this.genotype.length - 1];
            newRange[i][0] = this.range[this.genotype.length - 1][0];
            newRange[i][1] = this.range[this.genotype.length - 1][1];
        }
        this.genotype = newDesPa;
        this.range = newRange;
    }

    @Override
    public int size() {
        return this.genotype.length;
    }

    @Override
    public void setIntRange(int[][] range) {
        if (range.length != this.range.length) {
            System.out.println("Warning: Trying to set a range of length " + range.length + " to a vector of length " + this.range.length + "!\n Use method setIntegerDataLength first (ESIndividualIntegerData::setIntRange)!");
        }
        for (int i = 0; i < this.range.length && i < range.length; ++i) {
            this.range[i][0] = range[i][0];
            this.range[i][1] = range[i][1];
        }
    }

    @Override
    public int[][] getIntRange() {
        return this.range;
    }

    @Override
    public int[] getIntegerData() {
        this.phenotype = new int[this.genotype.length];
        for (int i = 0; i < this.phenotype.length; ++i) {
            this.phenotype[i] = (int)this.genotype[i];
            if (this.phenotype[i] < this.range[i][0]) {
                this.phenotype[i] = this.range[i][0];
            }
            if (this.phenotype[i] <= this.range[i][1]) continue;
            this.phenotype[i] = this.range[i][1];
        }
        return this.phenotype;
    }

    @Override
    public int[] getIntegerDataWithoutUpdate() {
        return this.phenotype;
    }

    @Override
    public void setIntPhenotype(int[] intData) {
        this.phenotype = intData;
    }

    @Override
    public void setIntGenotype(int[] intData) {
        for (int i = 0; i < this.genotype.length; ++i) {
            this.genotype[i] = intData[i];
        }
        this.getIntegerData();
    }

    @Override
    public void initByValue(Object obj, InterfaceOptimizationProblem opt) {
        if (obj instanceof int[]) {
            int[] bs = (int[])obj;
            if (bs.length != this.genotype.length) {
                System.out.println("Init value and requested length doesn't match!");
            }
            this.setIntGenotype(bs);
        } else {
            this.defaultInit(opt);
            System.out.println("Initial value for ESIndividualIntegerData is not int[]!");
        }
        this.mutationOperator.initialize(this, opt);
        this.crossoverOperator.init(this, opt);
    }

    @Override
    public String getStringRepresentation() {
        int i;
        String result = "";
        result = result + "ESIndividual coding int: (";
        result = result + "Fitness {";
        for (i = 0; i < this.fitness.length; ++i) {
            result = result + this.fitness[i] + ";";
        }
        result = result + "}/SelProb{";
        for (i = 0; i < this.selectionProbability.length; ++i) {
            result = result + this.selectionProbability[i] + ";";
        }
        result = result + "})\n Value: ";
        result = result + "[";
        for (i = 0; i < this.genotype.length; ++i) {
            result = result + this.genotype[i] + "; ";
        }
        result = result + "]";
        return result;
    }

    @Override
    public double[] getDGenotype() {
        return this.genotype;
    }

    @Override
    public void setDGenotype(double[] b) {
        this.genotype = b;
        for (int i = 0; i < this.genotype.length; ++i) {
            if (this.genotype[i] < (double)this.range[i][0]) {
                this.genotype[i] = this.range[i][0];
            }
            if (!(this.genotype[i] > (double)this.range[i][1])) continue;
            this.genotype[i] = this.range[i][1];
        }
    }

    @Override
    public void defaultMutate() {
        int mutationIndex;
        int n = mutationIndex = RNG.randomInt(0, this.genotype.length - 1);
        this.genotype[n] = this.genotype[n] + (double)((this.range[mutationIndex][1] - this.range[mutationIndex][0]) / 2) * RNG.gaussianDouble(0.05f);
        if (this.genotype[mutationIndex] < (double)this.range[mutationIndex][0]) {
            this.genotype[mutationIndex] = this.range[mutationIndex][0];
        }
        if (this.genotype[mutationIndex] > (double)this.range[mutationIndex][1]) {
            this.genotype[mutationIndex] = this.range[mutationIndex][1];
        }
    }

    @Override
    public double[][] getDoubleRange() {
        double[][] result = new double[this.range.length][2];
        for (int i = 0; i < this.range.length; ++i) {
            result[i][0] = this.range[i][0];
            result[i][1] = this.range[i][1];
        }
        return result;
    }

    @Override
    public void defaultInit(InterfaceOptimizationProblem prob) {
        int[][] range = this.range;
        if (prob != null && prob instanceof InterfaceHasInitRange && ((InterfaceHasInitRange)((Object)prob)).getInitializationRange() != null) {
            range = (int[][])((InterfaceHasInitRange)((Object)prob)).getInitializationRange();
        }
        for (int i = 0; i < this.genotype.length; ++i) {
            this.genotype[i] = RNG.randomInt(range[i][0], range[i][1]);
        }
    }

    @Override
    public String getName() {
        return "ES individual";
    }
}

