/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.individuals.GAIndividualBinaryData;
import eva2.optimization.individuals.GAIndividualDoubleData;
import eva2.optimization.individuals.InterfaceDataTypeBinary;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import eva2.util.annotation.Hidden;
import java.io.Serializable;
import java.util.BitSet;

@Description(value="This is a mixed data type combining a BitSet and a real-valued vector.")
public class GAESIndividualBinaryDoubleData
extends AbstractEAIndividual
implements InterfaceDataTypeBinary,
InterfaceDataTypeDouble,
Serializable {
    private InterfaceDataTypeDouble doubleIndividual = new ESIndividualDoubleData();
    private InterfaceDataTypeBinary binaryIndividual = new GAIndividualBinaryData();

    public GAESIndividualBinaryDoubleData() {
        this.mutationProbability = 1.0;
        this.crossoverProbability = 1.0;
        this.doubleIndividual = new GAIndividualDoubleData();
        this.binaryIndividual = new GAIndividualBinaryData();
    }

    public GAESIndividualBinaryDoubleData(GAESIndividualBinaryDoubleData individual) {
        this.doubleIndividual = (InterfaceDataTypeDouble)((AbstractEAIndividual)((Object)individual.getNumbers())).clone();
        this.binaryIndividual = (InterfaceDataTypeBinary)((AbstractEAIndividual)((Object)individual.getBitSet())).clone();
        this.age = individual.age;
        this.crossoverOperator = individual.crossoverOperator;
        this.crossoverProbability = individual.crossoverProbability;
        this.mutationOperator = (InterfaceMutation)individual.mutationOperator.clone();
        this.mutationProbability = individual.mutationProbability;
        this.selectionProbability = new double[individual.selectionProbability.length];
        System.arraycopy(individual.selectionProbability, 0, this.selectionProbability, 0, this.selectionProbability.length);
        this.fitness = new double[individual.fitness.length];
        System.arraycopy(individual.fitness, 0, this.fitness, 0, this.fitness.length);
        this.cloneAEAObjects(individual);
    }

    @Override
    public Object clone() {
        return new GAESIndividualBinaryDoubleData(this);
    }

    @Override
    public boolean equalGenotypes(AbstractEAIndividual individual) {
        if (individual instanceof GAESIndividualBinaryDoubleData) {
            GAESIndividualBinaryDoubleData indy = (GAESIndividualBinaryDoubleData)individual;
            if (!((AbstractEAIndividual)((Object)this.doubleIndividual)).equalGenotypes((AbstractEAIndividual)((Object)indy.doubleIndividual))) {
                return false;
            }
            return ((AbstractEAIndividual)((Object)this.binaryIndividual)).equalGenotypes((AbstractEAIndividual)((Object)indy.binaryIndividual));
        }
        return false;
    }

    @Override
    public void initialize(InterfaceOptimizationProblem opt) {
        ((AbstractEAIndividual)((Object)this.doubleIndividual)).initialize(opt);
        ((AbstractEAIndividual)((Object)this.binaryIndividual)).initialize(opt);
    }

    @Override
    public void defaultInit(InterfaceOptimizationProblem prob) {
        ((AbstractEAIndividual)((Object)this.doubleIndividual)).defaultInit(prob);
        ((AbstractEAIndividual)((Object)this.binaryIndividual)).defaultInit(prob);
    }

    @Override
    public void initByValue(Object obj, InterfaceOptimizationProblem opt) {
        if (obj instanceof Object[]) {
            if (((Object[])obj)[0] instanceof double[]) {
                ((AbstractEAIndividual)((Object)this.doubleIndividual)).initByValue(((Object[])obj)[0], opt);
                ((AbstractEAIndividual)((Object)this.binaryIndividual)).initByValue(((Object[])obj)[1], opt);
            } else {
                ((AbstractEAIndividual)((Object)this.doubleIndividual)).initByValue(((Object[])obj)[1], opt);
                ((AbstractEAIndividual)((Object)this.binaryIndividual)).initByValue(((Object[])obj)[0], opt);
            }
        } else {
            ((AbstractEAIndividual)((Object)this.doubleIndividual)).initialize(opt);
            ((AbstractEAIndividual)((Object)this.binaryIndividual)).initialize(opt);
            System.out.println("Initial value for GAESIndividualDoubleData is not suitable!");
        }
    }

    @Override
    public void mutate() {
        if (RNG.flipCoin(this.mutationProbability)) {
            ((AbstractEAIndividual)((Object)this.doubleIndividual)).mutate();
        }
        if (RNG.flipCoin(this.mutationProbability)) {
            ((AbstractEAIndividual)((Object)this.binaryIndividual)).mutate();
        }
    }

    @Override
    public void defaultMutate() {
        ((AbstractEAIndividual)((Object)this.doubleIndividual)).defaultMutate();
        ((AbstractEAIndividual)((Object)this.binaryIndividual)).defaultMutate();
    }

    @Override
    public AbstractEAIndividual[] mateWith(Population partners) {
        AbstractEAIndividual[] result;
        if (RNG.flipCoin(this.crossoverProbability)) {
            int i;
            AbstractEAIndividual numTmp = (AbstractEAIndividual)((Object)this.getNumbers());
            Population numPop = new Population();
            for (i = 0; i < partners.size(); ++i) {
                numPop.add((AbstractEAIndividual)((Object)((GAESIndividualBinaryDoubleData)partners.get(i)).getNumbers()));
            }
            AbstractEAIndividual[] resNum = numTmp.mateWith(numPop);
            AbstractEAIndividual binTmp = (AbstractEAIndividual)((Object)this.getBitSet());
            Population binPop = new Population();
            for (i = 0; i < partners.size(); ++i) {
                binPop.add((AbstractEAIndividual)((Object)((GAESIndividualBinaryDoubleData)partners.get(i)).getBitSet()));
            }
            AbstractEAIndividual[] resBin = binTmp.mateWith(binPop);
            result = new GAESIndividualBinaryDoubleData[resNum.length];
            for (i = 0; i < result.length; ++i) {
                result[i] = new GAESIndividualBinaryDoubleData(this);
                ((GAESIndividualBinaryDoubleData)result[i]).setNumbers((InterfaceDataTypeDouble)((Object)resNum[i]));
                ((GAESIndividualBinaryDoubleData)result[i]).setBitSet((InterfaceDataTypeBinary)((Object)resBin[i]));
            }
        } else {
            result = new AbstractEAIndividual[partners.size() + 1];
            result[0] = (AbstractEAIndividual)this.clone();
            for (int i = 0; i < partners.size(); ++i) {
                result[i + 1] = (AbstractEAIndividual)((AbstractEAIndividual)partners.get(i)).clone();
            }
        }
        for (int i = 0; i < result.length; ++i) {
            result[i].giveNewName();
        }
        return result;
    }

    @Override
    public String getStringRepresentation() {
        String result = "This is a hybrid Individual:\n";
        result = result + "The Numbers Part:\n" + ((AbstractEAIndividual)((Object)this.doubleIndividual)).getStringRepresentation();
        result = result + "\nThe Binarys Part:\n" + ((AbstractEAIndividual)((Object)this.binaryIndividual)).getStringRepresentation();
        return result;
    }

    @Override
    public void setDoubleDataLength(int length) {
        this.doubleIndividual.setDoubleDataLength(length);
        this.binaryIndividual.setBinaryDataLength(length);
    }

    @Override
    public int size() {
        return this.doubleIndividual.size();
    }

    @Override
    @Hidden
    public void setDoubleRange(double[][] range) {
        this.doubleIndividual.setDoubleRange(range);
    }

    @Override
    public double[][] getDoubleRange() {
        return this.doubleIndividual.getDoubleRange();
    }

    @Override
    public double[] getDoubleData() {
        return this.doubleIndividual.getDoubleData();
    }

    @Override
    public double[] getDoubleDataWithoutUpdate() {
        return this.doubleIndividual.getDoubleDataWithoutUpdate();
    }

    @Override
    public void setDoublePhenotype(double[] doubleData) {
        this.doubleIndividual.setDoublePhenotype(doubleData);
    }

    @Override
    public void setDoubleGenotype(double[] doubleData) {
        this.doubleIndividual.setDoubleGenotype(doubleData);
    }

    @Override
    public void setBinaryDataLength(int length) {
        this.doubleIndividual.setDoubleDataLength(length);
        this.binaryIndividual.setBinaryDataLength(length);
    }

    public int GetBinaryDataLength() {
        return this.binaryIndividual.size();
    }

    @Override
    public BitSet getBinaryData() {
        return this.binaryIndividual.getBinaryData();
    }

    @Override
    public BitSet getBinaryDataWithoutUpdate() {
        return this.binaryIndividual.getBinaryDataWithoutUpdate();
    }

    @Override
    public void setBinaryPhenotype(BitSet binaryData) {
        this.binaryIndividual.setBinaryPhenotype(binaryData);
    }

    @Override
    public void setBinaryGenotype(BitSet binaryData) {
        this.binaryIndividual.setBinaryGenotype(binaryData);
    }

    @Override
    public String getName() {
        return "GA/ES individual";
    }

    public void setNumbers(InterfaceDataTypeDouble Numbers) {
        this.doubleIndividual = Numbers;
    }

    public InterfaceDataTypeDouble getNumbers() {
        return this.doubleIndividual;
    }

    public String numbersTipText() {
        return "Choose the type of inner binary representation to use.";
    }

    public void setBitSet(InterfaceDataTypeBinary BitSet2) {
        this.binaryIndividual = BitSet2;
    }

    public InterfaceDataTypeBinary getBitSet() {
        return this.binaryIndividual;
    }

    public String bitSetTipText() {
        return "Choose the type of inner real-valued representation to use.";
    }
}

