/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeBinary;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.operator.crossover.CrossoverGAGINPoint;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.operator.mutation.MutateGANBit;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.BitSet;

@Description(value="This is a GA individual suited to optimize binary values.")
public class GAIndividualBinaryData
extends AbstractEAIndividual
implements InterfaceDataTypeBinary,
InterfaceGAIndividual,
Serializable {
    protected BitSet genotype = new BitSet();
    protected BitSet phenotype = new BitSet();
    protected int genotypeLength;

    public GAIndividualBinaryData() {
        this.mutationProbability = 0.1;
        this.mutationOperator = new MutateGANBit();
        this.crossoverProbability = 1.0;
        this.crossoverOperator = new CrossoverGAGINPoint();
        this.genotypeLength = 20;
        this.genotype = new BitSet();
    }

    public GAIndividualBinaryData(int genotypeLen) {
        this();
        this.setBinaryDataLength(genotypeLen);
    }

    public GAIndividualBinaryData(GAIndividualBinaryData individual) {
        if (individual.phenotype != null) {
            this.phenotype = (BitSet)individual.phenotype.clone();
        }
        this.genotypeLength = individual.genotypeLength;
        if (individual.genotype != null) {
            this.genotype = (BitSet)individual.genotype.clone();
        }
        this.age = individual.age;
        this.crossoverOperator = (InterfaceCrossover)individual.crossoverOperator.clone();
        this.crossoverProbability = individual.crossoverProbability;
        this.mutationOperator = (InterfaceMutation)individual.mutationOperator.clone();
        this.mutationProbability = individual.mutationProbability;
        this.selectionProbability = new double[individual.selectionProbability.length];
        System.arraycopy(individual.selectionProbability, 0, this.selectionProbability, 0, this.selectionProbability.length);
        this.fitness = new double[individual.fitness.length];
        System.arraycopy(individual.fitness, 0, this.fitness, 0, this.fitness.length);
        this.cloneAEAObjects(individual);
    }

    @Override
    public Object clone() {
        return new GAIndividualBinaryData(this);
    }

    @Override
    public boolean equalGenotypes(AbstractEAIndividual individual) {
        if (individual instanceof GAIndividualBinaryData) {
            GAIndividualBinaryData indy = (GAIndividualBinaryData)individual;
            if (this.genotypeLength != indy.genotypeLength) {
                return false;
            }
            if (this.genotype == null || indy.genotype == null) {
                return false;
            }
            return this.genotype.equals(indy.genotype);
        }
        return false;
    }

    public double defaultEvaulateAsMiniBits() {
        double result = 0.0;
        for (int i = 0; i < this.genotypeLength; ++i) {
            if (!this.genotype.get(i)) continue;
            result += 1.0;
        }
        return result;
    }

    @Override
    public void initByValue(Object obj, InterfaceOptimizationProblem opt) {
        if (obj instanceof BitSet) {
            BitSet bs = (BitSet)obj;
            this.setBinaryGenotype(bs);
        } else {
            this.defaultInit(opt);
            System.out.println("Initial value for GAIndividualBinaryData is no BitSet!");
        }
        this.mutationOperator.initialize(this, opt);
        this.crossoverOperator.init(this, opt);
    }

    @Override
    public double[] getFitness() {
        return this.fitness;
    }

    @Override
    public String getStringRepresentation() {
        int i;
        String result = "";
        result = result + "GAIndividual: (";
        result = result + "Fitness {";
        for (i = 0; i < this.fitness.length; ++i) {
            result = result + this.fitness[i] + ";";
        }
        result = result + "}/SelProb{";
        for (i = 0; i < this.selectionProbability.length; ++i) {
            result = result + this.selectionProbability[i] + ";";
        }
        result = result + "})\n Value: ";
        result = result + "{";
        for (i = 0; i < this.genotypeLength; ++i) {
            if (i % 8 == 0) {
                result = result + "|";
            }
            result = this.genotype.get(i) ? result + "1" : result + "0";
        }
        result = result + "}";
        result = result + "\n Mutation (" + this.mutationProbability + "):" + this.mutationOperator.getStringRepresentation();
        return result;
    }

    @Override
    public BitSet getBGenotype() {
        return this.genotype;
    }

    @Override
    public void setBGenotype(BitSet binaryData) {
        this.genotype = binaryData;
    }

    @Override
    public int getGenotypeLength() {
        return this.genotypeLength;
    }

    @Override
    public void defaultInit(InterfaceOptimizationProblem prob) {
        for (int i = 0; i < this.genotypeLength; ++i) {
            if (RNG.flipCoin(0.5)) {
                this.genotype.set(i);
                continue;
            }
            this.genotype.clear(i);
        }
    }

    @Override
    public void defaultMutate() {
        int mutationIndex = RNG.randomInt(0, this.genotypeLength);
        if (this.genotype.get(mutationIndex)) {
            this.genotype.clear(mutationIndex);
        } else {
            this.genotype.set(mutationIndex);
        }
    }

    @Override
    public void setBinaryDataLength(int length) {
        this.genotypeLength = length;
    }

    @Override
    public int size() {
        return this.genotypeLength;
    }

    @Override
    public BitSet getBinaryData() {
        this.phenotype = (BitSet)this.genotype.clone();
        return this.phenotype;
    }

    @Override
    public BitSet getBinaryDataWithoutUpdate() {
        return this.phenotype;
    }

    @Override
    public void setBinaryPhenotype(BitSet binaryData) {
        this.phenotype = binaryData;
    }

    @Override
    public void setBinaryGenotype(BitSet binaryData) {
        this.setBinaryPhenotype(binaryData);
        this.genotype = (BitSet)binaryData.clone();
    }

    @Override
    public String getName() {
        return "GA binary individual";
    }
}

