/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.individuals.codings.ga.GAStandardCodingDouble;
import eva2.optimization.individuals.codings.ga.InterfaceGADoubleCoding;
import eva2.optimization.operator.crossover.CrossoverGAGINPoint;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.operator.mutation.MutateGAUniform;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import eva2.util.annotation.Parameter;
import java.io.Serializable;
import java.util.BitSet;

@Description(value="This is a GA individual suited to optimize double values.")
public class GAIndividualDoubleData
extends AbstractEAIndividual
implements InterfaceGAIndividual,
InterfaceDataTypeDouble,
Serializable {
    private double[] phenotype;
    private double[][] initializationRange;
    protected BitSet genotype;
    protected int genotypeLength;
    private int precision = 32;
    private InterfaceGADoubleCoding doubleCoding = new GAStandardCodingDouble();

    public GAIndividualDoubleData() {
        this.mutationProbability = 0.1;
        this.mutationOperator = new MutateGAUniform();
        this.crossoverProbability = 0.7;
        this.crossoverOperator = new CrossoverGAGINPoint();
        this.initializationRange = new double[1][2];
        this.initializationRange[0][0] = -10.0;
        this.initializationRange[0][1] = 10.0;
        this.genotypeLength = this.precision;
        this.genotype = new BitSet();
    }

    public GAIndividualDoubleData(GAIndividualDoubleData individual) {
        if (individual.phenotype != null) {
            this.phenotype = new double[individual.phenotype.length];
            System.arraycopy(individual.phenotype, 0, this.phenotype, 0, this.phenotype.length);
        }
        this.genotypeLength = individual.genotypeLength;
        this.genotype = (BitSet)individual.genotype.clone();
        this.initializationRange = new double[individual.initializationRange.length][2];
        for (int i = 0; i < this.initializationRange.length; ++i) {
            this.initializationRange[i][0] = individual.initializationRange[i][0];
            this.initializationRange[i][1] = individual.initializationRange[i][1];
        }
        this.age = individual.age;
        this.crossoverOperator = (InterfaceCrossover)individual.crossoverOperator.clone();
        this.crossoverProbability = individual.crossoverProbability;
        this.mutationOperator = (InterfaceMutation)individual.mutationOperator.clone();
        this.mutationProbability = individual.mutationProbability;
        this.selectionProbability = new double[individual.selectionProbability.length];
        System.arraycopy(individual.selectionProbability, 0, this.selectionProbability, 0, this.selectionProbability.length);
        this.precision = individual.precision;
        this.doubleCoding = individual.doubleCoding;
        this.fitness = new double[individual.fitness.length];
        System.arraycopy(individual.fitness, 0, this.fitness, 0, this.fitness.length);
        this.cloneAEAObjects(individual);
    }

    @Override
    public Object clone() {
        return new GAIndividualDoubleData(this);
    }

    @Override
    public boolean equalGenotypes(AbstractEAIndividual individual) {
        if (individual instanceof GAIndividualDoubleData) {
            GAIndividualDoubleData indy = (GAIndividualDoubleData)individual;
            if (this.genotypeLength != indy.genotypeLength) {
                return false;
            }
            if (this.genotype == null || indy.genotype == null) {
                return false;
            }
            if (!this.genotype.equals(indy.genotype)) {
                return false;
            }
            for (int i = 0; i < this.initializationRange.length; ++i) {
                if (this.initializationRange[i][0] != indy.initializationRange[i][0]) {
                    return false;
                }
                if (this.initializationRange[i][1] == indy.initializationRange[i][1]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setDoubleDataLength(int length) {
        int i;
        double[] newDesPa = new double[length];
        double[][] newRange = new double[length][2];
        for (i = 0; i < newDesPa.length && i < this.initializationRange.length; ++i) {
            newRange[i][0] = this.initializationRange[i][0];
            newRange[i][1] = this.initializationRange[i][1];
        }
        for (i = this.initializationRange.length; i < newDesPa.length; ++i) {
            newRange[i][0] = this.initializationRange[this.initializationRange.length - 1][0];
            newRange[i][1] = this.initializationRange[this.initializationRange.length - 1][1];
        }
        this.initializationRange = newRange;
        this.genotypeLength = length * this.precision;
    }

    @Override
    public int size() {
        return this.initializationRange.length;
    }

    @Override
    public void setDoubleRange(double[][] range) {
        if (range.length != this.initializationRange.length) {
            System.out.println("Warning: Trying to set a range of length " + range.length + " to a vector of length " + this.initializationRange.length + "!\n Use method setDoubleDataLength first!");
        }
        for (int i = 0; i < this.initializationRange.length && i < range.length; ++i) {
            this.initializationRange[i][0] = range[i][0];
            this.initializationRange[i][1] = range[i][1];
        }
    }

    @Override
    public double[][] getDoubleRange() {
        return this.initializationRange;
    }

    @Override
    public double[] getDoubleData() {
        int[] locus = new int[2];
        this.phenotype = new double[this.initializationRange.length];
        for (int i = 0; i < this.initializationRange.length; ++i) {
            locus[0] = i * this.precision;
            locus[1] = this.precision;
            this.phenotype[i] = this.doubleCoding.decodeValue(this.genotype, this.initializationRange[i], locus, false);
        }
        return this.phenotype;
    }

    @Override
    public double[] getDoubleDataWithoutUpdate() {
        return this.phenotype;
    }

    @Override
    public void setDoublePhenotype(double[] doubleData) {
        this.phenotype = doubleData;
    }

    @Override
    public void setDoubleGenotype(double[] doubleData) {
        this.setDoublePhenotype(doubleData);
        int[] locus = new int[2];
        for (int i = 0; i < doubleData.length; ++i) {
            locus[0] = i * this.precision;
            locus[1] = this.precision;
            this.doubleCoding.codeValue(doubleData[i], this.initializationRange[i], this.genotype, locus);
        }
    }

    @Override
    public void initByValue(Object obj, InterfaceOptimizationProblem opt) {
        if (obj instanceof double[]) {
            double[] bs = (double[])obj;
            if (bs.length != this.initializationRange.length) {
                System.out.println("Init value and requested length doesn't match!");
            }
            this.setDoubleGenotype(bs);
        } else {
            this.defaultInit(opt);
            System.out.println("Initial value for GAIndividualDoubleData is not double[]!");
        }
        this.mutationOperator.initialize(this, opt);
        this.crossoverOperator.init(this, opt);
    }

    @Override
    public String getStringRepresentation() {
        int i;
        int i2;
        String result = "";
        result = result + "GAIndividual coding double: (";
        result = result + "Fitness {";
        for (i2 = 0; i2 < this.fitness.length; ++i2) {
            result = result + this.fitness[i2] + ";";
        }
        result = result + "}/SelProb{";
        for (i2 = 0; i2 < this.selectionProbability.length; ++i2) {
            result = result + this.selectionProbability[i2] + ";";
        }
        result = result + "})\n Value: ";
        result = result + "[";
        double[] d = this.getDoubleData();
        for (i = 0; i < d.length; ++i) {
            result = result + d[i] + "; ";
        }
        result = result + "]\n";
        result = result + "{";
        for (i = 0; i < this.genotypeLength; ++i) {
            result = this.genotype.get(i) ? result + "1" : result + "0";
        }
        result = result + "}";
        return result;
    }

    @Override
    public BitSet getBGenotype() {
        return this.genotype;
    }

    @Override
    public void setBGenotype(BitSet binaryData) {
        this.genotype = binaryData;
    }

    @Override
    public int getGenotypeLength() {
        return this.genotypeLength;
    }

    @Override
    public void defaultInit(InterfaceOptimizationProblem prob) {
        for (int i = 0; i < this.genotypeLength; ++i) {
            if (RNG.flipCoin(0.5)) {
                this.genotype.set(i);
                continue;
            }
            this.genotype.clear(i);
        }
    }

    @Override
    public void defaultMutate() {
        int mutationIndex = RNG.randomInt(0, this.genotypeLength);
        if (this.genotype.get(mutationIndex)) {
            this.genotype.clear(mutationIndex);
        } else {
            this.genotype.set(mutationIndex);
        }
    }

    @Override
    public String getName() {
        return "GA individual";
    }

    @Parameter(name="coding", description="Choose the coding to use.")
    public void setGACoding(InterfaceGADoubleCoding coding) {
        this.doubleCoding = coding;
    }

    public InterfaceGADoubleCoding getGACoding() {
        return this.doubleCoding;
    }

    @Parameter(description="Gives the number of bits to be used to code a double.")
    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getPrecision() {
        return this.precision;
    }
}

