/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeInteger;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.individuals.codings.ga.GAStandardCodingInteger;
import eva2.optimization.individuals.codings.ga.InterfaceGAIntegerCoding;
import eva2.optimization.operator.crossover.CrossoverGAGINPoint;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.operator.mutation.MutateGANBit;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.BitSet;

@Description(value="This is a GA individual suited to optimize int values.")
public class GAIndividualIntegerData
extends AbstractEAIndividual
implements InterfaceGAIndividual,
InterfaceDataTypeInteger,
Serializable {
    private int[] phenotype;
    private int[][] range;
    protected BitSet genotype;
    protected int[] codingLengths;
    private InterfaceGAIntegerCoding intergerCoding = new GAStandardCodingInteger();

    public GAIndividualIntegerData() {
        this.mutationProbability = 0.2;
        this.mutationOperator = new MutateGANBit();
        this.crossoverProbability = 0.7;
        this.crossoverOperator = new CrossoverGAGINPoint();
        this.range = new int[1][2];
        this.codingLengths = new int[1];
        this.codingLengths[0] = 3;
        this.range[0][0] = 0;
        this.range[0][1] = 7;
        this.genotype = new BitSet();
    }

    public GAIndividualIntegerData(GAIndividualIntegerData individual) {
        if (individual.phenotype != null) {
            this.phenotype = new int[individual.phenotype.length];
            System.arraycopy(individual.phenotype, 0, this.phenotype, 0, this.phenotype.length);
        }
        this.genotype = (BitSet)individual.genotype.clone();
        this.range = new int[individual.range.length][2];
        this.codingLengths = new int[individual.codingLengths.length];
        for (int i = 0; i < this.range.length; ++i) {
            this.codingLengths[i] = individual.codingLengths[i];
            this.range[i][0] = individual.range[i][0];
            this.range[i][1] = individual.range[i][1];
        }
        this.age = individual.age;
        this.crossoverOperator = individual.crossoverOperator;
        this.crossoverProbability = individual.crossoverProbability;
        this.mutationOperator = (InterfaceMutation)individual.mutationOperator.clone();
        this.mutationProbability = individual.mutationProbability;
        this.selectionProbability = new double[individual.selectionProbability.length];
        System.arraycopy(individual.selectionProbability, 0, this.selectionProbability, 0, this.selectionProbability.length);
        this.intergerCoding = individual.intergerCoding;
        this.fitness = new double[individual.fitness.length];
        System.arraycopy(individual.fitness, 0, this.fitness, 0, this.fitness.length);
        this.cloneAEAObjects(individual);
    }

    @Override
    public Object clone() {
        return new GAIndividualIntegerData(this);
    }

    @Override
    public boolean equalGenotypes(AbstractEAIndividual individual) {
        if (individual instanceof GAIndividualIntegerData) {
            GAIndividualIntegerData indy = (GAIndividualIntegerData)individual;
            if (this.genotype == null || indy.genotype == null) {
                return false;
            }
            if (!this.genotype.equals(indy.genotype)) {
                return false;
            }
            if (this.range.length != indy.range.length) {
                return false;
            }
            for (int i = 0; i < this.range.length; ++i) {
                if (this.range[i][0] != indy.range[i][0]) {
                    return false;
                }
                if (this.range[i][1] == indy.range[i][1]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setIntegerDataLength(int length) {
        int i;
        int[] newDesPa = new int[length];
        int[][] newRange = new int[length][2];
        for (i = 0; i < newDesPa.length && i < this.range.length; ++i) {
            newRange[i][0] = this.range[i][0];
            newRange[i][1] = this.range[i][1];
        }
        for (i = this.range.length; i < newDesPa.length; ++i) {
            newRange[i][0] = this.range[this.range.length - 1][0];
            newRange[i][1] = this.range[this.range.length - 1][1];
        }
        this.range = newRange;
        this.codingLengths = new int[this.range.length];
        for (i = 0; i < this.range.length; ++i) {
            this.codingLengths[i] = this.intergerCoding.calculateNecessaryBits(this.range[i]);
        }
    }

    @Override
    public int size() {
        return this.range.length;
    }

    @Override
    public void setIntRange(int[][] range) {
        if (range.length != this.range.length) {
            System.out.println("Warning: Trying to set a range of length " + range.length + " to a vector of length " + this.range.length + "!\n Use method setDoubleDataLength first!");
        }
        for (int i = 0; i < this.range.length && i < range.length; ++i) {
            this.range[i][0] = range[i][0];
            this.range[i][1] = range[i][1];
        }
        this.setIntegerDataLength(range.length);
    }

    public void SetIntRange(int lower, int upper) {
        for (int i = 0; i < this.range.length; ++i) {
            this.setIntRange(i, lower, upper);
            this.codingLengths[i] = this.intergerCoding.calculateNecessaryBits(this.range[i]);
        }
    }

    public void setIntRange(int index, int lower, int upper) {
        this.range[index][0] = lower;
        this.range[index][1] = upper;
        this.codingLengths[index] = this.intergerCoding.calculateNecessaryBits(this.range[index]);
    }

    @Override
    public int[][] getIntRange() {
        return this.range;
    }

    @Override
    public int[] getIntegerData() {
        int[] locus = new int[]{0, 0};
        this.phenotype = new int[this.range.length];
        for (int i = 0; i < this.phenotype.length; ++i) {
            locus[0] = locus[0] + locus[1];
            locus[1] = this.codingLengths[i];
            this.phenotype[i] = this.intergerCoding.decodeValue(this.genotype, this.range[i], locus, false);
        }
        return this.phenotype;
    }

    @Override
    public int[] getIntegerDataWithoutUpdate() {
        return this.phenotype;
    }

    @Override
    public void setIntPhenotype(int[] doubleData) {
        this.phenotype = doubleData;
    }

    @Override
    public void setIntGenotype(int[] doubleData) {
        this.setIntPhenotype(doubleData);
        if (doubleData != null) {
            int[] locus = new int[]{0, 0};
            for (int i = 0; i < doubleData.length; ++i) {
                locus[0] = locus[0] + locus[1];
                locus[1] = this.codingLengths[i];
                this.intergerCoding.codeValue(doubleData[i], this.range[i], this.genotype, locus);
            }
        }
    }

    @Override
    public void initByValue(Object obj, InterfaceOptimizationProblem opt) {
        if (obj instanceof int[]) {
            int[] bs = (int[])obj;
            if (bs.length != this.range.length) {
                System.out.println("Init value and requested length doesn't match!");
            }
            this.setIntGenotype(bs);
        } else {
            this.defaultInit(opt);
            System.out.println("Initial value for GAIndividualDoubleData is not double[]!");
        }
        this.mutationOperator.initialize(this, opt);
        this.crossoverOperator.init(this, opt);
    }

    @Override
    public String getStringRepresentation() {
        int i;
        int i2;
        int i3;
        String result = "";
        result = result + "GAIndividual coding int: (";
        result = result + "Fitness {";
        for (i3 = 0; i3 < this.fitness.length; ++i3) {
            result = result + this.fitness[i3] + ";";
        }
        result = result + "}/SelProb{";
        for (i3 = 0; i3 < this.selectionProbability.length; ++i3) {
            result = result + this.selectionProbability[i3] + ";";
        }
        result = result + "})\n Value: ";
        result = result + "[";
        int[] d = this.getIntegerData();
        for (i2 = 0; i2 < d.length; ++i2) {
            result = result + d[i2] + "; ";
        }
        result = result + "]\n";
        result = result + "CodingRange:  [";
        for (i2 = 0; i2 < this.range.length; ++i2) {
            result = result + "(" + this.range[i2][0] + "; " + this.range[i2][1] + "); ";
        }
        result = result + "]\n";
        result = result + "CodingLength: [";
        for (i2 = 0; i2 < this.codingLengths.length; ++i2) {
            result = result + this.codingLengths[i2] + "; ";
        }
        result = result + "]\n";
        result = result + "{";
        int overallLength = 0;
        for (i = 0; i < this.codingLengths.length; ++i) {
            overallLength += this.codingLengths[i];
        }
        for (i = 0; i < overallLength; ++i) {
            result = this.genotype.get(i) ? result + "1" : result + "0";
        }
        result = result + "}";
        return result;
    }

    @Override
    public BitSet getBGenotype() {
        return this.genotype;
    }

    @Override
    public void setBGenotype(BitSet binaryData) {
        this.genotype = binaryData;
    }

    @Override
    public int getGenotypeLength() {
        int overallLength = 0;
        for (int codingLength : this.codingLengths) {
            overallLength += codingLength;
        }
        return overallLength;
    }

    @Override
    public void defaultInit(InterfaceOptimizationProblem prob) {
        int overallLength = 0;
        for (int codingLength : this.codingLengths) {
            overallLength += codingLength;
        }
        for (int i = 0; i < overallLength; ++i) {
            if (RNG.flipCoin(0.5)) {
                this.genotype.set(i);
                continue;
            }
            this.genotype.clear(i);
        }
    }

    @Override
    public void defaultMutate() {
        int overallLength = 0;
        for (int codingLength : this.codingLengths) {
            overallLength += codingLength;
        }
        int mutationIndex = RNG.randomInt(0, overallLength);
        if (this.genotype.get(mutationIndex)) {
            this.genotype.clear(mutationIndex);
        } else {
            this.genotype.set(mutationIndex);
        }
    }

    public static void main(String[] args) {
        int i;
        System.out.println("Test this stuff!");
        GAIndividualIntegerData indy = new GAIndividualIntegerData();
        int dimension = 10;
        int[][] range = new int[dimension][2];
        for (int i2 = 0; i2 < dimension; ++i2) {
            range[i2][0] = 0;
            range[i2][1] = i2 + 1;
        }
        indy.setIntegerDataLength(dimension);
        indy.setIntRange(range);
        indy.defaultInit(null);
        System.out.println("" + indy.getStringRepresentation());
        System.out.println("System.exit(0)");
        int[] data = indy.getIntegerData();
        String tmp = "Before {";
        for (int aData : data) {
            tmp = tmp + aData + "; ";
        }
        System.out.println(tmp + "}");
        tmp = "Setting {";
        for (i = 0; i < data.length; ++i) {
            data[i] = RNG.randomInt(range[i][0], range[i][1]);
            tmp = tmp + data[i] + "; ";
        }
        System.out.println(tmp + "}");
        indy.setIntGenotype(data);
        System.out.println("" + indy.getStringRepresentation());
        data = indy.getIntegerData();
        tmp = "After {";
        for (i = 0; i < data.length; ++i) {
            tmp = tmp + data[i] + "; ";
        }
        System.out.println(tmp + "}");
    }

    @Override
    public String getName() {
        return "GA individual";
    }

    public void setGACoding(InterfaceGAIntegerCoding coding) {
        this.intergerCoding = coding;
    }

    public InterfaceGAIntegerCoding getGACoding() {
        return this.intergerCoding;
    }

    public String gAIntegerCodingTipText() {
        return "Choose the coding to use.";
    }
}

