/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.individuals.GAIndividualDoubleData;
import eva2.optimization.individuals.GPIndividualProgramData;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.individuals.InterfaceDataTypeProgram;
import eva2.optimization.individuals.codings.gp.InterfaceProgram;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import java.io.Serializable;

public class GAPIndividualProgramData
extends AbstractEAIndividual
implements InterfaceDataTypeProgram,
InterfaceDataTypeDouble,
Serializable {
    private InterfaceDataTypeDouble numberData = new ESIndividualDoubleData();
    private InterfaceDataTypeProgram programData = new GPIndividualProgramData();

    public GAPIndividualProgramData() {
        this.mutationProbability = 1.0;
        this.crossoverProbability = 1.0;
        this.numberData = new GAIndividualDoubleData();
        this.programData = new GPIndividualProgramData();
    }

    public GAPIndividualProgramData(GAPIndividualProgramData individual) {
        this.numberData = (InterfaceDataTypeDouble)((AbstractEAIndividual)((Object)individual.getNumbers())).clone();
        this.programData = (InterfaceDataTypeProgram)((AbstractEAIndividual)((Object)individual.getProgramRepresentation())).clone();
        this.age = individual.age;
        this.crossoverOperator = individual.crossoverOperator;
        this.crossoverProbability = individual.crossoverProbability;
        this.mutationOperator = (InterfaceMutation)individual.mutationOperator.clone();
        this.mutationProbability = individual.mutationProbability;
        this.selectionProbability = new double[individual.selectionProbability.length];
        System.arraycopy(individual.selectionProbability, 0, this.selectionProbability, 0, this.selectionProbability.length);
        this.fitness = new double[individual.fitness.length];
        System.arraycopy(individual.fitness, 0, this.fitness, 0, this.fitness.length);
        this.cloneAEAObjects(individual);
    }

    @Override
    public Object clone() {
        return new GAPIndividualProgramData(this);
    }

    @Override
    public boolean equalGenotypes(AbstractEAIndividual individual) {
        if (individual instanceof GAPIndividualProgramData) {
            GAPIndividualProgramData indy = (GAPIndividualProgramData)individual;
            if (!((AbstractEAIndividual)((Object)this.numberData)).equalGenotypes((AbstractEAIndividual)((Object)indy.numberData))) {
                return false;
            }
            return ((AbstractEAIndividual)((Object)this.programData)).equalGenotypes((AbstractEAIndividual)((Object)indy.programData));
        }
        return false;
    }

    @Override
    public void initialize(InterfaceOptimizationProblem opt) {
        ((AbstractEAIndividual)((Object)this.numberData)).initialize(opt);
        ((AbstractEAIndividual)((Object)this.programData)).initialize(opt);
    }

    @Override
    public void defaultInit(InterfaceOptimizationProblem prob) {
        ((AbstractEAIndividual)((Object)this.numberData)).defaultInit(prob);
        ((AbstractEAIndividual)((Object)this.programData)).defaultInit(prob);
    }

    @Override
    public void initByValue(Object obj, InterfaceOptimizationProblem opt) {
        if (obj instanceof Object[]) {
            if (((Object[])obj)[0] instanceof double[]) {
                ((AbstractEAIndividual)((Object)this.numberData)).initByValue(((Object[])obj)[0], opt);
                ((AbstractEAIndividual)((Object)this.programData)).initByValue(((Object[])obj)[1], opt);
            } else {
                ((AbstractEAIndividual)((Object)this.numberData)).initByValue(((Object[])obj)[1], opt);
                ((AbstractEAIndividual)((Object)this.programData)).initByValue(((Object[])obj)[0], opt);
            }
        } else {
            ((AbstractEAIndividual)((Object)this.numberData)).initialize(opt);
            ((AbstractEAIndividual)((Object)this.programData)).initialize(opt);
            System.out.println("Initial value for GAPIndividualDoubleData is not suitable!");
        }
    }

    @Override
    public void mutate() {
        if (RNG.flipCoin(this.mutationProbability)) {
            ((AbstractEAIndividual)((Object)this.numberData)).mutate();
        }
        if (RNG.flipCoin(this.mutationProbability)) {
            ((AbstractEAIndividual)((Object)this.programData)).mutate();
        }
    }

    @Override
    public void defaultMutate() {
        ((AbstractEAIndividual)((Object)this.numberData)).defaultMutate();
        ((AbstractEAIndividual)((Object)this.programData)).defaultMutate();
    }

    @Override
    public AbstractEAIndividual[] mateWith(Population partners) {
        AbstractEAIndividual[] result;
        if (RNG.flipCoin(this.crossoverProbability)) {
            int i;
            AbstractEAIndividual numTmp = (AbstractEAIndividual)((Object)this.getNumbers());
            Population numPop = new Population();
            for (i = 0; i < partners.size(); ++i) {
                numPop.add((AbstractEAIndividual)((Object)((GAPIndividualProgramData)partners.get(i)).getNumbers()));
            }
            AbstractEAIndividual[] resNum = numTmp.mateWith(numPop);
            AbstractEAIndividual binTmp = (AbstractEAIndividual)((Object)this.getProgramRepresentation());
            Population binPop = new Population();
            for (i = 0; i < partners.size(); ++i) {
                binPop.add((AbstractEAIndividual)((Object)((GAPIndividualProgramData)partners.get(i)).getProgramRepresentation()));
            }
            AbstractEAIndividual[] resBin = binTmp.mateWith(binPop);
            result = new GAPIndividualProgramData[resNum.length];
            for (i = 0; i < result.length; ++i) {
                result[i] = new GAPIndividualProgramData(this);
                ((GAPIndividualProgramData)result[i]).setNumbers((InterfaceDataTypeDouble)((Object)resNum[i]));
                ((GAPIndividualProgramData)result[i]).setProgramRepresentation((InterfaceDataTypeProgram)((Object)resBin[i]));
            }
        } else {
            result = new AbstractEAIndividual[partners.size() + 1];
            result[0] = (AbstractEAIndividual)this.clone();
            for (int i = 0; i < partners.size(); ++i) {
                result[i + 1] = (AbstractEAIndividual)((AbstractEAIndividual)partners.get(i)).clone();
            }
        }
        for (int i = 0; i < result.length; ++i) {
            result[i].giveNewName();
        }
        return result;
    }

    @Override
    public String getStringRepresentation() {
        String result = "This is a hybrid Individual:\n";
        result = result + "The Numbers Part:\n" + ((AbstractEAIndividual)((Object)this.numberData)).getStringRepresentation();
        result = result + "\nThe Binarys Part:\n" + ((AbstractEAIndividual)((Object)this.programData)).getStringRepresentation();
        return result;
    }

    @Override
    public void setDoubleDataLength(int length) {
        this.numberData.setDoubleDataLength(length);
    }

    @Override
    public int size() {
        return this.numberData.size();
    }

    @Override
    public void setDoubleRange(double[][] range) {
        this.numberData.setDoubleRange(range);
    }

    @Override
    public double[][] getDoubleRange() {
        return this.numberData.getDoubleRange();
    }

    @Override
    public double[] getDoubleData() {
        return this.numberData.getDoubleData();
    }

    @Override
    public double[] getDoubleDataWithoutUpdate() {
        return this.numberData.getDoubleDataWithoutUpdate();
    }

    @Override
    public void setDoublePhenotype(double[] doubleData) {
        this.numberData.setDoublePhenotype(doubleData);
    }

    @Override
    public void setDoubleGenotype(double[] doubleData) {
        this.numberData.setDoubleGenotype(doubleData);
    }

    @Override
    public void setProgramDataLength(int length) {
        this.programData.setProgramDataLength(length);
    }

    @Override
    public InterfaceProgram[] getProgramData() {
        return this.programData.getProgramData();
    }

    @Override
    public InterfaceProgram[] getProgramDataWithoutUpdate() {
        return this.programData.getProgramDataWithoutUpdate();
    }

    @Override
    public void SetProgramPhenotype(InterfaceProgram[] program) {
        this.programData.SetProgramPhenotype(program);
    }

    @Override
    public void SetProgramGenotype(InterfaceProgram[] program) {
        this.programData.SetProgramGenotype(program);
    }

    @Override
    public void SetFunctionArea(Object[] area) {
        this.programData.SetFunctionArea(area);
    }

    @Override
    public Object[] getFunctionArea() {
        return this.programData.getFunctionArea();
    }

    @Override
    public String getName() {
        return "GAP individual";
    }

    public void setNumbers(InterfaceDataTypeDouble Numbers) {
        this.numberData = Numbers;
    }

    public InterfaceDataTypeDouble getNumbers() {
        return this.numberData;
    }

    public String numbersTipText() {
        return "Choose the type of inner constants to use.";
    }

    public void setProgramRepresentation(InterfaceDataTypeProgram program) {
        this.programData = program;
    }

    public InterfaceDataTypeProgram getProgramRepresentation() {
        return this.programData;
    }

    public String programRepresentationTipText() {
        return "Choose the type of inner constants to use.";
    }
}

