/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeProgram;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.individuals.codings.gp.AbstractGPNode;
import eva2.optimization.individuals.codings.gp.GPArea;
import eva2.optimization.individuals.codings.gp.InterfaceProgram;
import eva2.optimization.operator.crossover.CrossoverGADefault;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.operator.mutation.MutateDefault;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;

@Description(value="This is a GE individual suited to optimize programs.")
public class GEIndividualProgramData
extends AbstractEAIndividual
implements InterfaceGAIndividual,
InterfaceDataTypeProgram,
Serializable {
    protected GPArea[] gpAreas;
    protected double initFullGrowRatio = 0.5;
    protected int initDepth = 5;
    protected int targetDepth = 10;
    protected boolean checkTargetDepth = true;
    protected BitSet genotype;
    protected AbstractGPNode[] phenotype;
    protected int genotypeLengthPerProgram = 240;
    protected int maxNumberOfNodes = 80;
    protected int numberOfBitPerInt = 6;
    protected int currentIndex = 0;
    protected int currentNumberOfNodes = 0;
    protected Object[][] rules;

    public GEIndividualProgramData() {
        this.gpAreas = new GPArea[1];
        this.genotypeLengthPerProgram = 240;
        this.genotype = new BitSet();
        this.mutationOperator = new MutateDefault();
        this.crossoverOperator = new CrossoverGADefault();
        this.mutationProbability = 0.5;
        this.crossoverProbability = 0.5;
    }

    public GEIndividualProgramData(GEIndividualProgramData individual) {
        int i;
        if (individual.phenotype != null) {
            this.phenotype = new AbstractGPNode[individual.phenotype.length];
            for (i = 0; i < individual.phenotype.length; ++i) {
                this.phenotype[i] = (AbstractGPNode)individual.phenotype[i].clone();
            }
        }
        this.genotypeLengthPerProgram = individual.genotypeLengthPerProgram;
        this.maxNumberOfNodes = individual.maxNumberOfNodes;
        this.numberOfBitPerInt = individual.numberOfBitPerInt;
        this.currentIndex = individual.currentIndex;
        if (individual.genotype != null) {
            this.genotype = (BitSet)individual.genotype.clone();
        }
        if (individual.gpAreas != null) {
            this.gpAreas = new GPArea[individual.gpAreas.length];
            for (i = 0; i < this.gpAreas.length; ++i) {
                this.gpAreas[i] = (GPArea)individual.gpAreas[i].clone();
            }
        }
        if (individual.rules != null) {
            this.rules = new Object[individual.rules.length][];
            for (int t = 0; t < this.rules.length; ++t) {
                this.rules[t] = new Object[individual.rules[t].length];
                int[][] orgRulz = (int[][])individual.rules[t][0];
                int[][] copyRulz = new int[orgRulz.length][];
                for (int i2 = 0; i2 < copyRulz.length; ++i2) {
                    copyRulz[i2] = new int[orgRulz[i2].length];
                    System.arraycopy(orgRulz[i2], 0, copyRulz[i2], 0, orgRulz[i2].length);
                }
                this.rules[t][0] = copyRulz;
                for (int i3 = 1; i3 < this.rules[t].length; ++i3) {
                    AbstractGPNode[] orgNode = (AbstractGPNode[])individual.rules[t][i3];
                    AbstractGPNode[] copyNode = new AbstractGPNode[orgNode.length];
                    for (int j = 0; j < orgNode.length; ++j) {
                        copyNode[j] = (AbstractGPNode)orgNode[j].clone();
                    }
                    this.rules[t][i3] = copyNode;
                }
            }
        }
        this.age = individual.age;
        this.crossoverOperator = individual.crossoverOperator;
        this.crossoverProbability = individual.crossoverProbability;
        this.mutationOperator = (InterfaceMutation)individual.mutationOperator.clone();
        this.mutationProbability = individual.mutationProbability;
        this.selectionProbability = new double[individual.selectionProbability.length];
        System.arraycopy(individual.selectionProbability, 0, this.selectionProbability, 0, this.selectionProbability.length);
        this.fitness = new double[individual.fitness.length];
        System.arraycopy(individual.fitness, 0, this.fitness, 0, this.fitness.length);
        this.cloneAEAObjects(individual);
    }

    @Override
    public Object clone() {
        return new GEIndividualProgramData(this);
    }

    @Override
    public boolean equalGenotypes(AbstractEAIndividual individual) {
        if (individual instanceof GEIndividualProgramData) {
            GEIndividualProgramData indy = (GEIndividualProgramData)individual;
            if (this.genotypeLengthPerProgram != indy.genotypeLengthPerProgram) {
                return false;
            }
            if (this.maxNumberOfNodes != indy.maxNumberOfNodes) {
                return false;
            }
            if (this.numberOfBitPerInt != indy.numberOfBitPerInt) {
                return false;
            }
            if (this.genotype == null || indy.genotype == null) {
                return false;
            }
            return this.genotype.equals(indy.genotype);
        }
        return false;
    }

    private void compileArea() {
        if (this.gpAreas == null) {
            this.rules = null;
            return;
        }
        for (int t = 0; t < this.gpAreas.length; ++t) {
            int i;
            int maxArity = 0;
            this.gpAreas[t].compileReducedList();
            ArrayList<AbstractGPNode> area = this.gpAreas[t].getReducedList();
            for (int i2 = 0; i2 < area.size(); ++i2) {
                int arity = area.get(i2).getArity();
                if (arity <= maxArity) continue;
                maxArity = arity;
            }
            ArrayList[] directList = new ArrayList[maxArity + 1];
            for (i = 0; i < directList.length; ++i) {
                directList[i] = new ArrayList();
            }
            for (i = 0; i < area.size(); ++i) {
                directList[area.get(i).getArity()].add(area.get(i));
            }
            this.rules[t] = new Object[maxArity + 2];
            int numberOfRules = 0;
            int index = 0;
            int[][] tmpExpr = new int[directList.length + 1][];
            for (int i3 = 0; i3 < directList.length; ++i3) {
                int[] tmpRule = new int[i3 + 1];
                if (i3 == 0) {
                    tmpRule[0] = 1;
                } else if (directList[i3].size() > 0) {
                    tmpRule[0] = i3 + 1;
                    for (int j = 1; j < i3 + 1; ++j) {
                        tmpRule[j] = 0;
                    }
                } else {
                    tmpRule = null;
                }
                tmpExpr[i3] = tmpRule;
                if (tmpRule == null) continue;
                ++numberOfRules;
            }
            int[][] trueExpr = new int[numberOfRules][];
            for (int i4 = 0; i4 < tmpExpr.length; ++i4) {
                if (tmpExpr[i4] == null) continue;
                trueExpr[index] = tmpExpr[i4];
                ++index;
            }
            this.rules[t][0] = trueExpr;
            for (int i5 = 0; i5 < directList.length; ++i5) {
                AbstractGPNode[] tmpListOfGPNodes = new AbstractGPNode[directList[i5].size()];
                for (int j = 0; j < directList[i5].size(); ++j) {
                    tmpListOfGPNodes[j] = (AbstractGPNode)directList[i5].get(j);
                }
                this.rules[t][i5 + 1] = tmpListOfGPNodes;
            }
        }
    }

    private void printRuleSet() {
        String result = "";
        for (int t = 0; t < this.gpAreas.length; ++t) {
            int i;
            result = result + "N \t := \t{";
            for (int i2 = 0; i2 < this.rules[t].length; ++i2) {
                if (i2 == 0) {
                    result = result + "expr, ";
                    continue;
                }
                if (i2 == 1) {
                    result = result + "var, ";
                    continue;
                }
                if (((AbstractGPNode[])this.rules[t][i2]).length <= 0) continue;
                result = result + "op" + (i2 - 1) + ", ";
            }
            result = result + "}\n";
            result = result + "T \t := \t{";
            this.gpAreas[t].compileReducedList();
            ArrayList<AbstractGPNode> area = this.gpAreas[t].getReducedList();
            for (i = 0; i < area.size(); ++i) {
                result = result + area.get(i).getStringRepresentation() + ", ";
            }
            result = result + "}\n";
            result = result + "S \t := \t<expr>\n\n";
            for (i = 0; i < this.rules[t].length; ++i) {
                AbstractGPNode[] tmpNodes;
                if (i == 0) {
                    result = result + "0. \t := \t<expr> \t::\t";
                    System.out.println("i: " + i);
                    int[][] rulz = (int[][])this.rules[t][i];
                    for (int j = 0; j < rulz.length; ++j) {
                        result = result + this.getRuleString(rulz[j]) + "\n";
                        if (j + 1 >= rulz.length) continue;
                        result = result + "\t \t \t \t \t \t";
                    }
                    continue;
                }
                if (i == 1) {
                    tmpNodes = (AbstractGPNode[])this.rules[t][i];
                    result = result + "1. \t := \t<var> \t::\t" + tmpNodes[0].getStringRepresentation() + "\n";
                    for (int j = 1; j < tmpNodes.length; ++j) {
                        result = result + "\t \t \t \t \t \t" + tmpNodes[j].getStringRepresentation() + "\n";
                    }
                    continue;
                }
                tmpNodes = (AbstractGPNode[])this.rules[t][i];
                if (tmpNodes.length <= 0) continue;
                result = result + i + ". \t := \t<op" + (i - 1) + "> \t::\t" + tmpNodes[0].getStringRepresentation() + "\n";
                for (int j = 1; j < tmpNodes.length; ++j) {
                    result = result + "\t \t \t \t \t \t" + tmpNodes[j].getStringRepresentation() + "\n";
                }
            }
            result = result + "\n";
        }
        System.out.println("" + result);
    }

    private String getBitSetString() {
        String result = "";
        result = result + "{";
        for (int i = 0; i < this.genotypeLengthPerProgram * this.gpAreas.length; ++i) {
            if (i % this.numberOfBitPerInt == 0) {
                result = result + " ";
            }
            result = this.genotype.get(i) ? result + "1" : result + "0";
        }
        result = result + "}";
        return result;
    }

    private String getRuleString(int[] rule) {
        String result = "";
        for (int k = 0; k < rule.length; ++k) {
            if (rule[k] == 0) {
                result = result + "<expr> ";
            }
            if (rule[k] == 1) {
                result = result + "<var> ";
            }
            if (rule[k] <= 1) continue;
            result = result + "<op" + (rule[k] - 1) + "> ";
        }
        return result;
    }

    @Override
    public void setProgramDataLength(int length) {
        int j;
        AbstractGPNode[] orgNode;
        int i;
        int i2;
        int[][] copyRulz;
        int[][] orgRulz;
        int t;
        GPArea[] oldArea = this.gpAreas;
        Object[][] oldRulz = this.rules;
        this.gpAreas = new GPArea[length];
        for (t = 0; t < this.gpAreas.length && t < oldArea.length; ++t) {
            this.gpAreas[t] = oldArea[t];
        }
        for (t = oldArea.length; t < this.gpAreas.length; ++t) {
            this.gpAreas[t] = oldArea[oldArea.length - 1];
        }
        this.rules = new Object[length][];
        if (oldRulz == null) {
            return;
        }
        for (t = 0; t < this.gpAreas.length && t < oldArea.length; ++t) {
            if (oldRulz[t] == null) continue;
            this.rules[t] = new Object[oldRulz[t].length];
            orgRulz = (int[][])oldRulz[t][0];
            copyRulz = new int[orgRulz.length][];
            for (i2 = 0; i2 < copyRulz.length; ++i2) {
                copyRulz[i2] = new int[orgRulz[i2].length];
                System.arraycopy(orgRulz[i2], 0, copyRulz[i2], 0, orgRulz[i2].length);
            }
            this.rules[t][0] = copyRulz;
            for (i = 1; i < this.rules[t].length; ++i) {
                orgNode = (AbstractGPNode[])oldRulz[t][i];
                AbstractGPNode[] copyNode = new AbstractGPNode[orgNode.length];
                for (j = 0; j < orgNode.length; ++j) {
                    copyNode[j] = (AbstractGPNode)orgNode[j].clone();
                }
                this.rules[t][i] = copyNode;
            }
        }
        for (t = oldArea.length; t < this.gpAreas.length; ++t) {
            if (oldRulz[oldArea.length - 1] == null) continue;
            this.rules[t] = new Object[oldRulz[oldArea.length - 1].length];
            orgRulz = (int[][])oldRulz[oldArea.length - 1][0];
            copyRulz = new int[orgRulz.length][];
            for (i2 = 0; i2 < copyRulz.length; ++i2) {
                copyRulz[i2] = new int[orgRulz[i2].length];
                System.arraycopy(orgRulz[i2], 0, copyRulz[i2], 0, orgRulz[i2].length);
            }
            this.rules[t][0] = copyRulz;
            for (i = 1; i < this.rules[t].length; ++i) {
                orgNode = (AbstractGPNode[])oldRulz[oldArea.length - 1][i];
                AbstractGPNode[] copyNode = new AbstractGPNode[orgNode.length];
                for (j = 0; j < orgNode.length; ++j) {
                    copyNode[j] = (AbstractGPNode)orgNode[j].clone();
                }
                this.rules[t][i] = copyNode;
            }
        }
    }

    private int decodeNextInt(int t) {
        int result = 0;
        for (int i = 0; i < this.numberOfBitPerInt; ++i) {
            if (this.genotype.get(this.currentIndex + t * this.genotypeLengthPerProgram)) {
                result = (int)((double)result + Math.pow(2.0, i));
            }
            ++this.currentIndex;
            if (this.currentIndex < (t + 1) * this.genotypeLengthPerProgram) continue;
            this.currentIndex = t * this.genotypeLengthPerProgram;
        }
        return result;
    }

    private AbstractGPNode decodeGPNode(int t, int mode) {
        AbstractGPNode result = null;
        int value = this.decodeNextInt(t);
        if (mode == 0) {
            int[][] rulz = (int[][])this.rules[t][0];
            int[] myRule = rulz[value % rulz.length];
            this.currentNumberOfNodes += myRule.length;
            if (this.currentNumberOfNodes + myRule.length > this.maxNumberOfNodes) {
                myRule = rulz[0];
            }
            result = this.decodeGPNode(t, myRule[0]);
            result.initNodeArray();
            for (int i = 0; i < result.getArity(); ++i) {
                result.setNode(this.decodeGPNode(t, myRule[i + 1]), i);
            }
        } else {
            AbstractGPNode[] availableNodes = (AbstractGPNode[])this.rules[t][mode];
            result = (AbstractGPNode)availableNodes[value % availableNodes.length].clone();
        }
        return result;
    }

    @Override
    public InterfaceProgram[] getProgramData() {
        if (this.rules == null) {
            this.compileArea();
            if (this.rules == null) {
                return null;
            }
        }
        this.currentIndex = 0;
        this.currentNumberOfNodes = 0;
        int mode = 0;
        this.phenotype = new AbstractGPNode[this.gpAreas.length];
        for (int t = 0; t < this.gpAreas.length; ++t) {
            mode = 0;
            this.currentIndex = t * this.genotypeLengthPerProgram;
            this.currentNumberOfNodes = 0;
            this.phenotype[t] = this.decodeGPNode(t, mode);
        }
        return this.phenotype;
    }

    @Override
    public InterfaceProgram[] getProgramDataWithoutUpdate() {
        return this.phenotype;
    }

    @Override
    public void SetProgramPhenotype(InterfaceProgram[] program) {
        if (program instanceof AbstractGPNode[]) {
            this.phenotype = new AbstractGPNode[program.length];
            for (int t = 0; t < program.length; ++t) {
                this.phenotype[t] = (AbstractGPNode)((AbstractGPNode)program[t]).clone();
            }
        }
    }

    @Override
    public void SetProgramGenotype(InterfaceProgram[] program) {
        this.SetProgramPhenotype(program);
        if (program instanceof AbstractGPNode[]) {
            System.err.println("Warning setProgram() for GEIndividualProgramData not implemented!");
        }
    }

    @Override
    public void SetFunctionArea(Object[] area) {
        if (area instanceof GPArea[]) {
            this.gpAreas = new GPArea[area.length];
            for (int t = 0; t < this.gpAreas.length; ++t) {
                this.gpAreas[t] = (GPArea)area[t];
            }
            this.compileArea();
        }
    }

    @Override
    public Object[] getFunctionArea() {
        return this.gpAreas;
    }

    @Override
    public void initByValue(Object obj, InterfaceOptimizationProblem opt) {
        if (obj instanceof InterfaceProgram) {
            this.SetProgramGenotype((InterfaceProgram[])obj);
        } else {
            this.defaultInit(opt);
            System.out.println("Initial value for GPIndividualDoubleData is no InterfaceProgram[]!");
        }
        this.mutationOperator.initialize(this, opt);
        this.crossoverOperator.init(this, opt);
    }

    @Override
    public String getStringRepresentation() {
        String result = "";
        result = result + "GEIndividual coding program:\n";
        result = result + "{";
        for (int i = 0; i < this.genotypeLengthPerProgram * this.gpAreas.length; ++i) {
            result = this.genotype.get(i) ? result + "1" : result + "0";
        }
        result = result + "}\n";
        InterfaceProgram[] data = this.getProgramData();
        for (int i = 0; i < data.length; ++i) {
            result = result + data[i].getStringRepresentation();
        }
        return result;
    }

    @Override
    public BitSet getBGenotype() {
        return this.genotype;
    }

    @Override
    public void setBGenotype(BitSet binaryData) {
        this.genotype = binaryData;
    }

    @Override
    public int getGenotypeLength() {
        return this.genotypeLengthPerProgram * this.gpAreas.length;
    }

    @Override
    public void defaultInit(InterfaceOptimizationProblem prob) {
        for (int i = 0; i < this.genotypeLengthPerProgram * this.gpAreas.length; ++i) {
            if (RNG.flipCoin(0.5)) {
                this.genotype.set(i);
                continue;
            }
            this.genotype.clear(i);
        }
    }

    @Override
    public void defaultMutate() {
        int mutationIndex = RNG.randomInt(0, this.genotypeLengthPerProgram * this.gpAreas.length);
        if (this.genotype.get(mutationIndex)) {
            this.genotype.clear(mutationIndex);
        } else {
            this.genotype.set(mutationIndex);
        }
    }

    @Override
    public String getName() {
        return "GE individual";
    }

    public void setGenotypeLengthPerProgram(int size) {
        this.genotypeLengthPerProgram = size;
    }

    public int getGenotypeLengthPerProgram() {
        return this.genotypeLengthPerProgram;
    }

    public String genotypeLengthPerProgramTipText() {
        return "Choose the length of the genotype.";
    }

    public void setMaxNumberOfNodes(int nodes) {
        this.maxNumberOfNodes = nodes;
    }

    public int getMaxNumberOfNodes() {
        return this.maxNumberOfNodes;
    }

    public String maxNumberOfNodesTipText() {
        return "Set the maximum number of nodes for the program.";
    }

    public void setNumberOfBitPerInt(int length) {
        this.numberOfBitPerInt = length;
    }

    public int getNumberOfBitPerInt() {
        return this.numberOfBitPerInt;
    }

    public String numberOfBitPerIntTipText() {
        return "Choose the number of bits ber int.";
    }
}

