/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeInteger;
import eva2.optimization.individuals.InterfaceGIIndividual;
import eva2.optimization.operator.crossover.CrossoverGIDefault;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.operator.mutation.MutateDefault;
import eva2.problems.InterfaceHasInitRange;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is a GI individual suited to optimize int values.")
public class GIIndividualIntegerData
extends AbstractEAIndividual
implements InterfaceGIIndividual,
InterfaceDataTypeInteger,
Serializable {
    private int[] phenotype;
    private int[][] initializationRange;
    protected int[] genotype;

    public GIIndividualIntegerData() {
        this.mutationProbability = 0.2;
        this.mutationOperator = new MutateDefault();
        this.crossoverProbability = 0.7;
        this.crossoverOperator = new CrossoverGIDefault();
        this.initializationRange = new int[10][2];
        for (int i = 0; i < this.initializationRange.length; ++i) {
            this.initializationRange[i][0] = 0;
            this.initializationRange[i][1] = 7;
        }
        this.genotype = new int[10];
    }

    public GIIndividualIntegerData(int[][] theRange) {
        this();
        this.setIntRange(theRange);
    }

    public GIIndividualIntegerData(GIIndividualIntegerData individual) {
        if (individual.phenotype != null) {
            this.phenotype = new int[individual.phenotype.length];
            System.arraycopy(individual.phenotype, 0, this.phenotype, 0, this.phenotype.length);
        }
        if (individual.genotype != null) {
            this.genotype = new int[individual.genotype.length];
            System.arraycopy(individual.genotype, 0, this.genotype, 0, this.genotype.length);
        }
        this.initializationRange = new int[individual.initializationRange.length][2];
        for (int i = 0; i < this.initializationRange.length; ++i) {
            this.initializationRange[i][0] = individual.initializationRange[i][0];
            this.initializationRange[i][1] = individual.initializationRange[i][1];
        }
        this.age = individual.age;
        this.crossoverOperator = individual.crossoverOperator;
        this.crossoverProbability = individual.crossoverProbability;
        this.mutationOperator = (InterfaceMutation)individual.mutationOperator.clone();
        this.mutationProbability = individual.mutationProbability;
        this.selectionProbability = new double[individual.selectionProbability.length];
        System.arraycopy(individual.selectionProbability, 0, this.selectionProbability, 0, this.selectionProbability.length);
        this.fitness = new double[individual.fitness.length];
        System.arraycopy(individual.fitness, 0, this.fitness, 0, this.fitness.length);
        this.cloneAEAObjects(individual);
    }

    @Override
    public Object clone() {
        return new GIIndividualIntegerData(this);
    }

    @Override
    public boolean equalGenotypes(AbstractEAIndividual individual) {
        if (individual instanceof GIIndividualIntegerData) {
            GIIndividualIntegerData indy = (GIIndividualIntegerData)individual;
            if (this.genotype == null || indy.genotype == null) {
                return false;
            }
            if (this.genotype.length != indy.genotype.length) {
                return false;
            }
            for (int i = 0; i < this.initializationRange.length; ++i) {
                if (this.genotype[i] != indy.genotype[i]) {
                    return false;
                }
                if (this.initializationRange[i][0] != indy.initializationRange[i][0]) {
                    return false;
                }
                if (this.initializationRange[i][1] == indy.initializationRange[i][1]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setIntegerDataLength(int length) {
        int i;
        int[] newDesPa = new int[length];
        int[][] newRange = new int[length][2];
        for (i = 0; i < newDesPa.length && i < this.genotype.length; ++i) {
            newDesPa[i] = this.genotype[i];
            newRange[i][0] = this.initializationRange[i][0];
            newRange[i][1] = this.initializationRange[i][1];
        }
        for (i = this.genotype.length; i < newDesPa.length; ++i) {
            newDesPa[i] = this.genotype[this.genotype.length - 1];
            newRange[i][0] = this.initializationRange[this.genotype.length - 1][0];
            newRange[i][1] = this.initializationRange[this.genotype.length - 1][1];
        }
        this.genotype = newDesPa;
        this.initializationRange = newRange;
    }

    @Override
    public int size() {
        return this.initializationRange.length;
    }

    @Override
    public void setIntRange(int[][] range) {
        if (range.length != this.initializationRange.length) {
            this.setIntegerDataLength(range.length);
        }
        for (int i = 0; i < this.initializationRange.length && i < range.length; ++i) {
            this.initializationRange[i][0] = range[i][0];
            this.initializationRange[i][1] = range[i][1];
        }
    }

    @Override
    public int[][] getIntRange() {
        return this.initializationRange;
    }

    @Override
    public int[] getIntegerData() {
        this.phenotype = new int[this.initializationRange.length];
        System.arraycopy(this.genotype, 0, this.phenotype, 0, this.phenotype.length);
        return this.phenotype;
    }

    @Override
    public int[] getIntegerDataWithoutUpdate() {
        return this.phenotype;
    }

    @Override
    public void setIntPhenotype(int[] doubleData) {
        this.phenotype = doubleData;
    }

    @Override
    public void setIntGenotype(int[] doubleData) {
        this.setIntPhenotype(doubleData);
        this.genotype = new int[this.initializationRange.length];
        System.arraycopy(doubleData, 0, this.genotype, 0, doubleData.length);
    }

    @Override
    public void initByValue(Object obj, InterfaceOptimizationProblem opt) {
        if (obj instanceof int[]) {
            int[] bs = (int[])obj;
            if (bs.length != this.initializationRange.length) {
                System.out.println("Init value and requested length doesn't match!");
            }
            this.setIntGenotype(bs);
        } else {
            this.defaultInit(opt);
            System.out.println("Initial value for GAIndividualDoubleData is not double[]!");
        }
        this.mutationOperator.initialize(this, opt);
        this.crossoverOperator.init(this, opt);
    }

    @Override
    public String getStringRepresentation() {
        int i;
        int i2;
        String result = "";
        result = result + "GIIndividual coding int: (";
        result = result + "Fitness {";
        for (i2 = 0; i2 < this.fitness.length; ++i2) {
            result = result + this.fitness[i2] + ";";
        }
        result = result + "}/SelProb{";
        for (i2 = 0; i2 < this.selectionProbability.length; ++i2) {
            result = result + this.selectionProbability[i2] + ";";
        }
        result = result + "})\n Value: ";
        result = result + "[";
        int[] d = this.getIntegerData();
        for (i = 0; i < d.length; ++i) {
            result = result + d[i] + "; ";
        }
        result = result + "]\n";
        result = result + "CodingRange:  [";
        for (i = 0; i < this.initializationRange.length; ++i) {
            result = result + "(" + this.initializationRange[i][0] + "; " + this.initializationRange[i][1] + "); ";
        }
        result = result + "]\n";
        return result;
    }

    @Override
    public int[] getIGenotype() {
        return this.genotype;
    }

    @Override
    public void setIGenotype(int[] b) {
        this.genotype = b;
    }

    @Override
    public int getGenotypeLength() {
        return this.genotype.length;
    }

    @Override
    public void defaultMutate() {
        int mutationIndex = RNG.randomInt(0, this.genotype.length - 1);
        this.genotype[mutationIndex] = RNG.randomInt(this.initializationRange[mutationIndex][0], this.initializationRange[mutationIndex][1]);
    }

    @Override
    public void defaultInit(InterfaceOptimizationProblem prob) {
        int[][] range = this.initializationRange;
        if (prob != null && prob instanceof InterfaceHasInitRange && ((InterfaceHasInitRange)((Object)prob)).getInitializationRange() != null) {
            Object rng = ((InterfaceHasInitRange)((Object)prob)).getInitializationRange();
            if (rng instanceof double[][]) {
                double[][] dblRng = (double[][])rng;
                range = new int[dblRng.length][dblRng[0].length];
                for (int i = 0; i < range.length; ++i) {
                    for (int j = 0; j < range[0].length; ++j) {
                        range[i][j] = (int)dblRng[i][j];
                    }
                }
            } else if (rng instanceof int[][]) {
                range = (int[][])rng;
            } else {
                System.err.println("Error, invalid initial range provided by " + prob + ", expecting int[][] or double[][], disregarding initialization range");
            }
        }
        for (int i = 0; i < this.genotype.length; ++i) {
            this.genotype[i] = RNG.randomInt(range[i][0], range[i][1]);
        }
    }

    @Override
    public String getName() {
        return "GI individual";
    }
}

