/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.GIIndividualIntegerData;
import eva2.optimization.individuals.InterfaceDataTypeInteger;
import eva2.optimization.individuals.InterfaceDataTypePermutation;
import eva2.optimization.individuals.OBGAIndividualPermutationData;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is a mixed data type combining an integer vector with a permutation vector.")
public class GIOBGAIndividualIntegerPermutationData
extends AbstractEAIndividual
implements InterfaceDataTypeInteger,
InterfaceDataTypePermutation,
Serializable {
    private InterfaceDataTypeInteger integerData = new GIIndividualIntegerData();
    private InterfaceDataTypePermutation permutationData = new OBGAIndividualPermutationData();

    public GIOBGAIndividualIntegerPermutationData() {
        this.mutationProbability = 1.0;
        this.crossoverProbability = 1.0;
        this.integerData = new GIIndividualIntegerData();
        this.permutationData = new OBGAIndividualPermutationData();
    }

    public GIOBGAIndividualIntegerPermutationData(GIOBGAIndividualIntegerPermutationData individual) {
        this.integerData = (InterfaceDataTypeInteger)((AbstractEAIndividual)((Object)individual.getIntegers())).clone();
        this.permutationData = (InterfaceDataTypePermutation)((AbstractEAIndividual)((Object)individual.getPermutations())).clone();
        this.age = individual.age;
        this.crossoverOperator = individual.crossoverOperator;
        this.crossoverProbability = individual.crossoverProbability;
        this.mutationOperator = (InterfaceMutation)individual.mutationOperator.clone();
        this.mutationProbability = individual.mutationProbability;
        this.selectionProbability = new double[individual.selectionProbability.length];
        System.arraycopy(individual.selectionProbability, 0, this.selectionProbability, 0, this.selectionProbability.length);
        this.fitness = new double[individual.fitness.length];
        System.arraycopy(individual.fitness, 0, this.fitness, 0, this.fitness.length);
        this.cloneAEAObjects(individual);
    }

    @Override
    public Object clone() {
        return new GIOBGAIndividualIntegerPermutationData(this);
    }

    @Override
    public boolean equalGenotypes(AbstractEAIndividual individual) {
        if (individual instanceof GIOBGAIndividualIntegerPermutationData) {
            GIOBGAIndividualIntegerPermutationData indy = (GIOBGAIndividualIntegerPermutationData)individual;
            if (!((AbstractEAIndividual)((Object)this.integerData)).equalGenotypes((AbstractEAIndividual)((Object)indy.integerData))) {
                return false;
            }
            return ((AbstractEAIndividual)((Object)this.permutationData)).equalGenotypes((AbstractEAIndividual)((Object)indy.permutationData));
        }
        return false;
    }

    @Override
    public void initialize(InterfaceOptimizationProblem opt) {
        ((AbstractEAIndividual)((Object)this.integerData)).initialize(opt);
        ((AbstractEAIndividual)((Object)this.permutationData)).initialize(opt);
    }

    @Override
    public void defaultInit(InterfaceOptimizationProblem prob) {
        ((AbstractEAIndividual)((Object)this.integerData)).defaultInit(prob);
        ((AbstractEAIndividual)((Object)this.permutationData)).defaultInit(prob);
    }

    @Override
    public void initByValue(Object obj, InterfaceOptimizationProblem opt) {
        if (obj instanceof Object[]) {
            if (((Object[])obj)[0] instanceof double[]) {
                ((AbstractEAIndividual)((Object)this.integerData)).initByValue(((Object[])obj)[0], opt);
                ((AbstractEAIndividual)((Object)this.permutationData)).initByValue(((Object[])obj)[1], opt);
            } else {
                ((AbstractEAIndividual)((Object)this.integerData)).initByValue(((Object[])obj)[1], opt);
                ((AbstractEAIndividual)((Object)this.permutationData)).initByValue(((Object[])obj)[0], opt);
            }
        } else {
            ((AbstractEAIndividual)((Object)this.integerData)).initialize(opt);
            ((AbstractEAIndividual)((Object)this.permutationData)).initialize(opt);
            System.out.println("Initial value for GIOBGAIndividualIntegerPermutationData is not suitable!");
        }
    }

    @Override
    public void mutate() {
        if (RNG.flipCoin(this.mutationProbability)) {
            ((AbstractEAIndividual)((Object)this.integerData)).mutate();
        }
        if (RNG.flipCoin(this.mutationProbability)) {
            ((AbstractEAIndividual)((Object)this.permutationData)).mutate();
        }
    }

    @Override
    public void defaultMutate() {
        ((AbstractEAIndividual)((Object)this.integerData)).defaultMutate();
        ((AbstractEAIndividual)((Object)this.permutationData)).defaultMutate();
    }

    @Override
    public AbstractEAIndividual[] mateWith(Population partners) {
        AbstractEAIndividual[] result;
        if (RNG.flipCoin(this.crossoverProbability)) {
            int i;
            AbstractEAIndividual numTmp = (AbstractEAIndividual)((Object)this.getIntegers());
            Population numPop = new Population();
            for (i = 0; i < partners.size(); ++i) {
                numPop.add((AbstractEAIndividual)((Object)((GIOBGAIndividualIntegerPermutationData)partners.get(i)).getIntegers()));
            }
            AbstractEAIndividual[] resNum = numTmp.mateWith(numPop);
            AbstractEAIndividual binTmp = (AbstractEAIndividual)((Object)this.getPermutations());
            Population binPop = new Population();
            for (i = 0; i < partners.size(); ++i) {
                binPop.add((AbstractEAIndividual)((Object)((GIOBGAIndividualIntegerPermutationData)partners.get(i)).getPermutations()));
            }
            AbstractEAIndividual[] resBin = binTmp.mateWith(binPop);
            result = new GIOBGAIndividualIntegerPermutationData[resNum.length];
            for (i = 0; i < result.length; ++i) {
                result[i] = new GIOBGAIndividualIntegerPermutationData(this);
                ((GIOBGAIndividualIntegerPermutationData)result[i]).setIntegers((InterfaceDataTypeInteger)((Object)resNum[i]));
                ((GIOBGAIndividualIntegerPermutationData)result[i]).setPermutations((InterfaceDataTypePermutation)((Object)resBin[i]));
            }
        } else {
            result = new AbstractEAIndividual[partners.size() + 1];
            result[0] = (AbstractEAIndividual)this.clone();
            for (int i = 0; i < partners.size(); ++i) {
                result[i + 1] = (AbstractEAIndividual)((AbstractEAIndividual)partners.get(i)).clone();
            }
        }
        for (int i = 0; i < result.length; ++i) {
            result[i].giveNewName();
        }
        return result;
    }

    @Override
    public String getStringRepresentation() {
        String result = "This is a hybrid Individual:\n";
        result = result + "The Integer Part:\n" + ((AbstractEAIndividual)((Object)this.integerData)).getStringRepresentation();
        result = result + "\nThe Permutation Part:\n" + ((AbstractEAIndividual)((Object)this.permutationData)).getStringRepresentation();
        return result;
    }

    @Override
    public void setIntegerDataLength(int length) {
        this.integerData.setIntegerDataLength(length);
    }

    @Override
    public int size() {
        return this.integerData.size();
    }

    @Override
    public void setIntRange(int[][] range) {
        this.integerData.setIntRange(range);
    }

    @Override
    public int[][] getIntRange() {
        return this.integerData.getIntRange();
    }

    @Override
    public int[] getIntegerData() {
        return this.integerData.getIntegerData();
    }

    @Override
    public int[] getIntegerDataWithoutUpdate() {
        return this.integerData.getIntegerDataWithoutUpdate();
    }

    @Override
    public void setIntPhenotype(int[] intData) {
        this.integerData.setIntPhenotype(intData);
    }

    @Override
    public void setIntGenotype(int[] intData) {
        this.integerData.setIntGenotype(intData);
    }

    @Override
    public void setPermutationDataLength(int[] length) {
        this.permutationData.setPermutationDataLength(length);
        this.integerData.setIntegerDataLength(length.length);
    }

    @Override
    public int[] sizePermutation() {
        return this.permutationData.sizePermutation();
    }

    @Override
    public int[][] getPermutationData() {
        return this.permutationData.getPermutationData();
    }

    @Override
    public int[][] getPermutationDataWithoutUpdate() {
        return this.permutationData.getPermutationDataWithoutUpdate();
    }

    @Override
    public void setPermutationPhenotype(int[][] perm) {
        this.setPermutationPhenotype(perm);
    }

    @Override
    public void setPermutationGenotype(int[][] perm) {
        this.setPermutationGenotype(perm);
    }

    @Override
    public void setFirstindex(int[] firstindex) {
        this.permutationData.setFirstindex(firstindex);
    }

    @Override
    public String getName() {
        return "GA/ES individual";
    }

    public void setIntegers(InterfaceDataTypeInteger Numbers) {
        this.integerData = Numbers;
    }

    public InterfaceDataTypeInteger getIntegers() {
        return this.integerData;
    }

    public String integersTipText() {
        return "Choose the type of inner integers to use.";
    }

    public void setPermutations(InterfaceDataTypePermutation p) {
        this.permutationData = p;
    }

    public InterfaceDataTypePermutation getPermutations() {
        return this.permutationData;
    }

    public String permutationsTipText() {
        return "Choose the type of inner permutation to use.";
    }
}

