/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeProgram;
import eva2.optimization.individuals.InterfaceGPIndividual;
import eva2.optimization.individuals.codings.gp.AbstractGPNode;
import eva2.optimization.individuals.codings.gp.GPArea;
import eva2.optimization.individuals.codings.gp.InterfaceProgram;
import eva2.optimization.operator.crossover.CrossoverGPDefault;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.operator.mutation.MutateDefault;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.EVAERROR;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is a GP individual suited to optimize Koza style program trees.")
public class GPIndividualProgramData
extends AbstractEAIndividual
implements InterfaceGPIndividual,
InterfaceDataTypeProgram,
Serializable {
    protected AbstractGPNode[] genotype;
    protected AbstractGPNode[] phenotype;
    protected GPArea[] gpArea;
    protected double initFullGrowRatio = 0.5;
    protected int initDepth = 4;
    protected int maxAllowedDepth = 8;
    protected boolean checkMaxDepth = true;

    public GPIndividualProgramData() {
        this.gpArea = new GPArea[1];
        this.gpArea[0] = new GPArea();
        this.genotype = new AbstractGPNode[1];
        this.mutationOperator = new MutateDefault();
        this.crossoverOperator = new CrossoverGPDefault();
    }

    public GPIndividualProgramData(GPIndividualProgramData individual) {
        int i;
        if (individual.phenotype != null) {
            this.phenotype = new AbstractGPNode[individual.phenotype.length];
            for (i = 0; i < individual.phenotype.length; ++i) {
                if (individual.phenotype[i] == null) continue;
                this.phenotype[i] = (AbstractGPNode)individual.phenotype[i].clone();
            }
        }
        if (individual.genotype != null) {
            this.genotype = new AbstractGPNode[individual.genotype.length];
            this.gpArea = new GPArea[individual.gpArea.length];
            for (i = 0; i < individual.genotype.length; ++i) {
                if (individual.genotype[i] != null) {
                    this.genotype[i] = (AbstractGPNode)individual.genotype[i].clone();
                    this.genotype[i].connect(null);
                }
                if (individual.gpArea[i] == null) continue;
                this.gpArea[i] = (GPArea)individual.gpArea[i].clone();
            }
        }
        this.initFullGrowRatio = individual.initFullGrowRatio;
        this.initDepth = individual.initDepth;
        this.maxAllowedDepth = individual.maxAllowedDepth;
        this.checkMaxDepth = individual.checkMaxDepth;
        this.age = individual.age;
        this.crossoverOperator = individual.crossoverOperator;
        this.crossoverProbability = individual.crossoverProbability;
        this.mutationOperator = (InterfaceMutation)individual.mutationOperator.clone();
        this.mutationProbability = individual.mutationProbability;
        this.selectionProbability = new double[individual.selectionProbability.length];
        System.arraycopy(individual.selectionProbability, 0, this.selectionProbability, 0, this.selectionProbability.length);
        this.fitness = new double[individual.fitness.length];
        System.arraycopy(individual.fitness, 0, this.fitness, 0, this.fitness.length);
        this.cloneAEAObjects(individual);
    }

    @Override
    public Object clone() {
        return new GPIndividualProgramData(this);
    }

    @Override
    public boolean equalGenotypes(AbstractEAIndividual individual) {
        if (individual instanceof GPIndividualProgramData) {
            GPIndividualProgramData indy = (GPIndividualProgramData)individual;
            if (this.maxAllowedDepth != indy.maxAllowedDepth) {
                return false;
            }
            if (this.genotype == null || indy.genotype == null) {
                return false;
            }
            for (int i = 0; i < this.genotype.length; ++i) {
                if (this.genotype[i] != null && indy.genotype[i] != null && this.genotype[i].equals(indy.genotype[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void setProgramDataLength(int length) {
        int i;
        GPArea[] oldArea = this.gpArea;
        AbstractGPNode[] oldProg = this.genotype;
        this.gpArea = new GPArea[length];
        this.genotype = new AbstractGPNode[length];
        for (i = 0; i < this.gpArea.length && i < oldArea.length; ++i) {
            this.gpArea[i] = oldArea[i];
            this.genotype[i] = oldProg[i];
        }
        for (i = oldArea.length; i < this.gpArea.length; ++i) {
            this.gpArea[i] = oldArea[oldArea.length - 1];
            this.genotype[i] = oldProg[oldProg.length - 1];
        }
    }

    @Override
    public InterfaceProgram[] getProgramData() {
        this.phenotype = new AbstractGPNode[this.genotype.length];
        for (int i = 0; i < this.genotype.length; ++i) {
            this.phenotype[i] = (AbstractGPNode)this.genotype[i].clone();
            if (!this.checkMaxDepth || !this.phenotype[i].isMaxDepthViolated(this.maxAllowedDepth)) continue;
            System.err.println("Trying to meet the Target Depth! " + this.phenotype[i].isMaxDepthViolated(this.maxAllowedDepth) + " " + this.phenotype[i].getMaxDepth());
            this.phenotype[i].repairMaxDepth(this.gpArea[i], this.maxAllowedDepth);
        }
        return this.phenotype;
    }

    @Override
    public InterfaceProgram[] getProgramDataWithoutUpdate() {
        if (this.phenotype == null) {
            return this.getProgramData();
        }
        return this.phenotype;
    }

    @Override
    public void SetProgramPhenotype(InterfaceProgram[] program) {
        if (program instanceof AbstractGPNode[]) {
            this.phenotype = new AbstractGPNode[program.length];
            for (int i = 0; i < this.phenotype.length; ++i) {
                this.phenotype[i] = (AbstractGPNode)((AbstractGPNode)program[i]).clone();
            }
        }
    }

    @Override
    public void SetProgramGenotype(InterfaceProgram[] program) {
        this.SetProgramPhenotype(program);
        if (program instanceof AbstractGPNode[]) {
            this.genotype = new AbstractGPNode[program.length];
            for (int i = 0; i < this.genotype.length; ++i) {
                this.genotype[i] = (AbstractGPNode)((AbstractGPNode)program[i]).clone();
            }
        }
    }

    @Override
    public void SetFunctionArea(Object[] area) {
        if (area instanceof GPArea[]) {
            this.gpArea = (GPArea[])area;
        }
    }

    @Override
    public Object[] getFunctionArea() {
        return this.gpArea;
    }

    @Override
    public void initByValue(Object obj, InterfaceOptimizationProblem opt) {
        if (obj instanceof InterfaceProgram[]) {
            this.SetProgramGenotype((InterfaceProgram[])obj);
        } else {
            this.defaultInit(opt);
            System.out.println("Initial value for GPIndividualDoubleData is no InterfaceProgram[]!");
        }
        this.mutationOperator.initialize(this, opt);
        this.crossoverOperator.init(this, opt);
    }

    @Override
    public String getStringRepresentation() {
        int i;
        String result = "";
        result = result + "GPIndividual coding program: (";
        result = result + "Fitness {";
        for (i = 0; i < this.fitness.length; ++i) {
            result = result + this.fitness[i] + ";";
        }
        result = result + "}/SelProb{";
        for (i = 0; i < this.selectionProbability.length; ++i) {
            result = result + this.selectionProbability[i] + ";";
        }
        result = result + "})\n Value: ";
        for (i = 0; i < this.genotype.length; ++i) {
            if (this.genotype[i] != null) {
                result = result + this.genotype[i].getStringRepresentation();
            }
            result = result + "\nUsing " + this.genotype[i].getNumberOfNodes() + " nodes.";
        }
        return result;
    }

    @Override
    public AbstractGPNode[] getPGenotype() {
        return this.genotype;
    }

    @Override
    public void setPGenotype(AbstractGPNode[] b) {
        this.genotype = b;
        this.phenotype = null;
    }

    @Override
    public void setPGenotype(AbstractGPNode b, int i) {
        this.genotype[i] = b;
        this.genotype[i].updateDepth(0);
        this.phenotype = null;
    }

    @Override
    public void defaultMutate() {
        for (int i = 0; i < this.genotype.length; ++i) {
            AbstractGPNode newNode;
            AbstractGPNode nodeToMutate = this.genotype[i].getRandomNode();
            if (nodeToMutate.getParent() == null) {
                this.defaultInit(null);
                continue;
            }
            AbstractGPNode parent = nodeToMutate.getParent();
            if (this.checkMaxDepth && nodeToMutate.getDepth() == this.maxAllowedDepth) {
                newNode = (AbstractGPNode)this.gpArea[i].getRandomNodeWithArity(0).clone();
                newNode.setDepth(nodeToMutate.getDepth());
                parent.setNode(newNode, nodeToMutate);
                continue;
            }
            newNode = (AbstractGPNode)this.gpArea[i].getRandomNode().clone();
            newNode.setDepth(nodeToMutate.getDepth());
            newNode.initGrow(this.gpArea[i], this.maxAllowedDepth);
            parent.setNode(newNode, nodeToMutate);
        }
        this.phenotype = null;
    }

    @Override
    public void defaultInit(InterfaceOptimizationProblem prob) {
        this.phenotype = null;
        for (int i = 0; i < this.gpArea.length; ++i) {
            if (this.gpArea[i] == null) {
                EVAERROR.errorMsgOnce("Error in GPIndividualProgramData.defaultInit(): Area[" + i + "] == null !!");
                continue;
            }
            this.genotype[i] = (AbstractGPNode)this.gpArea[i].getRandomNonTerminal().clone();
            this.genotype[i].setDepth(0);
            int targetDepth = RNG.randomInt(1, this.initDepth);
            if (RNG.flipCoin(this.initFullGrowRatio)) {
                this.genotype[i].initFull(this.gpArea[i], targetDepth);
                continue;
            }
            this.genotype[i].initGrow(this.gpArea[i], targetDepth);
        }
    }

    @Override
    public String getName() {
        return "GP individual";
    }

    public void setCheckMaxDepth(boolean b) {
        this.checkMaxDepth = b;
    }

    public boolean getCheckMaxDepth() {
        return this.checkMaxDepth;
    }

    public String checkMaxDepthTipText() {
        return "If activated the maximum depth of the program tree will be enforced.";
    }

    public void setInitFullGrowRatio(double b) {
        if (b < 0.0) {
            b = 0.0;
        }
        if (b > 1.0) {
            b = 1.0;
        }
        this.initFullGrowRatio = b;
    }

    public double getInitFullGrowRatio() {
        return this.initFullGrowRatio;
    }

    public String initFullGrowRatioTipText() {
        return "The ratio between the full and the grow initialize methods (1 uses only full initializing).";
    }

    public void setInitDepth(int b) {
        if (b > this.maxAllowedDepth) {
            System.out.println("Waring Init Depth will be set to Target Depth!");
            b = this.maxAllowedDepth;
        }
        this.initDepth = b;
    }

    public int getInitDepth() {
        return this.initDepth;
    }

    public String initDepthTipText() {
        return "The initial depth of the GP Tree.";
    }

    public void setMaxAllowedDepth(int b) {
        this.maxAllowedDepth = b;
    }

    @Override
    public int getMaxAllowedDepth() {
        return this.maxAllowedDepth;
    }

    public String maxAllowedDepthTipText() {
        return "The maximum depth allowed for the GP tree.";
    }

    public String[] customPropertyOrder() {
        return new String[]{"initDepth", "checkMaxDepth", "maxAllowedDepth"};
    }

    public void updateDepth() {
        for (int i = 0; i < this.genotype.length; ++i) {
            this.genotype[i].updateDepth(0);
        }
    }

    public void checkDepth() {
        for (int i = 0; i < this.genotype.length; ++i) {
            this.genotype[i].checkDepth(0);
        }
    }
}

