/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.tools.EVAERROR;
import java.io.Serializable;
import java.util.Comparator;

public class IndividualWeightedFitnessComparator
implements Comparator<Object>,
Serializable {
    private static final long serialVersionUID = 3182129129041083881L;
    private double[] fitWeights = null;

    public IndividualWeightedFitnessComparator(double[] weights) {
        this.setFitWeights(weights);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IndividualWeightedFitnessComparator) {
            IndividualWeightedFitnessComparator o = (IndividualWeightedFitnessComparator)obj;
            if (this.fitWeights == null && o.fitWeights == null) {
                return true;
            }
            if (this.fitWeights == null || o.fitWeights == null) {
                return false;
            }
            if (this.fitWeights.length == o.fitWeights.length) {
                for (int i = 0; i < this.fitWeights.length; ++i) {
                    if (this.fitWeights[i] == o.fitWeights[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.fitWeights == null) {
            return super.hashCode();
        }
        int code = 0;
        for (int i = 0; i < this.fitWeights.length; ++i) {
            code += (int)(this.fitWeights[i] * 10000.0) % (10000 * (i + 1));
        }
        return code;
    }

    @Override
    public int compare(Object o1, Object o2) {
        double score2;
        double[] f1 = ((AbstractEAIndividual)o1).getFitness();
        double[] f2 = ((AbstractEAIndividual)o2).getFitness();
        double score1 = this.calcScore(f1);
        if (score1 < (score2 = this.calcScore(f2))) {
            return -1;
        }
        if (score1 > score2) {
            return 1;
        }
        return 0;
    }

    private double calcScore(double[] f) {
        if (f == null || this.fitWeights == null) {
            throw new RuntimeException("Error, missing information in " + this.getClass());
        }
        if (f.length != this.fitWeights.length) {
            if (f.length < this.fitWeights.length) {
                EVAERROR.errorMsgOnce("Warning, fitness vector has less dimensions than the weights... some weights are ignored, in " + this.getClass());
            } else {
                EVAERROR.errorMsgOnce("Warning, fitness vector has more dimensions than the weights... some fitness values are ignored, in " + this.getClass());
            }
        }
        double s = 0.0;
        for (int i = 0; i < Math.min(f.length, this.fitWeights.length); ++i) {
            s += f[i] * this.fitWeights[i];
        }
        return s;
    }

    public double calcScore(AbstractEAIndividual indy) {
        double[] f = indy.getFitness();
        return this.calcScore(f);
    }

    public void setAllWeights(int dim, double v) {
        this.fitWeights = new double[dim];
        for (int i = 0; i < this.fitWeights.length; ++i) {
            this.fitWeights[i] = v;
        }
    }

    public void setFitWeights(double[] fitWeights) {
        this.fitWeights = fitWeights;
    }

    public double[] getFitWeights() {
        return this.fitWeights;
    }

    public String fitWeightsTipText() {
        return "Weights of the fitness values in the linear combination";
    }
}

