/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals.codings.ga;

import eva2.optimization.individuals.codings.ga.GAStandardCodingDouble;
import eva2.optimization.individuals.codings.ga.InterfaceGADoubleCoding;
import eva2.tools.math.RNG;
import java.io.Serializable;
import java.util.BitSet;

public class GAGrayCodingDouble
implements InterfaceGADoubleCoding,
Serializable {
    GAStandardCodingDouble standardCodingDouble = new GAStandardCodingDouble();

    @Override
    public double decodeValue(BitSet refBitSet, double[] range, int[] locus, boolean correction) {
        boolean tmpB = false;
        int[] tmpLocus = new int[]{0, locus[1]};
        BitSet tmpBitSet = new BitSet(tmpLocus.length);
        for (int i = 0; i < tmpLocus[1]; ++i) {
            tmpB = refBitSet.get(locus[0]);
            for (int j = 1; j <= i; ++j) {
                tmpB ^= refBitSet.get(locus[0] + j);
            }
            if (tmpB) {
                tmpBitSet.set(i);
                continue;
            }
            tmpBitSet.clear(i);
        }
        return this.standardCodingDouble.decodeValue(tmpBitSet, range, tmpLocus, correction);
    }

    @Override
    public void codeValue(double value, double[] range, BitSet refBitSet, int[] locus) {
        int[] tmpLocus = new int[]{0, locus[1]};
        BitSet tmpBitSet = new BitSet(tmpLocus.length);
        this.standardCodingDouble.codeValue(value, range, tmpBitSet, tmpLocus);
        if (tmpBitSet.get(0)) {
            refBitSet.set(locus[0]);
        } else {
            refBitSet.clear(locus[0]);
        }
        for (int i = 1; i < locus[1]; ++i) {
            if (tmpBitSet.get(i) ^ tmpBitSet.get(i - 1)) {
                refBitSet.set(locus[0] + i);
                continue;
            }
            refBitSet.clear(locus[0] + i);
        }
    }

    public static void main(String[] args) {
        GAGrayCodingDouble t = new GAGrayCodingDouble();
        BitSet tmpBitSet = new BitSet();
        int[] locus = new int[]{0, 32};
        double[] range = new double[]{-10.0, 10.0};
        for (int i = 0; i < 10; ++i) {
            double value;
            double tmp = value = RNG.randomDouble(range[0], range[1]);
            System.out.println("Coding Value : " + value);
            t.codeValue(value, range, tmpBitSet, locus);
            value = t.decodeValue(tmpBitSet, range, locus, false);
            System.out.println("Decoded Value : " + value);
        }
    }

    public String printBitSet(BitSet b) {
        return this.printBitSet(b, b.size());
    }

    public String printBitSet(BitSet b, int length) {
        String output = "{";
        for (int i = 0; i < length; ++i) {
            output = b.get(i) ? output + "1" : output + "0";
        }
        output = output + "}\n";
        return output;
    }
}

