/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals.codings.ga;

import eva2.optimization.individuals.codings.ga.InterfaceGADoubleCoding;
import java.io.Serializable;
import java.util.BitSet;

public class GAStandardCodingDouble
implements InterfaceGADoubleCoding,
Serializable {
    private double lastMaxVal = 1.0;
    private int lastLen = 0;

    public double decodeValueOld(BitSet refBitSet, double[] range, int[] locus, boolean correction) {
        double u_min = range[0];
        double u_max = range[1];
        int mStart = locus[0];
        int mLength = locus[1];
        if (mLength != this.lastLen) {
            this.lastMaxVal = Math.pow(2.0, mLength) - 1.0;
            this.lastLen = mLength;
        }
        long tmpV = 0L;
        for (int i = 0; i < mLength; ++i) {
            if (!refBitSet.get(mStart + mLength - 1 - i)) continue;
            tmpV = (long)((double)tmpV + Math.pow(2.0, i));
        }
        double output = (double)tmpV * (u_max - u_min) / this.lastMaxVal + u_min;
        return output;
    }

    @Override
    public double decodeValue(BitSet refBitSet, double[] range, int[] locus, boolean correction) {
        long val = refBitSet.get(locus[0]) ? 1 : 0;
        int mLength = locus[1];
        if (mLength != this.lastLen) {
            this.lastMaxVal = Math.pow(2.0, mLength) - 1.0;
            this.lastLen = mLength;
        }
        for (int i = 1 + locus[0]; i < locus[0] + locus[1]; ++i) {
            val = (long)((double)val * 2.0);
            if (!refBitSet.get(i)) continue;
            val = (long)((double)val + 1.0);
        }
        return range[0] + (range[1] - range[0]) * (double)val / this.lastMaxVal;
    }

    @Override
    public void codeValue(double value, double[] range, BitSet refBitSet, int[] locus) {
        int counter = 0;
        double uMin = range[0];
        double uMax = range[1];
        int m_start = locus[0];
        int m_length = locus[1];
        double mMax = Math.pow(2.0, m_length) - 1.0;
        double mMin = 0.0;
        BitSet tmpBitSet = new BitSet(m_length);
        for (long tmpV = Math.round((value - uMin) * mMax / (uMax - uMin)); tmpV >= 1L; tmpV /= 2L) {
            if (tmpV % 2L == 1L) {
                --tmpV;
                tmpBitSet.set(counter);
            } else {
                tmpBitSet.clear(counter);
            }
            ++counter;
        }
        for (int i = 0; i < m_length; ++i) {
            if (tmpBitSet.get(i)) {
                refBitSet.set(m_start + m_length - 1 - i);
                continue;
            }
            refBitSet.clear(m_start + m_length - 1 - i);
        }
    }

    public static void main() {
        int i;
        GAStandardCodingDouble t = new GAStandardCodingDouble();
        String test = "01100010001000110010000011111101";
        BitSet tmpBitSet = new BitSet();
        int[] locus = new int[]{10, 12};
        double[] range = new double[]{-110.0, 1000.0};
        for (i = 0; i < test.length(); ++i) {
            if (test.charAt(i) == '1') {
                tmpBitSet.set(i);
                continue;
            }
            tmpBitSet.clear(i);
        }
        for (i = 0; i < 1000; ++i) {
            double value = t.decodeValueOld(tmpBitSet, range, locus, false);
            System.out.println("Value def: " + value);
            value = t.decodeValue(tmpBitSet, range, locus, false);
            System.out.println("Value alt: " + value);
        }
    }

    public String printBitSet(BitSet b) {
        return this.printBitSet(b, b.size());
    }

    public String printBitSet(BitSet b, int length) {
        String output = "{";
        for (int i = 0; i < length; ++i) {
            output = b.get(i) ? output + "1" : output + "0";
        }
        output = output + "}\n";
        return output;
    }
}

