/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals.codings.ga;

import eva2.optimization.individuals.codings.ga.InterfaceGAIntegerCoding;
import eva2.tools.math.RNG;
import java.io.Serializable;
import java.util.BitSet;

public class GAStandardCodingInteger
implements InterfaceGAIntegerCoding,
Serializable {
    @Override
    public int decodeValue(BitSet refBitSet, int[] range, int[] locus, boolean correction) {
        String output = "";
        int u_min = range[0];
        int u_max = range[1];
        int start = locus[0];
        int mLength = locus[1];
        BitSet tmpBitSet = new BitSet(mLength);
        long tmpV = 0L;
        for (int i = 0; i < mLength; ++i) {
            if (refBitSet.get(start + mLength - 1 - i)) {
                tmpV = (long)((double)tmpV + Math.pow(2.0, i));
                tmpBitSet.set(mLength - 1 - i);
                output = output + "1";
                continue;
            }
            output = output + "0";
        }
        if ((tmpV += (long)u_min) > (long)u_max) {
            if (correction) {
                tmpV = RNG.randomInt(u_min, u_max);
                this.codeValue((int)tmpV, range, refBitSet, locus);
            } else {
                tmpV = u_max;
            }
        }
        return (int)tmpV;
    }

    @Override
    public void codeValue(int value, int[] range, BitSet refBitSet, int[] locus) {
        int i;
        long tmpV;
        int counter = 0;
        int uMin = range[0];
        int uMax = range[1];
        int start = locus[0];
        int length = locus[1];
        int mMax = (int)Math.pow(2.0, length) - 1;
        int mMin = 0;
        long tmpOut = tmpV = (long)(value - uMin);
        if (tmpV > (long)mMax) {
            tmpV = mMax;
        }
        if (tmpV < (long)mMin) {
            tmpV = mMin;
        }
        BitSet tmpBitSet = new BitSet(length);
        while (tmpV >= 1L) {
            if (tmpV % 2L == 1L) {
                --tmpV;
                tmpBitSet.set(counter);
            } else {
                tmpBitSet.clear(counter);
            }
            ++counter;
            tmpV /= 2L;
        }
        for (i = 0; i < length; ++i) {
            if (tmpBitSet.get(i)) {
                refBitSet.set(start + length - 1 - i);
                continue;
            }
            refBitSet.clear(start + length - 1 - i);
        }
        for (i = 0; i < length; ++i) {
            if (refBitSet.get(start + length - 1 - i)) {
                tmpBitSet.set(length - 1 - i);
                continue;
            }
            tmpBitSet.clear(start + length - 1 - i);
        }
    }

    @Override
    public int calculateNecessaryBits(int[] range) {
        int result = 0;
        double maxStore = 1.0 + (double)range[1] - (double)range[0];
        while (Math.pow(2.0, result) < maxStore) {
            ++result;
        }
        return result;
    }

    public String printBitSet(BitSet b) {
        return this.printBitSet(b, b.size());
    }

    public String printBitSet(BitSet b, int length) {
        String output = "{";
        for (int i = 0; i < length; ++i) {
            output = b.get(i) ? output + "1" : output + "0";
        }
        output = output + "}\n";
        return output;
    }
}

