/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals.codings.gp;

import eva2.gui.BeanInspector;
import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.individuals.codings.gp.GPArea;
import eva2.optimization.individuals.codings.gp.GPNodeAdd;
import eva2.optimization.individuals.codings.gp.GPNodeConst;
import eva2.optimization.individuals.codings.gp.GPNodeInput;
import eva2.optimization.individuals.codings.gp.InterfaceProgram;
import eva2.problems.GPFunctionProblem;
import eva2.problems.InterfaceProgramProblem;
import eva2.tools.Pair;
import eva2.tools.ReflectPackage;
import eva2.tools.math.Mathematics;
import eva2.tools.math.RNG;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Vector;

public abstract class AbstractGPNode
implements InterfaceProgram,
Serializable {
    protected AbstractGPNode parentNode;
    protected AbstractGPNode[] nodes = new AbstractGPNode[0];
    protected int depth = 0;

    public abstract Object clone();

    public abstract String getName();

    @Override
    public abstract Object evaluate(InterfaceProgramProblem var1);

    public abstract int getArity();

    @Override
    public String getStringRepresentation() {
        StringBuffer sb = new StringBuffer();
        AbstractGPNode.appendStringRepresentation(this, sb);
        return sb.toString();
    }

    protected void cloneMembers(AbstractGPNode node) {
        this.depth = node.depth;
        this.parentNode = node.parentNode;
        this.nodes = new AbstractGPNode[node.nodes.length];
        for (int i = 0; i < node.nodes.length; ++i) {
            this.nodes[i] = (AbstractGPNode)node.nodes[i].clone();
        }
    }

    private static void appendStringRepresentation(AbstractGPNode node, StringBuffer sbuf) {
        String op = node.getOpIdentifier();
        sbuf.append(op);
        if (node.getArity() > 0) {
            sbuf.append("(");
            for (int i = 0; i < node.nodes.length; ++i) {
                sbuf.append(node.nodes[i].getStringRepresentation());
                if (i >= node.nodes.length - 1) continue;
                sbuf.append(", ");
            }
            sbuf.append(")");
        }
    }

    public abstract String getOpIdentifier();

    public static Pair<AbstractGPNode, String> parseFromString(String str, Vector<AbstractGPNode> nodeTypes) {
        if (nodeTypes == null) {
            nodeTypes = AbstractGPNode.getNodeTypes();
        }
        if (nodeTypes.size() > 0) {
            Vector<AbstractGPNode> matchSet = AbstractGPNode.match(nodeTypes, str, true, true);
            if (matchSet.size() == 0) {
                Pair<Double, String> nextState = AbstractGPNode.readDouble(str, true);
                if (nextState != null) {
                    return new Pair<AbstractGPNode, String>(new GPNodeConst(nextState.head()), nextState.tail());
                }
                System.err.println("String has unknown prefix: " + str);
            } else if (matchSet.size() > 1) {
                System.err.println("String has ambiguous prefix: " + str + " -- " + BeanInspector.toString(matchSet));
            } else {
                AbstractGPNode currentNode = (AbstractGPNode)matchSet.get(0).clone();
                int cutFront = currentNode.getOpIdentifier().length();
                if (currentNode.getArity() == 0) {
                    String restStr = str.substring(cutFront).trim();
                    if (currentNode instanceof GPNodeInput) {
                        Pair<Double, String> nextState = AbstractGPNode.readDouble(restStr, false);
                        if (nextState != null) {
                            ((GPNodeInput)currentNode).setIdentifier(currentNode.getOpIdentifier() + (int)nextState.head().doubleValue());
                            restStr = nextState.tail();
                        } else {
                            ((GPNodeInput)currentNode).setIdentifier(currentNode.getOpIdentifier());
                        }
                    }
                    return new Pair<AbstractGPNode, String>(currentNode, restStr);
                }
                String restStr = str.substring(cutFront + 1).trim();
                currentNode.nodes = new AbstractGPNode[currentNode.getArity()];
                for (int i = 0; i < currentNode.getArity(); ++i) {
                    Pair<AbstractGPNode, String> nextState = AbstractGPNode.parseFromString(restStr, nodeTypes);
                    currentNode.nodes[i] = nextState.head();
                    try {
                        restStr = nextState.tail().substring(1).trim();
                        continue;
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        System.err.println("Error: parsing failed for node " + currentNode.getOpIdentifier() + "/" + currentNode.getArity() + ", depth " + currentNode.getDepth());
                        System.err.println("String was " + str);
                        e.printStackTrace();
                    }
                }
                return new Pair<AbstractGPNode, String>(currentNode, restStr);
            }
        }
        return null;
    }

    public static Vector<AbstractGPNode> getNodeTypes() {
        ArrayList<String> cls = GenericObjectEditor.getClassesFromClassPath(AbstractGPNode.class.getCanonicalName(), null);
        Vector<AbstractGPNode> nodeTypes = new Vector<AbstractGPNode>(cls.size());
        for (int i = 0; i < cls.size(); ++i) {
            try {
                AbstractGPNode node = (AbstractGPNode)Class.forName(cls.get(i)).newInstance();
                nodeTypes.add(node);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        nodeTypes.add(new GPNodeInput("N"));
        return nodeTypes;
    }

    private static Pair<Double, String> readDouble(String str, boolean expect) {
        int argLen = str.indexOf(44);
        if (argLen < 0) {
            argLen = str.indexOf(41);
        } else {
            int firstBrace = str.indexOf(41);
            if (firstBrace >= 0 && firstBrace < argLen) {
                argLen = firstBrace;
            }
        }
        String firstArg = argLen > 0 ? str.substring(0, argLen) : str.trim();
        try {
            Double d = Double.parseDouble(firstArg);
            return new Pair<Double, String>(d, str.substring(firstArg.length()));
        }
        catch (NumberFormatException e) {
            if (expect) {
                System.err.println("String has unknown prefix: " + str);
            }
            return null;
        }
    }

    public static String makeStringRepresentation(AbstractGPNode[] nodes, String op) {
        if (nodes.length == 0) {
            return op;
        }
        if (nodes.length == 1) {
            return op + "(" + nodes[0].getStringRepresentation() + ")";
        }
        String result = "( " + nodes[0].getStringRepresentation();
        for (int i = 1; i < nodes.length; ++i) {
            result = result + " " + op + " " + nodes[i].getStringRepresentation();
        }
        result = result + ")";
        return result;
    }

    private static Vector<AbstractGPNode> match(Vector<AbstractGPNode> nodeTypes, String str, boolean firstLongestOnly, boolean ignoreCase) {
        Vector<AbstractGPNode> matching = new Vector<AbstractGPNode>();
        for (int i = 0; i < nodeTypes.size(); ++i) {
            String reqPrefix = nodeTypes.get(i).getOpIdentifier();
            if (nodeTypes.get(i).getArity() > 0) {
                reqPrefix = reqPrefix + "(";
            }
            if (str.startsWith(reqPrefix)) {
                matching.add(nodeTypes.get(i));
                continue;
            }
            if (!ignoreCase || !str.toLowerCase().startsWith(reqPrefix.toLowerCase())) continue;
            matching.add(nodeTypes.get(i));
        }
        if (matching.size() > 1 && firstLongestOnly) {
            int maxLen = matching.get(0).getOpIdentifier().length();
            AbstractGPNode longest = matching.get(0);
            Vector<AbstractGPNode> longestList = new Vector<AbstractGPNode>();
            longestList.add(longest);
            for (int i = 1; i < matching.size(); ++i) {
                if (matching.get(i).getOpIdentifier().length() > maxLen) {
                    longest = matching.get(i);
                    maxLen = longest.getOpIdentifier().length();
                    longestList.clear();
                    longestList.add(longest);
                    continue;
                }
                if (matching.get(i).getOpIdentifier().length() != maxLen) continue;
                longestList.add(matching.get(i));
            }
            matching.clear();
            matching.addAll(longestList);
        }
        return matching;
    }

    public static AbstractGPNode parseFromString(String str) {
        Pair<AbstractGPNode, String> result = AbstractGPNode.parseFromString(str, null);
        return result.head();
    }

    public static void main(String[] args) {
        AbstractGPNode node = AbstractGPNode.parseFromString("+(-23421,cOs(*(pI,x)))");
        AbstractGPNode.parseFromString("+(+(85.334407,*(0.0056858,*(x1,x4))), +(*(0.00026,*(x0,x3)),*(-0.0022053,*(x2,x4))))");
        AbstractGPNode.parseFromString("+(+(80.51249,*(0.0071317,*(x1,x4))), +(*(0.0029955,*(x0,x1)),*(0.0021813,*(x2,x2))))");
        AbstractGPNode.parseFromString("+(+(9.300961,*(0.0047026,*(x2,x4))), +(*(0.0012547,*(x0,x2)),*(0.0019085,*(x2,x3))))");
        System.out.println("Parsed GPNode: " + node.getStringRepresentation());
        node = AbstractGPNode.parseFromString(node.getStringRepresentation());
        double[] sol = new double[]{4.755837346122817, 0.0, 1.618818602745894, 7.941611605461133, 7.949805645271173, 7.9567145687445695, 4.8033535294211225, 7.96718976492528, 1.641971622483205, 7.973813526015599, 7.980394418430633, 7.98301197251176, 7.98590997257042, 1.6493767411801206, 7.994756424330215, 7.994983501150322, 7.9971658558418035, 8.00273733683876, 8.00492865462689, 8.006601147955184};
        double[] sol2 = new double[]{7.897269942114308, 0.0, 7.939346674715275, 1.6272963933436047, 7.952303730484389, 7.960893192129872, 4.804987144876599, 7.9682843963405805, 7.977546251710085, 7.981109017707746, 1.642081396353059, 7.985246784301232, 4.827113167927753, 1.6448751122424057, 7.997468593784776, 8.00165633007073, 8.000613763831703, 8.003920903217887, 8.005789437120203, 8.012425280944097};
        double[] sol3 = new double[]{4.705970234231343, 4.71343334004773, 7.845971927185614, 4.708648989456629, 4.723918978896874, 7.864710619970946, 1.5776948341096448, 7.854961967305262, 7.858760422458277, 1.5743212019457036, 7.8488102514506, 1.5637070804731334, 1.5778078319616269, 1.5757833862993071, 4.711995406637344, 4.715448624806491, 7.8434193487088155, 4.7036514083601535, 7.848371610694223, 7.856489370257257};
        AbstractGPNode.test("-(0.75,prod(x))", sol3);
        AbstractGPNode.test("-(sum(x),*(7.5,n))", sol3);
        double[] solG5lit = new double[]{679.9453, 1026.067, 0.1188764, -0.3962336};
        double[] solG5 = new double[]{891.702675571982, 808.9201991846442, -0.028381806025171354, -0.4684444512076402};
        AbstractGPNode.test("-(x2,+(x3,0.55))", solG5);
        AbstractGPNode.test("-(x3,+(x2,0.55))", solG5);
        AbstractGPNode.test("+(*(1000,+(sin(-(-0.25,x2)),sin(-(-0.25,x3)))), -(894.8,x0))", solG5);
        AbstractGPNode.test("+(*(1000,+(sin(+(-0.25,x2)),sin(-(x2,+(x3,0.25))))), -(894.8,x1))", solG5);
        AbstractGPNode.test("+(*(1000,+(sin(+(-0.25,x3)),sin(-(x3,+(x2,0.25))))), 1294.8)", solG5);
        double[] solG13lit = new double[]{-1.717143, 1.595709, 1.827247, -0.7636413, -0.763645};
        double[] solG13 = new double[]{-1.717136209326236, 1.5957142570821299, -1.8272614459011625, -0.7636708932891901, 0.7636501970281446};
        AbstractGPNode.test("-(+(+(pow2(x0),pow2(x1)),+(pow2(x2),+(pow2(x3),pow2(x4)))),10)", solG13);
        AbstractGPNode.test("-(*(x1,x2),*(5,*(x3,x4)))", solG13);
        AbstractGPNode.test("+(pow3(x0),+(pow3(x1),1))", solG13);
        System.out.println("" + Math.exp(Mathematics.product(solG13)));
        AbstractGPNode.test("+(sum(x),abs(sin(*(x0,x3))))", solG5);
        AbstractGPNode.test("-(abs(sum(x)),*(abs(-7.5),n))", solG5);
        GPNodeConst n1 = new GPNodeConst(3.0);
        GPNodeConst n2 = new GPNodeConst(7.0);
        GPNodeAdd n3 = new GPNodeAdd();
        System.out.println(n1.equals(n2));
        System.out.println(n2.equals(n1));
        System.out.println(n1.equals(n3));
        System.out.println(AbstractGPNode.createNodeList());
    }

    public static String createNodeList() {
        Class<?>[] nodes;
        String ret = "";
        Class<AbstractGPNode> cls = AbstractGPNode.class;
        for (Class<?> c : nodes = ReflectPackage.getAssignableClassesInPackage(cls.getPackage().getName(), AbstractGPNode.class, true, false)) {
            if (Modifier.isAbstract(c.getModifiers()) || c.isInterface()) continue;
            try {
                AbstractGPNode node = (AbstractGPNode)c.newInstance();
                ret = ret + " (" + node.getOpIdentifier() + "," + node.getArity() + ")";
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static void test(String constr, double[] pos) {
        AbstractGPNode node = AbstractGPNode.parseFromString(constr);
        GPFunctionProblem func = new GPFunctionProblem(node, null, pos.length, 0.0, 0.0);
        double[] ret = func.evaluate(pos);
        System.out.println("testing " + constr + " evaluated to " + BeanInspector.toString(ret));
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public AbstractGPNode getNode(int index) {
        return this.nodes[index];
    }

    public void setNode(AbstractGPNode node, int index) {
        node.setParent(this);
        node.setDepth(this.depth + 1);
        this.nodes[index] = node;
    }

    public void setNode(AbstractGPNode newnode, AbstractGPNode oldnode) {
        newnode.setParent(this);
        newnode.updateDepth(this.depth + 1);
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] != oldnode) continue;
            this.nodes[i] = newnode;
        }
    }

    public void addNodesTo(ArrayList ListOfNodes) {
        ListOfNodes.add(this);
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i].addNodesTo(ListOfNodes);
        }
    }

    public AbstractGPNode getRandomNode() {
        ArrayList allNodes = new ArrayList(10);
        this.addNodesTo(allNodes);
        return (AbstractGPNode)allNodes.get(RNG.randomInt(allNodes.size()));
    }

    public AbstractGPNode getRandomLeaf() {
        if (this.nodes.length > 0) {
            int k = RNG.randomInt(this.nodes.length);
            return this.nodes[k].getRandomLeaf();
        }
        return this;
    }

    public void setParent(AbstractGPNode parent) {
        this.parentNode = parent;
    }

    public AbstractGPNode getParent() {
        return this.parentNode;
    }

    public void connect(AbstractGPNode parent) {
        this.parentNode = parent;
        this.depth = parent != null ? this.parentNode.getDepth() + 1 : 0;
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i].connect(this);
        }
    }

    public void initNodeArray() {
        this.nodes = new AbstractGPNode[this.getArity()];
    }

    public void initFull(GPArea area, int depth) {
        this.nodes = new AbstractGPNode[this.getArity()];
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i] = this.depth + 1 >= depth ? (AbstractGPNode)area.getRandomNodeWithArity(0).clone() : (AbstractGPNode)area.getRandomNonTerminal().clone();
            this.nodes[i].setDepth(this.depth + 1);
            this.nodes[i].setParent(this);
            this.nodes[i].initFull(area, depth);
        }
    }

    public void initGrow(GPArea area, int depth) {
        this.nodes = new AbstractGPNode[this.getArity()];
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i] = this.depth + 1 >= depth ? (AbstractGPNode)area.getRandomNodeWithArity(0).clone() : (AbstractGPNode)area.getRandomNode().clone();
            this.nodes[i].setDepth(this.depth + 1);
            this.nodes[i].setParent(this);
            this.nodes[i].initGrow(area, depth);
        }
    }

    public int getNumberOfNodes() {
        int result = 1;
        for (int i = 0; i < this.nodes.length; ++i) {
            result += this.nodes[i].getNumberOfNodes();
        }
        return result;
    }

    public int getMaxDepth() {
        int result = this.depth;
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            result = Math.max(result, this.nodes[i].getMaxDepth());
        }
        return result;
    }

    public int getSubtreeDepth() {
        int maxDepth = this.getMaxDepth();
        return maxDepth - this.depth;
    }

    public boolean isMaxDepthViolated(int maxDepth) {
        return maxDepth < this.getMaxDepth();
    }

    public void repairMaxDepth(GPArea area, int depth) {
        if (this.depth == depth - 1) {
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i].getArity() == 0) continue;
                this.nodes[i] = (AbstractGPNode)area.getRandomNodeWithArity(0).clone();
                this.nodes[i].setDepth(this.depth + 1);
                this.nodes[i].setParent(this);
            }
        } else {
            for (int i = 0; i < this.nodes.length; ++i) {
                this.nodes[i].repairMaxDepth(area, depth);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj.getClass().equals(this.getClass())) {
            AbstractGPNode node = (AbstractGPNode)obj;
            if (this.getArity() != node.getArity()) {
                return false;
            }
            if (this.nodes.length != node.nodes.length) {
                return false;
            }
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i].equals(node.nodes[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void updateDepth(int myDepth) {
        this.depth = myDepth;
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i].updateDepth(myDepth + 1);
        }
    }

    public boolean checkDepth(int myDepth) {
        if (this.depth != myDepth) {
            System.err.println("Depth was wrong at level " + myDepth);
            return false;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i].checkDepth(myDepth + 1)) continue;
            return false;
        }
        return true;
    }
}

