/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals.codings.gp;

import eva2.optimization.individuals.codings.gp.AbstractGPNode;
import eva2.tools.math.RNG;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;

public class GPArea
implements Serializable {
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ArrayList<AbstractGPNode> completeList = new ArrayList();
    private ArrayList<AbstractGPNode> reducedList = new ArrayList();
    private ArrayList<Boolean> blackList = new ArrayList();

    public GPArea() {
    }

    public GPArea(GPArea g) {
        if (g.blackList != null) {
            this.blackList = (ArrayList)g.blackList.clone();
        }
        if (g.reducedList != null) {
            this.reducedList = (ArrayList)g.reducedList.clone();
        }
        if (g.completeList != null) {
            this.completeList = (ArrayList)g.completeList.clone();
        }
    }

    public Object clone() {
        return new GPArea(this);
    }

    public void add2CompleteList(AbstractGPNode n) {
        this.completeList.add(n);
        this.blackList.add(Boolean.TRUE);
    }

    public void add2CompleteList(AbstractGPNode n, boolean b) {
        this.completeList.add(n);
        this.blackList.add(b);
    }

    public ArrayList<Boolean> getBlackList() {
        return this.blackList;
    }

    public void SetBlackList(ArrayList<Boolean> a) {
        this.blackList = a;
    }

    public void setBlackListElement(int i, boolean b) {
        this.blackList.set(i, b);
    }

    public ArrayList<AbstractGPNode> getCompleteList() {
        return this.completeList;
    }

    public ArrayList<AbstractGPNode> getReducedList() {
        return this.reducedList;
    }

    public void SetCompleteList(ArrayList<AbstractGPNode> a) {
        this.completeList = a;
        this.propertyChangeSupport.firePropertyChange("GPArea", null, this);
    }

    public void compileReducedList() {
        this.reducedList = new ArrayList();
        for (int i = 0; i < this.completeList.size(); ++i) {
            if (!this.blackList.get(i).booleanValue()) continue;
            this.reducedList.add(this.completeList.get(i));
        }
        this.propertyChangeSupport.firePropertyChange("GPArea", null, this);
    }

    public AbstractGPNode getRandomNodeWithArity(int targetarity) {
        ArrayList<AbstractGPNode> tmpArray = new ArrayList<AbstractGPNode>();
        for (int i = 0; i < this.reducedList.size(); ++i) {
            if (this.reducedList.get(i).getArity() != targetarity) continue;
            tmpArray.add(this.reducedList.get(i));
        }
        if (tmpArray.size() == 0) {
            return null;
        }
        return (AbstractGPNode)tmpArray.get(RNG.randomInt(0, tmpArray.size() - 1));
    }

    public AbstractGPNode getRandomNode() {
        if (this.reducedList.size() == 0) {
            return null;
        }
        return this.reducedList.get(RNG.randomInt(0, this.reducedList.size() - 1));
    }

    public AbstractGPNode getRandomNonTerminal() {
        ArrayList<AbstractGPNode> tmpArray = new ArrayList<AbstractGPNode>();
        for (int i = 0; i < this.reducedList.size(); ++i) {
            if (this.reducedList.get(i).getArity() <= 0) continue;
            tmpArray.add(this.reducedList.get(i));
        }
        if (tmpArray.size() == 0) {
            return null;
        }
        return (AbstractGPNode)tmpArray.get(RNG.randomInt(0, tmpArray.size() - 1));
    }

    public boolean isEmpty() {
        return this.completeList == null || this.completeList.size() == 0;
    }

    public void clear() {
        this.completeList = new ArrayList();
        this.reducedList = new ArrayList();
        this.blackList = new ArrayList();
        this.propertyChangeSupport.firePropertyChange("GPArea", null, this);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }
}

