/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals.codings.gp;

import eva2.optimization.individuals.codings.gp.AbstractGPNode;
import eva2.problems.InterfaceProgramProblem;
import java.io.Serializable;

public class GPNodeDiv
extends AbstractGPNode
implements Serializable {
    private double lowerBorderForSec = 1.0E-8;

    public GPNodeDiv() {
    }

    public GPNodeDiv(GPNodeDiv node) {
        this.lowerBorderForSec = node.lowerBorderForSec;
        this.cloneMembers(node);
    }

    @Override
    public String getName() {
        return "Div";
    }

    @Override
    public Object clone() {
        return new GPNodeDiv(this);
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    public Object evaluate(InterfaceProgramProblem environment) {
        double result = 1.0;
        double tmpValue = 0.0;
        Object tmpObj = this.nodes[0].evaluate(environment);
        if (tmpObj instanceof Double) {
            result = (Double)tmpObj;
        }
        for (int i = 1; i < this.nodes.length; ++i) {
            tmpObj = this.nodes[i].evaluate(environment);
            if (tmpObj instanceof Double) {
                tmpValue = (Double)tmpObj;
            }
            if (Math.abs(tmpValue) < this.lowerBorderForSec) {
                tmpValue = tmpValue < 0.0 ? -this.lowerBorderForSec : this.lowerBorderForSec;
            }
            result /= tmpValue;
        }
        return result;
    }

    @Override
    public String getOpIdentifier() {
        return "/";
    }
}

