/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals.codings.gp;

import eva2.optimization.individuals.codings.gp.AbstractGPNode;
import eva2.problems.InterfaceProgramProblem;
import java.io.Serializable;

public class GPNodeInput
extends AbstractGPNode
implements Serializable {
    private String identifier;
    private Object lastValue;

    public GPNodeInput() {
        this.identifier = "X";
    }

    public GPNodeInput(String identifier) {
        this.identifier = identifier;
    }

    public GPNodeInput(GPNodeInput node) {
        this.identifier = node.identifier;
        this.cloneMembers(node);
    }

    public void setIdentifier(String str) {
        this.identifier = str;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof GPNodeInput) {
            GPNodeInput node = (GPNodeInput)obj;
            return this.identifier.equalsIgnoreCase(node.identifier);
        }
        return false;
    }

    @Override
    public String getName() {
        return "Sensor:" + this.identifier;
    }

    @Override
    public Object clone() {
        return new GPNodeInput(this);
    }

    @Override
    public int getArity() {
        return 0;
    }

    @Override
    public Object evaluate(InterfaceProgramProblem environment) {
        this.lastValue = environment.getSensorValue(this.identifier);
        return this.lastValue;
    }

    @Override
    public String getOpIdentifier() {
        if (this.lastValue == null) {
            return this.identifier;
        }
        if (this.lastValue instanceof Double) {
            double tmpD;
            tmpD = (double)((long)(tmpD * 10000.0 + ((tmpD = ((Double)this.lastValue).doubleValue()) >= 0.0 ? 0.5 : -0.5))) / 10000.0;
            return "S:" + this.identifier + " = " + tmpD;
        }
        return "S:" + this.identifier + " = " + this.lastValue.toString();
    }
}

