/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.individuals.codings.gp;

import eva2.optimization.individuals.codings.gp.AbstractGPNode;
import eva2.problems.InterfaceProgramProblem;
import eva2.tools.math.Mathematics;
import java.io.Serializable;

public class GPNodeSum
extends AbstractGPNode
implements Serializable {
    public GPNodeSum() {
    }

    public GPNodeSum(GPNodeSum node) {
        this.cloneMembers(node);
    }

    @Override
    public String getName() {
        return "Sum";
    }

    @Override
    public Object clone() {
        return new GPNodeSum(this);
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public Object evaluate(InterfaceProgramProblem environment) {
        double result = 0.0;
        for (int i = 0; i < this.nodes.length; ++i) {
            Object tmpObj = this.nodes[i].evaluate(environment);
            if (tmpObj instanceof double[]) {
                result += Mathematics.sum((double[])tmpObj);
                continue;
            }
            if (tmpObj instanceof Double[]) {
                Double[] vals = (Double[])tmpObj;
                for (int j = 0; j < vals.length; ++j) {
                    result += vals[j].doubleValue();
                }
                continue;
            }
            if (!(tmpObj instanceof Double)) continue;
            result = (Double)tmpObj;
        }
        return result;
    }

    @Override
    public String getOpIdentifier() {
        return "sum";
    }
}

